// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.
//   Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
// //
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.
//   Terasic provides no warranty regarding the use
//   or functionality of this code.
// //
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue Oct 21 15:55:14 2025
// ============================================================================

`define ENABLE_LPDDR4A
`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM
//`define ENABLE_HDMI

module golden_top(
`ifndef ENABLE_LPDDR4B
      ///////// CLOCK /////////
      input             CLK_100_B2A_p,
`endif
      input              CLK_100_p,
      input              CLK_50_B5A,
//      input              CLK_50_B6A,
//      input              CLK_50_B6C,
//      input             CLK_50_B6F,
//      input              CLK_50_B6H,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active

      ///////// Switches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output           
      USER_LED, //USER_LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output   [ 1: 0]   LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output   
           LPDDR4A_CK,
      output   [ 1: 0]   LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0] 
      LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 
      5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 1: 0]   LPDDR4B_DM,
      inout    [15: 0]   LPDDR4B_DQ,
      inout    
      [ 1: 0]   LPDDR4B_DQS,
      inout    [ 1: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout     
         DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   
      HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      input              HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,
`endif /*ENABLE_HDMI*/

`ifdef ENABLE_CAM
  
     ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 3: 0]   CAM_D_p,
      input    [ 3: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
    
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ0,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout         
      HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
  
     output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout          
     HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              
      HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout    [ 1: 0]   HPS_LED,
      input       
        HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             
      HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p,
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
  
     input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output 
             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n, 
`endif /*ENABLE_HPS*/

      ///////// I2Cs /////////
      inout             
      FAN_I2C_SCL,
      inout              FAN_I2C_SDA,
      input              FAN_ALERT_n,

      ///////// PM /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input     
         PM_ALERT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D
);
//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================

wire ninit_done;
    agilex_reset_release agilex_reset_release_Inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );

//=======================================================
//  Debouncer for USER_BUTTON
//=======================================================
debouncer debouncer_Inst(
    .clk(CLK_50_B5A),
    .reset(ninit_done),
    .button_in(USER_BUTTON),
    .button_out(global_reset)
);

//=======================================================
//  Reset and Control Signals
//=======================================================
wire emif_rst_n_lpddr4a;
wire emif_rst_n_lpddr4b;
wire LPDDR4_IOPLL_Lock;
wire reset_handle;
assign reset_handle = LPDDR4_IOPLL_Lock & !ninit_done;

wire global_reset;
wire	aclk;
wire	aresetn;
wire	pipe_aresetn;
assign pipe_aresetn = global_reset & emif_rst_n_lpddr4a & emif_rst_n_lpddr4b & reset_handle;

//=======================================================
//  Test Status Signals
//=======================================================
//LPDDR4 Verify (A)
wire lpddr4a_test_pass/*synthesis keep*/;
wire lpddr4a_test_complete/*synthesis keep*/;
//LPDDR4 Verify (B)
wire lpddr4b_test_pass/*synthesis keep*/;
wire lpddr4b_test_complete/*synthesis keep*/;


//=======================================================
//  SEED and Pipeline
//=======================================================
localparam PIPEDEPTH = 10;
hyper_pipe #(.WIDTH(1), .NUM_PIPES(PIPEDEPTH)) read_data_pipe
			(.din(pipe_aresetn), .dout (aresetn), .clk (aclk));

reg	  [35:0] SEED_p;
wire    [17:0] SEED_p_sync;

always@(posedge aclk)
begin
	SEED_p <= {SEED_p_sync,SEED_p_sync};
end


//=======================================================
//  LPDDR4A AXI4 Interface Signals (4GB, 32-bit addr, 7-bit ID)
//=======================================================
// LPDDR4A RW Test
parameter LPDDR4A_AXI_ADDR_W 			= 32;
parameter LPDDR4A_AXI_ADDR_W_COUNT	= 32'h0000_2000;
parameter LPDDR4A_AXI_ADDR_W_START	= 32'h0000_0000;
parameter LPDDR4A_AXI_ADDR_W_END 	= 32'hFFFF_E000;
parameter LPDDR4A_AXI_DATA_W 			= 256;
parameter LPDDR4A_AXI_BURST_LENGHT 	= 8'h7f;
parameter LPDDR4A_AXI_ID_W			 	= 7;

wire 											LPDDR4A_awvalid;
wire 											LPDDR4A_awready;
wire	[6:0]									LPDDR4A_awid;
wire 	[LPDDR4A_AXI_ADDR_W-1:0]  		LPDDR4A_awaddr;
wire 	[7:0]        						LPDDR4A_awlen;
wire 	[2:0]        						LPDDR4A_awsize;
wire 	[1:0]        						LPDDR4A_awburst;
wire             							LPDDR4A_awlock;
wire 	[3:0]        						LPDDR4A_awcache;
wire 	[2:0]        						LPDDR4A_awprot;
wire            							LPDDR4A_wvalid;
wire             							LPDDR4A_wready;
wire 	[LPDDR4A_AXI_DATA_W-1:0] 		LPDDR4A_wdata;
wire 	[(LPDDR4A_AXI_DATA_W>>3)-1:0] LPDDR4A_wstrb;
wire             							LPDDR4A_wlast;
wire             							LPDDR4A_bvalid;
wire            							LPDDR4A_bready;
wire 	[6:0]  								LPDDR4A_bid;
wire 	[1:0]      							LPDDR4A_bresp;
wire            							LPDDR4A_arvalid;
wire             							LPDDR4A_arready;
wire 	[6:0]  								LPDDR4A_arid;
wire 	[LPDDR4A_AXI_ADDR_W-1:0]  		LPDDR4A_araddr;
wire 	[7:0]        						LPDDR4A_arlen;
wire 	[2:0]        						LPDDR4A_arsize;
wire 	[1:0]        						LPDDR4A_arburst;
wire             							LPDDR4A_arlock;
wire 	[3:0]        						LPDDR4A_arcache;
wire 	[2:0]        						LPDDR4A_arprot;
wire             							LPDDR4A_rvalid;
wire            							LPDDR4A_rready;
wire 	[6:0]  								LPDDR4A_rid;
wire 	[LPDDR4A_AXI_DATA_W-1:0]  		LPDDR4A_rdata;
wire 	[1:0]        						LPDDR4A_rresp;
wire             							LPDDR4A_rlast;

//=======================================================
//  LPDDR4B AXI4 Interface Signals (2GB, 31-bit addr, 6-bit ID)
//=======================================================
// LPDDR4B RW Test
parameter LPDDR4B_AXI_ADDR_W 			= 31;
parameter LPDDR4B_AXI_ADDR_W_COUNT	= 31'h000_2000;
parameter LPDDR4B_AXI_ADDR_W_START	= 31'h000_0000;
parameter LPDDR4B_AXI_ADDR_W_END 	= 31'h7FFF_E000;
parameter LPDDR4B_AXI_DATA_W 			= 256;
parameter LPDDR4B_AXI_BURST_LENGHT 	= 8'h7f;
parameter LPDDR4B_AXI_ID_W			 	= 6;

wire 											LPDDR4B_awvalid;
wire 											LPDDR4B_awready;
wire	[5:0]									LPDDR4B_awid;
wire 	[LPDDR4B_AXI_ADDR_W-1:0]  		LPDDR4B_awaddr;
wire 	[7:0]        						LPDDR4B_awlen;
wire 	[2:0]        						LPDDR4B_awsize;
wire 	[1:0]        						LPDDR4B_awburst;
wire             							LPDDR4B_awlock;
wire 	[3:0]        						LPDDR4B_awcache;
wire 	[2:0]        						LPDDR4B_awprot;
wire            							LPDDR4B_wvalid;
wire             							LPDDR4B_wready;
wire 	[LPDDR4B_AXI_DATA_W-1:0] 		LPDDR4B_wdata;
wire 	[(LPDDR4B_AXI_DATA_W>>3)-1:0] LPDDR4B_wstrb;
wire             							LPDDR4B_wlast;
wire             							LPDDR4B_bvalid;
wire            							LPDDR4B_bready;
wire 	[5:0]  								LPDDR4B_bid;
wire 	[1:0]      							LPDDR4B_bresp;
wire            							LPDDR4B_arvalid;
wire             							LPDDR4B_arready;
wire 	[5:0]  								LPDDR4B_arid;
wire 	[LPDDR4B_AXI_ADDR_W-1:0]  		LPDDR4B_araddr;
wire 	[7:0]        						LPDDR4B_arlen;
wire 	[2:0]        						LPDDR4B_arsize;
wire 	[1:0]        						LPDDR4B_arburst;
wire             							LPDDR4B_arlock;
wire 	[3:0]        						LPDDR4B_arcache;
wire 	[2:0]        						LPDDR4B_arprot;
wire             							LPDDR4B_rvalid;
wire            							LPDDR4B_rready;
wire 	[5:0]  								LPDDR4B_rid;
wire 	[LPDDR4B_AXI_DATA_W-1:0]  		LPDDR4B_rdata;
wire 	[1:0]        						LPDDR4B_rresp;
wire             							LPDDR4B_rlast;

//=======================================================
//  LPDDR4A axi4_master Instantiation
//=======================================================
 axi4_master LPDDR4A_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(!USER_SW[0]),
  /* input  [35:0]*/						.SEED_p(SEED_p),
  // AXI4 Master
  /* output */            				.awvalid(LPDDR4A_awvalid),
  /* input */             				.awready(LPDDR4A_awready),
 
  /* output [ID_WIDTH-1:0]*/    		.awid(LPDDR4A_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(LPDDR4A_awaddr),
  /* output [7:0]*/        			.awlen(LPDDR4A_awlen),
  /* output [2:0]*/        			.awsize(LPDDR4A_awsize),
  /* output [1:0]*/        			.awburst(LPDDR4A_awburst),
  /* output */             			.awlock(LPDDR4A_awlock),
  /* output [3:0]*/        			.awcache(LPDDR4A_awcache),
  /* output [2:0]*/        			.awprot(LPDDR4A_awprot),

  /* output */      						.wvalid(LPDDR4A_wvalid),
  /* input */             				.wready(LPDDR4A_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(LPDDR4A_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(LPDDR4A_wstrb),
  /* output */             			.wlast(LPDDR4A_wlast),

  /* input */             				.bvalid(LPDDR4A_bvalid),
  /* output */            				.bready(LPDDR4A_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(LPDDR4A_bid),
  /* input [1:0]*/     					.bresp(LPDDR4A_bresp),

  /* output */            				.arvalid(LPDDR4A_arvalid),
  /* input */             				.arready(LPDDR4A_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(LPDDR4A_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(LPDDR4A_araddr),
  /* output [7:0]*/        			.arlen(LPDDR4A_arlen),
  /* output [2:0]*/        			.arsize(LPDDR4A_arsize),
  /* output [1:0]*/        			.arburst(LPDDR4A_arburst),
  /* output */            				.arlock(LPDDR4A_arlock),
  /* output [3:0]*/        			.arcache(LPDDR4A_arcache),
  /* output [2:0]*/        			.arprot(LPDDR4A_arprot),

  /* input */             				.rvalid(LPDDR4A_rvalid),
  /* output */            				.rready(LPDDR4A_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(LPDDR4A_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(LPDDR4A_rdata),
  /* input [1:0]*/        				.rresp(LPDDR4A_rresp),
  /* input */             				.rlast(LPDDR4A_rlast),

 
  //
  /* output */            				.test_pass(lpddr4a_test_pass),
  /* output */            				.test_complete(lpddr4a_test_complete)

  );
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W 			= LPDDR4A_AXI_ADDR_W;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_COUNT 	= LPDDR4A_AXI_ADDR_W_COUNT;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_START 	= LPDDR4A_AXI_ADDR_W_START;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ADDR_W_END 		= LPDDR4A_AXI_ADDR_W_END;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_DATA_W 			= LPDDR4A_AXI_DATA_W;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_BURST_LENGHT 	= LPDDR4A_AXI_BURST_LENGHT;
defparam LPDDR4A_axi4_master_Inst.LPDDR4_AXI_ID_W 				= LPDDR4A_AXI_ID_W;


//=======================================================
//  LPDDR4B axi4_master Instantiation
//=======================================================
 axi4_master LPDDR4B_axi4_master_Inst(
  /* input */             				.aclk(aclk),
  /* input */             				.aresetn(aresetn),
  /* input */             				.insert_error_n(!USER_SW[0]),
  /* input  [35:0]*/						.SEED_p(SEED_p),

  // AXI4 Master
  /* output */            				.awvalid(LPDDR4B_awvalid),
  /* input */      						.awready(LPDDR4B_awready),
  /* output [ID_WIDTH-1:0]*/    		.awid(LPDDR4B_awid),
  /* output [ADDR_WIDTH-1:0]*/  		.awaddr(LPDDR4B_awaddr),
  /* output [7:0]*/        			.awlen(LPDDR4B_awlen),
  /* output [2:0]*/        			.awsize(LPDDR4B_awsize),
  /* output [1:0]*/        			.awburst(LPDDR4B_awburst),
  /* output */             			.awlock(LPDDR4B_awlock),
  /* output [3:0]*/        			.awcache(LPDDR4B_awcache),
  /* output [2:0]*/        			.awprot(LPDDR4B_awprot),

  
  /* output */            				.wvalid(LPDDR4B_wvalid),
  /* input */             				.wready(LPDDR4B_wready),
  /* output [DATA_WIDTH-1:0]*/  		.wdata(LPDDR4B_wdata),
  /* output [(DATA_WIDTH/8)-1:0]*/  .wstrb(LPDDR4B_wstrb),
  /* output */             			.wlast(LPDDR4B_wlast),
  /* input */             				.bvalid(LPDDR4B_bvalid),
  /* output */            				.bready(LPDDR4B_bready),
  /* input [ID_WIDTH-1:0]*/  			.bid(LPDDR4B_bid),
  /* input [1:0]*/        				.bresp(LPDDR4B_bresp),
  /* output */            				.arvalid(LPDDR4B_arvalid),
  /* input */             				.arready(LPDDR4B_arready),
  /* output [ID_WIDTH-1:0]*/  		.arid(LPDDR4B_arid),
  /* output [ADDR_WIDTH-1:0]*/  		.araddr(LPDDR4B_araddr),
  /* output [7:0]*/        			.arlen(LPDDR4B_arlen),
  /* output [2:0]*/        			.arsize(LPDDR4B_arsize),
  /* output [1:0]*/        			.arburst(LPDDR4B_arburst),
  /* output */    						.arlock(LPDDR4B_arlock),
  /* output [3:0]*/        			.arcache(LPDDR4B_arcache),
  /* output [2:0]*/        			.arprot(LPDDR4B_arprot),

  /* input */             				.rvalid(LPDDR4B_rvalid),
  /* output */            				.rready(LPDDR4B_rready),
  /* input [ID_WIDTH-1:0]*/  			.rid(LPDDR4B_rid),
  /* input [DATA_WIDTH-1:0]*/  		.rdata(LPDDR4B_rdata),
  /* input [1:0]*/        				.rresp(LPDDR4B_rresp),
  /* input */      						.rlast(LPDDR4B_rlast),

  //
  /* output */            				.test_pass(lpddr4b_test_pass),
  /* output */            				.test_complete(lpddr4b_test_complete)

  );
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W 			= LPDDR4B_AXI_ADDR_W;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_COUNT 	= LPDDR4B_AXI_ADDR_W_COUNT;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_START 	= LPDDR4B_AXI_ADDR_W_START;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ADDR_W_END 		= LPDDR4B_AXI_ADDR_W_END;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_DATA_W 			= LPDDR4B_AXI_DATA_W;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_BURST_LENGHT 	= LPDDR4B_AXI_BURST_LENGHT;
defparam LPDDR4B_axi4_master_Inst.LPDDR4_AXI_ID_W 				= LPDDR4B_AXI_ID_W;


//=======================================================
//  AXI-Lite Driver Calibration Logic (Added from Reference)
//=======================================================
wire AXI_LITE_CLK;
parameter AXIL_DRIVER_ADDRESS_WIDTH = 27; 

// LPDDR4A Calibration Wires
wire  												LPDDR4A_axil_driver_clk;
wire  												LPDDR4A_axil_driver_rst_n;
wire  [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]	LPDDR4A_axil_driver_araddr;
wire  [2:0]											LPDDR4A_axil_driver_arprot;
wire  												LPDDR4A_axil_driver_arvalid;
wire  												LPDDR4A_axil_driver_arready;
wire  [31:0]										LPDDR4A_axil_driver_rdata;
wire  [1:0]											LPDDR4A_axil_driver_rresp;
wire  												LPDDR4A_axil_driver_rvalid;
wire                                      LPDDR4A_axil_driver_rready;
wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]  LPDDR4A_axil_driver_awaddr;
wire   [2:0]                              LPDDR4A_axil_driver_awprot;
wire                                      LPDDR4A_axil_driver_awvalid;
wire                                      LPDDR4A_axil_driver_awready;
wire   [31:0]                             LPDDR4A_axil_driver_wdata;
wire   [3:0]                              LPDDR4A_axil_driver_wstrb;
wire                                      LPDDR4A_axil_driver_wvalid;
wire                                      LPDDR4A_axil_driver_wready;
wire   [1:0]                              LPDDR4A_axil_driver_bresp;
wire                                      LPDDR4A_axil_driver_bvalid;
wire                                      LPDDR4A_axil_driver_bready;
wire													LPDDR4A_cal_done_rst_n;

// LPDDR4A Calibration Instance
axil_driver_calibration LPDDR4A_axil_driver_calibration_Inst(
   /*input    wire                          */    .axil_driver_clk(AXI_LITE_CLK),
   /*input    wire                          */    .axil_driver_rst_n(reset_handle), // Changed to reset_handle to automate
   /*output   wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_araddr(LPDDR4A_axil_driver_araddr),
   /*output   wire   [2:0]                               */    .axil_driver_arprot(LPDDR4A_axil_driver_arprot),
   /*output   wire                                       */    .axil_driver_arvalid(LPDDR4A_axil_driver_arvalid),
   /*input    wire                                       */    .axil_driver_arready(LPDDR4A_axil_driver_arready),
   /*input    wire   [31:0]                              */    .axil_driver_rdata(LPDDR4A_axil_driver_rdata),
   /*input    wire   [1:0]                               */    .axil_driver_rresp(LPDDR4A_axil_driver_rresp),
   /*input    wire                                       */    .axil_driver_rvalid(LPDDR4A_axil_driver_rvalid),
    
   /*output   wire                                       */    .axil_driver_rready(LPDDR4A_axil_driver_rready),
   /*output   wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_awaddr(LPDDR4A_axil_driver_awaddr),
   /*output   wire   [2:0]                               */    .axil_driver_awprot(LPDDR4A_axil_driver_awprot),
   /*output   wire                                       */    .axil_driver_awvalid(LPDDR4A_axil_driver_awvalid),
   /*input    wire                                       */    .axil_driver_awready(LPDDR4A_axil_driver_awready),
   /*output   wire   [31:0]                              */    .axil_driver_wdata(LPDDR4A_axil_driver_wdata),
   /*output   wire   [3:0]                               */    .axil_driver_wstrb(LPDDR4A_axil_driver_wstrb),
   /*output   wire                                       */    .axil_driver_wvalid(LPDDR4A_axil_driver_wvalid),
   /*input    wire                                       */    .axil_driver_wready(LPDDR4A_axil_driver_wready),
   /*input    wire   [1:0]                               */    .axil_driver_bresp(LPDDR4A_axil_driver_bresp),
   /*input    wire                                       */    .axil_driver_bvalid(LPDDR4A_axil_driver_bvalid),
   /*output   wire                                       */    .axil_driver_bready(LPDDR4A_axil_driver_bready),
   /*output   wire                                       */    .cal_done_rst_n(LPDDR4A_cal_done_rst_n)
    
);
defparam LPDDR4A_axil_driver_calibration_Inst.AXIL_DRIVER_ADDRESS_WIDTH = AXIL_DRIVER_ADDRESS_WIDTH; 

// LPDDR4B Calibration Wires
wire  												LPDDR4B_axil_driver_clk;
wire  												LPDDR4B_axil_driver_rst_n;
wire  [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]	LPDDR4B_axil_driver_araddr;
wire  [2:0]											LPDDR4B_axil_driver_arprot;
wire  												LPDDR4B_axil_driver_arvalid;
wire  												LPDDR4B_axil_driver_arready;
wire  [31:0]										LPDDR4B_axil_driver_rdata;
wire  [1:0]											LPDDR4B_axil_driver_rresp;
wire  												LPDDR4B_axil_driver_rvalid;
wire                                      LPDDR4B_axil_driver_rready;
wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]  LPDDR4B_axil_driver_awaddr;
wire   [2:0]                              LPDDR4B_axil_driver_awprot;
wire                                      LPDDR4B_axil_driver_awvalid;
wire                                      LPDDR4B_axil_driver_awready;
wire   [31:0]                             LPDDR4B_axil_driver_wdata;
wire   [3:0]                              LPDDR4B_axil_driver_wstrb;
wire                                      LPDDR4B_axil_driver_wvalid;
wire                                      LPDDR4B_axil_driver_wready;
wire   [1:0]                              LPDDR4B_axil_driver_bresp;
wire                                      LPDDR4B_axil_driver_bvalid;
wire                                      LPDDR4B_axil_driver_bready;
wire													LPDDR4B_cal_done_rst_n;

// LPDDR4B Calibration Instance
axil_driver_calibration LPDDR4B_axil_driver_calibration_Inst(
   /*input    wire                          */    .axil_driver_clk(AXI_LITE_CLK),
   /*input    wire                          */    .axil_driver_rst_n(reset_handle), // Changed to reset_handle to automate
   /*output   wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_araddr(LPDDR4B_axil_driver_araddr),
   /*output   wire   [2:0]                               */    .axil_driver_arprot(LPDDR4B_axil_driver_arprot),
   /*output   wire                                       */    .axil_driver_arvalid(LPDDR4B_axil_driver_arvalid),
   /*input    wire                                       */    .axil_driver_arready(LPDDR4B_axil_driver_arready),
   /*input    wire   [31:0]                              */    .axil_driver_rdata(LPDDR4B_axil_driver_rdata),
   /*input    wire   [1:0]                               */    .axil_driver_rresp(LPDDR4B_axil_driver_rresp),
   /*input    wire                                       */    .axil_driver_rvalid(LPDDR4B_axil_driver_rvalid),
    
   /*output   wire                                       */    .axil_driver_rready(LPDDR4B_axil_driver_rready),
   /*output   wire   [AXIL_DRIVER_ADDRESS_WIDTH - 1:0]   */    .axil_driver_awaddr(LPDDR4B_axil_driver_awaddr),
   /*output   wire   [2:0]                               */    .axil_driver_awprot(LPDDR4B_axil_driver_awprot),
   /*output   wire                                       */    .axil_driver_awvalid(LPDDR4B_axil_driver_awvalid),
   /*input    wire                                       */    .axil_driver_awready(LPDDR4B_axil_driver_awready),
   /*output   wire   [31:0]                              */    .axil_driver_wdata(LPDDR4B_axil_driver_wdata),
   /*output   wire   [3:0]                               */    .axil_driver_wstrb(LPDDR4B_axil_driver_wstrb),
   /*output   wire                                       */    .axil_driver_wvalid(LPDDR4B_axil_driver_wvalid),
   /*input    wire                                       */    .axil_driver_wready(LPDDR4B_axil_driver_wready),
   /*input    wire   [1:0]                               */    .axil_driver_bresp(LPDDR4B_axil_driver_bresp),
   /*input    wire                                       */    .axil_driver_bvalid(LPDDR4B_axil_driver_bvalid),
   /*output   wire                                       */    .axil_driver_bready(LPDDR4B_axil_driver_bready),
   /*output   wire                                       */    .cal_done_rst_n(LPDDR4B_cal_done_rst_n)
    
);
defparam LPDDR4B_axil_driver_calibration_Inst.AXIL_DRIVER_ADDRESS_WIDTH = AXIL_DRIVER_ADDRESS_WIDTH; 



//=======================================================
//  Qsys Platform Designer Instantiation
//=======================================================
    Qsys Qsys_Inst (
        // Clock and Reset
        .clock_310m_out_clk_clk                   (aclk),
        .clk_clk                                  (CLK_50_B5A),
        .reset_reset_n                            (!ninit_done),

        // LPDDR4A AXI4 Interface
        .emif_lpddr4a_s0_axi4_ctrl_ready_reset_n  (emif_rst_n_lpddr4a),
        .emif_lpddr4a_s0_axi4_awaddr              (LPDDR4A_awaddr),
        .emif_lpddr4a_s0_axi4_awburst             (LPDDR4A_awburst),
        .emif_lpddr4a_s0_axi4_awid                (LPDDR4A_awid),
        .emif_lpddr4a_s0_axi4_awlen               (LPDDR4A_awlen),
        .emif_lpddr4a_s0_axi4_awlock              (LPDDR4A_awlock),
        .emif_lpddr4a_s0_axi4_awqos               (4'b0),
        .emif_lpddr4a_s0_axi4_awsize              (LPDDR4A_awsize),
        .emif_lpddr4a_s0_axi4_awvalid             (LPDDR4A_awvalid),
        .emif_lpddr4a_s0_axi4_awuser              (14'b0),
        .emif_lpddr4a_s0_axi4_awprot              (LPDDR4A_awprot),
        .emif_lpddr4a_s0_axi4_awready             (LPDDR4A_awready),
        .emif_lpddr4a_s0_axi4_araddr              (LPDDR4A_araddr),
        .emif_lpddr4a_s0_axi4_arburst             (LPDDR4A_arburst),
        .emif_lpddr4a_s0_axi4_arid                (LPDDR4A_arid),
        .emif_lpddr4a_s0_axi4_arlen               (LPDDR4A_arlen),
        .emif_lpddr4a_s0_axi4_arlock              (LPDDR4A_arlock),
        .emif_lpddr4a_s0_axi4_arqos               (4'b0),
        .emif_lpddr4a_s0_axi4_arsize              (LPDDR4A_arsize),
        .emif_lpddr4a_s0_axi4_arvalid             (LPDDR4A_arvalid),
        .emif_lpddr4a_s0_axi4_aruser              (14'b0),
        .emif_lpddr4a_s0_axi4_arprot              (LPDDR4A_arprot),
        .emif_lpddr4a_s0_axi4_arready             (LPDDR4A_arready),
        .emif_lpddr4a_s0_axi4_wdata               (LPDDR4A_wdata),
        .emif_lpddr4a_s0_axi4_wstrb               (LPDDR4A_wstrb),
        .emif_lpddr4a_s0_axi4_wlast               (LPDDR4A_wlast),
        .emif_lpddr4a_s0_axi4_wvalid              (LPDDR4A_wvalid),
        .emif_lpddr4a_s0_axi4_wready              (LPDDR4A_wready),
        .emif_lpddr4a_s0_axi4_bready              (LPDDR4A_bready),
        .emif_lpddr4a_s0_axi4_bid                 (LPDDR4A_bid),
        .emif_lpddr4a_s0_axi4_bresp               (LPDDR4A_bresp),
        .emif_lpddr4a_s0_axi4_bvalid              (LPDDR4A_bvalid),
        .emif_lpddr4a_s0_axi4_rready              (LPDDR4A_rready),
        .emif_lpddr4a_s0_axi4_rdata               (LPDDR4A_rdata),
        .emif_lpddr4a_s0_axi4_rid                 (LPDDR4A_rid),
        .emif_lpddr4a_s0_axi4_rlast               (LPDDR4A_rlast),
        .emif_lpddr4a_s0_axi4_rresp               (LPDDR4A_rresp),
        .emif_lpddr4a_s0_axi4_rvalid              (LPDDR4A_rvalid),

        // LPDDR4A AXI4-Lite Interface
        .emif_lpddr4a_s0_axi4lite_clock_clk       (AXI_LITE_CLK),
        .emif_lpddr4a_s0_axi4lite_reset_n_reset_n (reset_handle),
        .emif_lpddr4a_s0_axi4lite_awaddr          (LPDDR4A_axil_driver_awaddr),
        .emif_lpddr4a_s0_axi4lite_awprot          (LPDDR4A_axil_driver_awprot),
        .emif_lpddr4a_s0_axi4lite_awvalid         (LPDDR4A_axil_driver_awvalid),
        .emif_lpddr4a_s0_axi4lite_awready         (LPDDR4A_axil_driver_awready),
        .emif_lpddr4a_s0_axi4lite_araddr          (LPDDR4A_axil_driver_araddr),
        .emif_lpddr4a_s0_axi4lite_arprot          (LPDDR4A_axil_driver_arprot),
        .emif_lpddr4a_s0_axi4lite_arvalid         (LPDDR4A_axil_driver_arvalid),
        .emif_lpddr4a_s0_axi4lite_arready         (LPDDR4A_axil_driver_arready),
        .emif_lpddr4a_s0_axi4lite_wdata           (LPDDR4A_axil_driver_wdata),
        .emif_lpddr4a_s0_axi4lite_wstrb           (LPDDR4A_axil_driver_wstrb),
        .emif_lpddr4a_s0_axi4lite_wvalid          (LPDDR4A_axil_driver_wvalid),
        .emif_lpddr4a_s0_axi4lite_wready          (LPDDR4A_axil_driver_wready),
        .emif_lpddr4a_s0_axi4lite_bready          (LPDDR4A_axil_driver_bready),
        .emif_lpddr4a_s0_axi4lite_bresp           (LPDDR4A_axil_driver_bresp),
        .emif_lpddr4a_s0_axi4lite_bvalid          (LPDDR4A_axil_driver_bvalid),
        .emif_lpddr4a_s0_axi4lite_rready          (LPDDR4A_axil_driver_rready),
        .emif_lpddr4a_s0_axi4lite_rdata           (LPDDR4A_axil_driver_rdata),
        .emif_lpddr4a_s0_axi4lite_rresp           (LPDDR4A_axil_driver_rresp),
        .emif_lpddr4a_s0_axi4lite_rvalid          (LPDDR4A_axil_driver_rvalid),

        // LPDDR4A Memory Interface
        .emif_lpddr4a_mem_mem_cs                  (LPDDR4A_CS_n),
        .emif_lpddr4a_mem_mem_ca                  (LPDDR4A_CA),
        .emif_lpddr4a_mem_mem_cke                 (LPDDR4A_CKE),
        .emif_lpddr4a_mem_mem_dq                  (LPDDR4A_DQ),
        .emif_lpddr4a_mem_mem_dqs_t               (LPDDR4A_DQS),
        .emif_lpddr4a_mem_mem_dqs_c               (LPDDR4A_DQS_n),
        .emif_lpddr4a_mem_mem_dmi                 (LPDDR4A_DM),
        .emif_lpddr4a_mem_ck_mem_ck_t             (LPDDR4A_CK),
        .emif_lpddr4a_mem_ck_mem_ck_c             (LPDDR4A_CK_n),
        .emif_lpddr4a_mem_reset_n_mem_reset_n     (LPDDR4A_RESET_n),
        .emif_lpddr4a_oct_oct_rzqin               (LPDDR4A_RZQ),
        .emif_lpddr4a_ref_clk_clk                 (LPDDR4A_REFCLK_p),

        // LPDDR4B AXI4 Interface
        .emif_lpddr4b_s0_axi4_ctrl_ready_reset_n  (emif_rst_n_lpddr4b),
        .emif_lpddr4b_s0_axi4_awaddr              (LPDDR4B_awaddr),
        .emif_lpddr4b_s0_axi4_awburst             (LPDDR4B_awburst),
        .emif_lpddr4b_s0_axi4_awid                (LPDDR4B_awid),
        .emif_lpddr4b_s0_axi4_awlen               (LPDDR4B_awlen),
        .emif_lpddr4b_s0_axi4_awlock              (LPDDR4B_awlock),
        .emif_lpddr4b_s0_axi4_awqos               (4'b0),
        .emif_lpddr4b_s0_axi4_awsize              (LPDDR4B_awsize),
        .emif_lpddr4b_s0_axi4_awvalid             (LPDDR4B_awvalid),
        .emif_lpddr4b_s0_axi4_awuser              (14'b0),
        .emif_lpddr4b_s0_axi4_awprot              (LPDDR4B_awprot),
        .emif_lpddr4b_s0_axi4_awready             (LPDDR4B_awready),
        .emif_lpddr4b_s0_axi4_araddr              (LPDDR4B_araddr),
        .emif_lpddr4b_s0_axi4_arburst             (LPDDR4B_arburst),
        .emif_lpddr4b_s0_axi4_arid                (LPDDR4B_arid),
        .emif_lpddr4b_s0_axi4_arlen               (LPDDR4B_arlen),
        .emif_lpddr4b_s0_axi4_arlock              (LPDDR4B_arlock),
        .emif_lpddr4b_s0_axi4_arqos               (4'b0),
        .emif_lpddr4b_s0_axi4_arsize              (LPDDR4B_arsize),
        .emif_lpddr4b_s0_axi4_arvalid             (LPDDR4B_arvalid),
        .emif_lpddr4b_s0_axi4_aruser              (14'b0),
        .emif_lpddr4b_s0_axi4_arprot              (LPDDR4B_arprot),
        .emif_lpddr4b_s0_axi4_arready             (LPDDR4B_arready),
        .emif_lpddr4b_s0_axi4_wdata               (LPDDR4B_wdata),
        .emif_lpddr4b_s0_axi4_wstrb               (LPDDR4B_wstrb),
        .emif_lpddr4b_s0_axi4_wlast               (LPDDR4B_wlast),
        .emif_lpddr4b_s0_axi4_wvalid              (LPDDR4B_wvalid),
        .emif_lpddr4b_s0_axi4_wready              (LPDDR4B_wready),
        .emif_lpddr4b_s0_axi4_bready              (LPDDR4B_bready),
        .emif_lpddr4b_s0_axi4_bid                 (LPDDR4B_bid),
        .emif_lpddr4b_s0_axi4_bresp               (LPDDR4B_bresp),
        .emif_lpddr4b_s0_axi4_bvalid              (LPDDR4B_bvalid),
        .emif_lpddr4b_s0_axi4_rready              (LPDDR4B_rready),
        .emif_lpddr4b_s0_axi4_rdata               (LPDDR4B_rdata),
        .emif_lpddr4b_s0_axi4_rid                 (LPDDR4B_rid),
        .emif_lpddr4b_s0_axi4_rlast               (LPDDR4B_rlast),
        .emif_lpddr4b_s0_axi4_rresp               (LPDDR4B_rresp),
        .emif_lpddr4b_s0_axi4_rvalid              (LPDDR4B_rvalid),

        // LPDDR4B AXI4-Lite Interface
        .emif_lpddr4b_s0_axi4lite_clock_clk       (AXI_LITE_CLK),
        .emif_lpddr4b_s0_axi4lite_reset_n_reset_n (reset_handle),
        .emif_lpddr4b_s0_axi4lite_awaddr          (LPDDR4B_axil_driver_awaddr),
        .emif_lpddr4b_s0_axi4lite_awprot          (LPDDR4B_axil_driver_awprot),
        .emif_lpddr4b_s0_axi4lite_awvalid         (LPDDR4B_axil_driver_awvalid),
        .emif_lpddr4b_s0_axi4lite_awready         (LPDDR4B_axil_driver_awready),
        .emif_lpddr4b_s0_axi4lite_araddr          (LPDDR4B_axil_driver_araddr),
        .emif_lpddr4b_s0_axi4lite_arprot          (LPDDR4B_axil_driver_arprot),
        .emif_lpddr4b_s0_axi4lite_arvalid         (LPDDR4B_axil_driver_arvalid),
        .emif_lpddr4b_s0_axi4lite_arready         (LPDDR4B_axil_driver_arready),
        .emif_lpddr4b_s0_axi4lite_wdata           (LPDDR4B_axil_driver_wdata),
        .emif_lpddr4b_s0_axi4lite_wstrb           (LPDDR4B_axil_driver_wstrb),
        .emif_lpddr4b_s0_axi4lite_wvalid          (LPDDR4B_axil_driver_wvalid),
        .emif_lpddr4b_s0_axi4lite_wready          (LPDDR4B_axil_driver_wready),
        .emif_lpddr4b_s0_axi4lite_bready          (LPDDR4B_axil_driver_bready),
        .emif_lpddr4b_s0_axi4lite_bresp           (LPDDR4B_axil_driver_bresp),
        .emif_lpddr4b_s0_axi4lite_bvalid          (LPDDR4B_axil_driver_bvalid),
        .emif_lpddr4b_s0_axi4lite_rready          (LPDDR4B_axil_driver_rready),
        .emif_lpddr4b_s0_axi4lite_rdata           (LPDDR4B_axil_driver_rdata),
        .emif_lpddr4b_s0_axi4lite_rresp           (LPDDR4B_axil_driver_rresp),
        .emif_lpddr4b_s0_axi4lite_rvalid          (LPDDR4B_axil_driver_rvalid),

        // LPDDR4B Memory Interface
        .emif_lpddr4b_mem_mem_cs                  (LPDDR4B_CS_n),
        .emif_lpddr4b_mem_mem_ca                  (LPDDR4B_CA),
        .emif_lpddr4b_mem_mem_cke                 (LPDDR4B_CKE),
        .emif_lpddr4b_mem_mem_dq                  (LPDDR4B_DQ),
        .emif_lpddr4b_mem_mem_dqs_t               (LPDDR4B_DQS),
        .emif_lpddr4b_mem_mem_dqs_c               (LPDDR4B_DQS_n),
        .emif_lpddr4b_mem_mem_dmi                 (LPDDR4B_DM),
        .emif_lpddr4b_mem_ck_mem_ck_t             (LPDDR4B_CK),
        .emif_lpddr4b_mem_ck_mem_ck_c             (LPDDR4B_CK_n),
        .emif_lpddr4b_mem_reset_n_mem_reset_n     (LPDDR4B_RESET_n),
        .emif_lpddr4b_oct_oct_rzqin               (LPDDR4B_RZQ),
        .emif_lpddr4b_ref_clk_clk                 (LPDDR4B_REFCLK_p),

        // PLL
        .iopll_locked_export                      (LPDDR4_IOPLL_Lock),
        .iopll_outclk_axi4_lite_clk               (AXI_LITE_CLK)
    );


//=======================================================
//  USER_LED Output Logic (Low-Active)
//  LED ON when: LPDDR4A and LPDDR4B both calibration done + test pass + test complete
//=======================================================
wire heart_led;
heart_beat  heart_beat_0 ( .CLK(CLK_50_B5A ),     .CLK_FREQ  (50_000_000) , . CK_1HZ (heart_led) );



wire cal_pass = emif_rst_n_lpddr4a & emif_rst_n_lpddr4b;
wire test_done = lpddr4a_test_pass & lpddr4a_test_complete &
                 lpddr4b_test_pass & lpddr4b_test_complete;

assign USER_LED = (cal_pass & test_done) ? 1'b0 :   
                  (!cal_pass) ? heart_led :          
                  1'b1;                             

endmodule