module debouncer (
    input wire clk,         // clock signal
    input wire reset,       // reset signal
    input wire button_in,   // raw button input
    output reg button_out   // debounced button output
);

    // Parameter for the debounce time
    parameter integer DEBOUNCE_TIME = 1000000; // Adjust this value as needed

    // State definitions
    reg [31:0] counter;     // counter for debouncing
    reg button_sync_0, button_sync_1; // synchronized button input

    // Synchronize the button input to the clock
    always @(posedge clk or posedge reset) begin
        if (reset) begin
            button_sync_0 <= 1'b0;
            button_sync_1 <= 1'b0;
        end else begin
            button_sync_0 <= button_in;
            button_sync_1 <= button_sync_0;
        end
    end

    // Debouncing logic
    always @(posedge clk or posedge reset) begin
        if (reset) begin
            counter <= 0;
            button_out <= 1'b0;
        end else begin
            if (button_sync_1 == button_out) begin
                counter <= 0; // reset counter if the state is stable
            end else begin
                counter <= counter + 1;
                if (counter >= DEBOUNCE_TIME) begin
                    button_out <= button_sync_1;
                    counter <= 0;
                end
            end
        end
    end

endmodule
