// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.





 


`timescale 1ns / 100ps



module ed_synth_dut_timing_adapter_1940_5ju4ddy #(parameter SYNC_RESET = 0)
(  
 input               in_valid,
 input     [8-1: 0]  in_data,
 input               out_ready,
 output reg          out_valid,
 output reg [8-1: 0] out_data,
 input              clk,
 input              reset_n

 /*AUTOARG*/);

   
   reg [8-1:0]   in_payload;
   reg [8-1:0]   out_payload;
   reg [1-1:0]   ready;   
   reg           in_ready;
   // synthesis translate_off
   always @(negedge in_ready) begin
      $display("%m: The downstream component is backpressuring by deasserting ready, but the upstream component can't be backpressured.");
   end
   // synthesis translate_on   

   always @* begin
     in_payload = {in_data};
     {out_data} = out_payload;
   end

   always_comb begin
     ready[0]    = out_ready;
     out_valid = in_valid;
     out_payload = in_payload;
     in_ready    = ready[0];
   end

generate if(SYNC_RESET == 0) begin

end
else begin
reg internal_sclr;
always @ (posedge clk) begin
internal_sclr <= reset_n;
end

end
endgenerate

endmodule


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "TCSI+l9TsvpNm5zWo4wf8S4CBVeml6hxYnRcvYFHGVdKrV70QtjK/Q97rnYnju29dHEElln5C63xhDaAHrDBjpTVdTMpcZmuTN8lZKh5UsIF1+KNWjGCPGEcQfOpPms/DsTE+mwaq652nt9MxysR2++l9VLHamXPFWmxpBLBMiG3v0i3UjbzPV6heoBbtnxsCXSHasHlrPtUh5zo5ECSylkvBjcVwStL/mWtlrEp1x9BH85TcvWFHx6SN+00Fxn/vJXZ5pfNdHr9TsezBlIv7LYhohI6xR6wEAyUbS8z6HYs2kA4sy5v9GLV+GYJAcBYThBG9G0be98xk8glubGSprpQ4TApYXkdjbOp8u4dqDCWvF3gaps8Nj4I0G5VC7Zdz98E84XBAYOv3WHqhs5WRe7JcN/sm32sYpc1U6EOaegWEf9/NhOakkjAJwR1hESBbfjLVxI6HnxnrvdhEp/HoxhjfpE0LOhDtg5X7fcOoPJtuv89ujGncvD7vFJ6iKaW/FA/lc69Qygfm3Y0ks3/BC/a37Zx2PszP/iQzyYSUJ1tAFYpAsfi+oyiLdNKlXvtHkg0367Z/mPNlQw5vIU/wGaFtgbhI9n+NZkJG6KzTWBqp5WZltit7TuGkqTXKYDDOQaeQFOhHeYcXfrflATcEBXodhzQY0eU/mmKaMk6RoHYcAbHo36i3WWJ0jIfU30QUKxgmQ2IsJc9JMc2wOKyw+ZMmrgtAP9m8WjWkADtwji843MTz/QJcOG/WbnFd01746t7Pw1XZioj2W6/smCysmVGwvYZxVH2IV5Z8Wk4P9PJztAMMUf0+iynsyPah04Nlti6Hyil8nBxEJxMX1bv9C4cgTvRd6DlTej8FsYgtMsTD3hV2UheDTUJWlEXLxb7ZiKe+WNORnL5iqX2rKB5elmbQ7X2ar1FKR0lxtrTcc84VQSOfb6pKBgKZ0tuY1aItPv8bAOK2YArNwjZ74wvn4BbfpGaOEKbpXM5LZSjsoMNf8xMQdTq8uc5MIGIDQlA"
`endif