// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



// synthesis translate_off        

`ifdef DPHY_BHV_SIM
`define BHV_BYTE_CONTROL 1
`endif

`ifdef BHV_BYTE_CONTROL
`define byte_control_name dphy_byte_control_bhv
`endif

`define SIM 1

// synthesis translate_on        

`ifndef byte_control_name
`define byte_control_name tennm_byte_control
`endif

`undef REVA


module dphy_byte_control_wrap #(
    parameter DEV_FAMILY = "FAMILY_AGILEX5",            
    parameter BYTE_LOC = 0,
    parameter DPHY_RX_EN = 0,
    parameter DPHY_TX_EN = 0,
    parameter BYTE_N = 0,
    parameter BYTE_CNT = 1,
    parameter NUM_LANES = 0,
    parameter CONTINUOUS_CLK = 0,
    parameter RX_DLANE_DESKEW_DELAY = 0,
    parameter BIT_RATE = 36'd3200000000,
    parameter VCO_FREQ = 36'd3200000000,
    parameter TX_CLK_LANE_PS = 0,
    parameter VCCN_VOLTAGE = "VCCN_VOLTAGE_1P2V"
) ( 
    output logic [1:0] 	o_phyctrl_rddata_valid_upper, 
    output logic [1:0] 	o_phyctrl_rddata_valid_lower, 
    output logic [1:0] 	o_phyctrl_dqs_en4_del, 
    output logic [1:0] 	o_phyctrl_dqs_en5_del, 
    output logic [1:0] 	o_phyctrl_dqs_en6_del, 
    output logic [1:0] 	o_phyctrl_dqs_en7_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en0_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en1_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en2_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en3_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en8_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en9_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en10_del, 
    output logic [1:0] 	o_phyctrl_wrdata_en11_del, 
    output logic [3:0] 	o_phyctrl_tx_picode0, 
    output logic [3:0] 	o_phyctrl_tx_picode1, 
    output logic [3:0] 	o_phyctrl_tx_picode2, 
    output logic [3:0] 	o_phyctrl_tx_picode3, 
    output logic [3:0] 	o_phyctrl_tx_picode4, 
    output logic [3:0] 	o_phyctrl_tx_picode5, 
    output logic [3:0] 	o_phyctrl_tx_picode6, 
    output logic [3:0] 	o_phyctrl_tx_picode7, 
    output logic [3:0] 	o_phyctrl_tx_picode8, 
    output logic [3:0] 	o_phyctrl_tx_picode9, 
    output logic [3:0] 	o_phyctrl_tx_picode10, 
    output logic [3:0] 	o_phyctrl_tx_picode11, 
    output logic [31:0] o_phyctrl_byte_tx_ctrl, 
    output logic 	o_phyctrl_fifo_pack_select, 
    output logic [1:0] 	o_phyctrl_fifo_read_enable_upper, 
    output logic [1:0] 	o_phyctrl_fifo_read_enable_lower, 
    output logic 	o_phyctrl_trainreset, 
    output logic [31:0] o_phyctrl_byte_rx_ctrl, 
    input wire 		i_phyctrl_pll_lock, 
    input wire [1:0] 	i_phyctrl_rddata_en, 
    input wire [3:0] 	i_phyctrl_rd_rank, 
    input wire [3:0] 	i_phyctrl_wr_rank, 
    input wire [1:0] 	i_phyctrl_wr_dqs0_en, 
    input wire [1:0] 	i_phyctrl_wr_dqs1_en, 
    input wire [1:0] 	i_phyctrl_wrdata_en, 
    input wire 		i_phyctrl_pllvcoclk, 
    input wire [11:0] 	i_phyctrl_rb_txfifo_in_sel,
    input wire 		i_phyctrl_phyclk_sync, 
    input wire 		i_phyctrl_phy_clk, 
    output logic 	o_phyctrl_gated_tx_phy_clk, 
    output logic 	o_phyctrl_gated_rx_phy_clk, 
    output logic 	o_phyctrl_tx_clkrefdivby2, 
    output logic [11:0] o_phyctrl_tx_clkpi, 
    output logic [5:0] 	o_phyctrl_sdll0_dqsp, 
    output logic [5:0] 	o_phyctrl_sdll0_dqsn, 
    output logic [5:0] 	o_phyctrl_sdll1_dqsp, 
    output logic [5:0] 	o_phyctrl_sdll1_dqsn, 
    input wire 		i_phyctrl_rx_dqs_p4, 
    input wire 		i_phyctrl_rx_dqs_n4, 
    input wire 		i_phyctrl_rx_dqs_amp_p5, 
    input wire 		i_phyctrl_rx_dqs_p6, 
    input wire 		i_phyctrl_rx_dqs_n6, 
    input wire 		i_phyctrl_rx_dqs_amp_p7, 
    input wire [11:0] 	i_phyctrl_pa_sideband, 
    input wire 		i_phyctrl_sdll1_dqspin_x16_clk,
    input wire 		i_phyctrl_sdll1_dqsnin_x16_clk,

    input wire 		i_phyctrl_sdll0_dqspin_x16_clk,
    input wire 		i_phyctrl_sdll0_dqsnin_x16_clk,
    output logic 	o_phyctrl_phyclk_notgated,
    output logic 	o_phyctrl_ckx16dqsn_to_bottom,
    output logic 	o_phyctrl_ckx16dqsp_to_bottom,
    output logic 	o_phyctrl_ckx16dqsn_to_top,
    output logic 	o_phyctrl_ckx16dqsp_to_top,

    output wire [11:0] 	o_phyctrl_rx_senseampen, 
    output logic [5:0] 	o_phyctrl_sdll0_rx_d0pienable, 
    output logic 	o_phyctrl_sdll0_rx_d0rcvenpre, 
    output logic 	o_phyctrl_sdll0_rx_d0reset, 
`ifdef REVA
    output logic 	o_phyctrl_sdll0_rx_d0sdlparkvalue, 
    output logic 	o_phyctrl_sdll1_rx_d0sdlparkvalue, 
`else
    output logic  [2:0] o_phyctrl_parkclk_to_rxtop_n0_pl1,
    output logic  [2:0] o_phyctrl_parkclk_to_rxtop_n1_pl1,
`endif
    output logic [5:0] 	o_phyctrl_sdll1_rx_d0pienable, 
    output logic 	o_phyctrl_sdll1_rx_d0rcvenpre, 
    output logic 	o_phyctrl_sdll1_rx_d0reset, 

    input wire [4:0] 	i_DCCXtalkControl_DCCSamples,
    input wire 		i_DCCXtalkControl_RunDCC,
    input wire [1:0] 	i_DCCXtalkControl_SelMeasPoint,
    input wire [4:0] 	i_DDRCrRxEQRank01_RxDFETap0Rank0,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap1Rank0,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap2Rank0,
    input wire [2:0] 	i_DDRCrRxEQRank01_RxDFETap3Rank0,
    input wire [4:0] 	i_DDRCrRxEQRank01_RxDFETap0Rank1,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap1Rank1,
    input wire [3:0] 	i_DDRCrRxEQRank01_RxDFETap2Rank1,
    input wire [2:0] 	i_DDRCrRxEQRank01_RxDFETap3Rank1,
    input wire [4:0] 	i_DDRCrRxEQRank23_RxDFETap0Rank2,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap1Rank2,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap2Rank2,
    input wire [2:0] 	i_DDRCrRxEQRank23_RxDFETap3Rank2,
    input wire [4:0] 	i_DDRCrRxEQRank23_RxDFETap0Rank3,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap1Rank3,
    input wire [3:0] 	i_DDRCrRxEQRank23_RxDFETap2Rank3,
    input wire [2:0] 	i_DDRCrRxEQRank23_RxDFETap3Rank3,
    input wire [1:0] 	i_delayed_oe_p0_toviewdigin,
    input wire [1:0] 	i_delayed_oe_p4_toviewdigin,
    input wire [47:0] 	i_from_phytop_core_data,
    input wire [4:0] 	i_mipi_rb_rxdly_direct_ctrl,
    input wire [4:0] 	i_mipi_rx_diff_en,
    input wire [4:0] 	i_mipi_rx_dphylprxen,
    input wire [11:0] 	i_phyctrl_gpio_dout_sel,
    input wire [11:0] 	i_phyctrl_io_pad_doe,
    input wire 		i_phyctrl_mipi_idle,
    input wire [47:0] 	i_phyctrl_tx_wr_data_pl,
    input wire [11:0] 	i_rx_rxdqsampresult,
    input wire 		i_rx_x16dqsn_p4,
    input wire 		i_rx_x16dqsp_p4,
    input wire [11:0] 	i_rxdphylprxen,
    input wire [11:0] 	i_rxlvdien,
    input wire 		i_rzq_en,
    input wire [2:0] 	i_tx_modectrl_4,
    input wire 		i_txdigitop_0_o_tx_drven_ph0,
    input wire 		i_txdigitop_0_o_tx_drven_ph1,
    input wire 		i_txdigitop_4_o_tx_drven_ph0,
    input wire 		i_txdigitop_4_o_tx_drven_ph1,
    output logic 	o_dcd_ter_en,
    output logic 	o_from_sdll0_o_dcdsawl_clk,
    output logic 	o_from_sdll1_o_dcdsawl_clk, 
    output logic [1:0] 	o_io12phyctrl_dqsmode,
    output logic [1:0] 	o_n0_odt_seg_rotate_en,
    output logic [1:0] 	o_n1_odt_seg_rotate_en,
    output logic 	o_occ_mux_auxclk,
    output logic [11:0] o_odt_en,
    output logic [11:0] o_odt_parken,
    output logic [11:0] o_odt_parken_dqsn,
    output logic 	o_phyctrl_ddrcrdatacontrol0_enodtrotation,
    output logic 	o_phyctrl_ddrcrdatacontrol4_unmatchedrx,
    output logic [11:0] o_phyctrl_dfemuxout_0,
    output logic [11:0] o_phyctrl_dfemuxout_1,
    output logic 	o_phyctrl_o_occ_phy_clk,
    output logic [11:0] o_phyctrl_rcvenmuxout_0,
    output logic [11:0] o_phyctrl_rcvenmuxout_1,
    output logic [1:0] 	o_phyctrl_rddata_en_dly,
    output logic 	o_phyctrl_rx_d0cben,
    output logic 	o_phyctrl_rx_d0drvsel,
    output logic 	o_phyctrl_rxfifo_rb_avm_wr_pipestage,
    output logic 	o_phyctrl_u_io12phyctrl_logic_o_phy_clk_gated,
    output logic 	o_phyctrl_u_io12phyctrl_logic_o_phy_reset_n,
    output logic [1:0] 	o_phyctrl_wrdata_en0,
    output logic [1:0] 	o_phyctrl_wrdata_en1,
    output logic [1:0] 	o_phyctrl_wrdata_en2,
    output logic [1:0] 	o_phyctrl_wrdata_en3,
    output logic [1:0] 	o_phyctrl_wr_dqs_en4,
    output logic [1:0] 	o_phyctrl_wr_dqs_en5,
    output logic [1:0] 	o_phyctrl_wr_dqs_en6,
    output logic [1:0] 	o_phyctrl_wr_dqs_en7,
    output logic [1:0] 	o_phyctrl_wrdata_en8,
    output logic [1:0] 	o_phyctrl_wrdata_en9,
    output logic [1:0] 	o_phyctrl_wrdata_en10,
    output logic [1:0] 	o_phyctrl_wrdata_en11,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_00_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_01_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_02_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_03_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_04_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_05_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_06_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_07_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_08_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_09_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_10_DCCCount,
    output logic [16:0] o_phyctrl_X1CounterDCCPin_11_DCCCount,
    output logic 	o_rxfifo_skew,
    output logic [13:0] o_rxfifo_spare,
    input wire [11:0] 	rxnpathenable,
    input wire [11:0] 	rxppathenable,
    input wire 		i_pa_2_phytop_rx_analog_en,
    input wire 		i_pa_2_phytop_tx_analog_en,
    output logic [3:0] 	o_phyctrl_datatrainfeedback_dqsnparklovohcode,
    output logic 	o_phyctrl_datatrainfeedback_dqsnparklowvoh, 
    output logic [11:0] o_phyctrl_ddrcrcmdbustrain_ddrdqovrddata,
    output logic [11:0] o_phyctrl_ddrcrcmdbustrain_ddrdqovrdmodeen,
    input wire 		i_phyctrl_cr_iamca_00,
    input wire 		i_phyctrl_cr_iamca_01,
    input wire 		i_phyctrl_cr_iamca_02,
    input wire 		i_phyctrl_cr_iamca_03,
    input wire 		i_phyctrl_cr_iamca_04,
    input wire 		i_phyctrl_cr_iamca_05,
    input wire 		i_phyctrl_cr_iamca_06,
    input wire 		i_phyctrl_cr_iamca_07,
    input wire 		i_phyctrl_cr_iamca_08,
    input wire 		i_phyctrl_cr_iamca_09,
    input wire 		i_phyctrl_cr_iamca_10,
    input wire 		i_phyctrl_cr_iamca_11,
    output logic 	o_nbiasen,
    output logic 	o_pbiasen
);
    // synthesis translate_off        
//we should be able to remove these
        timeunit 1ns;
        timeprecision 1ps;
                    
        `ifndef BHV_BYTE_CONTROL    
    
        initial
        begin
            #5;
            force byte_control_inst.io12phyctrl_inst.u_io12phyctrl_av_bb_wrp.u_io12phyctrl_av_bb_rdwr.av2bb_bb_rw_reg[62].av2bb_rw_inst.bead_val_in[21:20] = 2'b11;
            
        end

        `endif
    // synthesis translate_on

    localparam IDLE_COUNTER_EN = (DEV_FAMILY == "FAMILY_AGILEX7") ? 0 : 1;
    localparam INT_TX_CLK_LANE_PS = int'(TX_CLK_LANE_PS);
    localparam MIPI_LP_CONFIG_0 = (real'((BIT_RATE)/(VCO_FREQ*1.0))< 3) ? 2'b00 :
				  (real'((BIT_RATE)/(VCO_FREQ*2.0))< 3) ? 2'b01 :
				  (real'((BIT_RATE)/(VCO_FREQ*3.0))< 3) ? 2'b10 :
				  (real'((BIT_RATE)/(VCO_FREQ*4.0))< 3) ? 2'b11 :
				  2'b11; 
   localparam [5:0] MIPI_LP_CONFIG_1 = (int'($floor(real'((real'(VCO_FREQ)/BIT_RATE)*(MIPI_LP_CONFIG_0+1)*1.5))) & 6'h3f);   
   localparam MIPI_HS_EN = (BIT_RATE > 36'd1600000000) ? 1'b1 : 1'b0;
   localparam MIPI_LP_EN = (IDLE_COUNTER_EN == 1) ? 1'b1 : 1'b0;   
   localparam [11:0] MIPI_DQS_SCALING = ((int'($floor((real'((BIT_RATE/2.0)/VCO_FREQ))*4096))-1) & 12'hfff);
   				
    // synthesis translate_off
    always_comb begin
	  assert((real'(BIT_RATE)/(VCO_FREQ*4)) < 3)
	  else $fatal ("ASSERT: Check with PFE team, MIPI clk gray code division out of range...");
    end
  
    initial
      begin
	 #100;
	 $display ("MIPI_LP_EN : %b, MIPI_LP_CONFIG[7:2] : %b, MIPI_LP_CONFIG[1:0] : %b, MIPI_HS_EN : %b" , MIPI_LP_EN, MIPI_LP_CONFIG_1, MIPI_LP_CONFIG_0, MIPI_HS_EN);	 
      end
    // synthesis translate_on     
				  
    

    `byte_control_name #(
        .base_address( (16'h3<<8) | (16'h0<<3) | BYTE_LOC ),
        .lfifo_value( 0 ),
        .reset_auto_release( "RESET_AUTO_RELEASE_ENABLE" ),
        .rx_burst_length( "RX_BURST_LENGTH_4" ),
        
        .rx_clock_source( DPHY_RX_EN == 0 ? "RX_CLOCK_SOURCE_OFF" : BYTE_CNT == 1 ? "RX_CLOCK_SOURCE_MIPI" : "RX_CLOCK_SOURCE_NEIGHBOR_X8_MIPI" ),
        .rx_self_calibration( "RX_SELF_CALIBRATION_DISABLED" ),

        .rx_serializer_rate(DPHY_RX_EN == 1 ? "RX_SERIALIZER_RATE_HALF_RATE" : "RX_SERIALIZER_RATE_BYPASS"),
	.rx_usage_mode(DPHY_RX_EN == 1 ? "RX_USAGE_MODE_DPHY" : "RX_USAGE_MODE_UNUSED"),
	.rx_io_standard("RX_IO_STANDARD_IOSTD_DPHY"),
        .rx_sampler_mode(DPHY_RX_EN == 1 ? "RX_SAMPLER_MODE_MATCHED_LOW_COMMON_MODE" : "RX_SAMPLER_MODE_MATCHED_HIGH_COMMON_MODE"),
	.sim_mdelay_value_ps(0),
        .tx_usage_mode(DPHY_TX_EN == 1 ? "TX_USAGE_MODE_DPHY" : "TX_USAGE_MODE_UNUSED"),
	.tx_io_standard(DPHY_TX_EN == 1 ? "TX_IO_STANDARD_IOSTD_DPHY" : "TX_IO_STANDARD_IOSTD_OFF"),
        .tx_preamble( "TX_PREAMBLE_OFF" ),
        .tx_serializer_rate( "TX_SERIALIZER_RATE_HALF_RATE" ),
        .vco_freq( VCO_FREQ ),
        .vfifo_value( 0 ),
        .pin0_rx_coarse_delay( "PIN0_RX_COARSE_DELAY_0" ),
        .pin0_rx_fine_delay( DPHY_RX_EN == 1 ? RX_DLANE_DESKEW_DELAY[6:0] : 7'h0 ),
        .pin0_tx_coarse_delay( "PIN0_TX_COARSE_DELAY_0" ),
        // synthesis translate_off
        `ifdef VIP
        // synthesis translate_on
         `ifndef BCM_SIM
			 .pin0_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0000000 : {1'b0, MIPI_LP_CONFIG_1}),
			 .pin1_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0000000 : {3'b000, MIPI_LP_EN, MIPI_HS_EN, MIPI_LP_CONFIG_0}), 
			 .pin2_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0000000 : {1'b0,MIPI_DQS_SCALING[5:0]} ),
			 .pin3_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0000000 : {1'b0,MIPI_DQS_SCALING[11:6]} ),
			 .pin6_tx_fine_delay( 7'b0000000 ),
			 .pin7_tx_fine_delay( 7'b0000000 ),
			 .pin8_tx_fine_delay( 7'b0000000 ),
			 .pin9_tx_fine_delay( 7'b0000000 ),
         `else
			 .pin0_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0010100 : {1'b0, MIPI_LP_CONFIG_1}),
			 .pin1_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0010110 : {3'b000, MIPI_LP_EN, MIPI_HS_EN, MIPI_LP_CONFIG_0}),
			 .pin2_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0001010 : {1'b0,MIPI_DQS_SCALING[5:0]} ),
			 .pin3_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0001000 : {1'b0,MIPI_DQS_SCALING[11:6]} ),
			 .pin6_tx_fine_delay( 7'b0000010 ),
			 .pin7_tx_fine_delay( 7'b0000000 ),
			 .pin8_tx_fine_delay( 7'b0010000 ),
			 .pin9_tx_fine_delay( 7'b0010010 ),
         `endif
        // synthesis translate_off
        `else
			 .pin0_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0010100 : {1'b0 , MIPI_LP_CONFIG_1}),
			 .pin1_tx_fine_delay( ((DPHY_TX_EN == 1)||(IDLE_COUNTER_EN == 0)) ? 7'b0010110 : {3'b000, MIPI_LP_EN, MIPI_HS_EN, MIPI_LP_CONFIG_0}),
  			 .pin2_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0001010 : {1'b0,MIPI_DQS_SCALING[5:0]} ),
			 .pin3_tx_fine_delay( (DPHY_TX_EN == 1) ? 7'b0001000 : {1'b0,MIPI_DQS_SCALING[11:6]} ),
			 .pin6_tx_fine_delay( 7'b0000010 ),
			 .pin7_tx_fine_delay( 7'b0000000 ),
			 .pin8_tx_fine_delay( 7'b0010000 ),
			 .pin9_tx_fine_delay( 7'b0010010 ),
        `endif
        // synthesis translate_on
        .pin1_rx_coarse_delay( "PIN1_RX_COARSE_DELAY_0" ),
        .pin1_rx_fine_delay( DPHY_RX_EN == 1 ? RX_DLANE_DESKEW_DELAY[6:0] : 7'h0 ),
        .pin1_tx_coarse_delay( "PIN1_TX_COARSE_DELAY_0" ),
        .pin2_rx_coarse_delay( "PIN2_RX_COARSE_DELAY_0" ),
        .pin2_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 1) && DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[14:8]) : 7'h0 ),
        .pin2_tx_coarse_delay( "PIN2_TX_COARSE_DELAY_0" ),
        .pin3_rx_coarse_delay( "PIN3_RX_COARSE_DELAY_0" ),
        .pin3_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 1) && DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[14:8]) : 7'h0 ),
        .pin3_tx_coarse_delay( "PIN3_TX_COARSE_DELAY_0" ),
        .pin4_rx_coarse_delay( "PIN4_RX_COARSE_DELAY_0" ),
        .pin4_rx_fine_delay( 7'b0000000 ),
        .pin4_tx_coarse_delay( "PIN4_TX_COARSE_DELAY_0" ),
        .pin4_tx_fine_delay( BYTE_N == 0 && DPHY_TX_EN == 1 ? INT_TX_CLK_LANE_PS : 7'h0 ),
        .pin5_rx_coarse_delay( "PIN5_RX_COARSE_DELAY_0" ),
        .pin5_rx_fine_delay( 7'b0000000 ),
        .pin5_tx_coarse_delay( "PIN5_TX_COARSE_DELAY_0" ),
        .pin5_tx_fine_delay( BYTE_N == 0 && DPHY_TX_EN == 1 ? INT_TX_CLK_LANE_PS : 7'h0 ),
        .pin6_rx_coarse_delay( "PIN6_RX_COARSE_DELAY_0" ),
        .pin6_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 2) && DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[22:16]) : 7'h0 ),
        .pin6_tx_coarse_delay( "PIN6_TX_COARSE_DELAY_0" ),
        .pin7_rx_coarse_delay( "PIN7_RX_COARSE_DELAY_0" ),
        .pin7_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 2) && DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[22:16]) : 7'h0 ),
        .pin7_tx_coarse_delay( "PIN7_TX_COARSE_DELAY_0" ),
        .pin8_rx_coarse_delay( "PIN8_RX_COARSE_DELAY_0" ),
        .pin8_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 3) && DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[30:24]) : 7'h0 ),
        .pin8_tx_coarse_delay( "PIN8_TX_COARSE_DELAY_0" ),
        .pin9_rx_coarse_delay( "PIN9_RX_COARSE_DELAY_0" ),
        .pin9_rx_fine_delay( (BYTE_N == 1 || NUM_LANES > 3) &&  DPHY_RX_EN == 1 ? int'(RX_DLANE_DESKEW_DELAY[30:24]) : 7'h0 ),
        .pin9_tx_coarse_delay( "PIN9_TX_COARSE_DELAY_0" ),
        .pin10_rx_coarse_delay( "PIN10_RX_COARSE_DELAY_0" ),
        .pin10_rx_fine_delay( 7'b0000000 ),
        .pin10_tx_coarse_delay( "PIN10_TX_COARSE_DELAY_0" ),
        .pin10_tx_fine_delay( 7'b0000000 ),
        .pin11_rx_coarse_delay( "PIN11_RX_COARSE_DELAY_0" ),
        .pin11_rx_fine_delay( 7'b0000000 ),
        .pin11_tx_coarse_delay( "PIN11_TX_COARSE_DELAY_0" ),
        .pin11_tx_fine_delay( 7'b0000000 ),
        
        .pin0_rx_usage( ( BYTE_N == 1 || NUM_LANES > 0) && DPHY_RX_EN == 1 ? "PIN0_RX_USAGE_MIPI" : "PIN0_RX_USAGE_GPIO" ),
        .pin1_rx_usage( ( BYTE_N == 1 || NUM_LANES > 0) && DPHY_RX_EN == 1 ? "PIN1_RX_USAGE_MIPI" : "PIN1_RX_USAGE_GPIO" ),
        .pin2_rx_usage( ( BYTE_N == 1 || NUM_LANES > 1) && DPHY_RX_EN == 1 ? "PIN2_RX_USAGE_MIPI" : "PIN2_RX_USAGE_GPIO" ),
        .pin3_rx_usage( ( BYTE_N == 1 || NUM_LANES > 1) && DPHY_RX_EN == 1 ? "PIN3_RX_USAGE_MIPI" : "PIN3_RX_USAGE_GPIO" ),
        .pin4_rx_usage( BYTE_N == 0 && DPHY_RX_EN == 1 ? ( CONTINUOUS_CLK == 1 ? "PIN4_RX_USAGE_MIPI_CLK_CONTINUOUS" : "PIN4_RX_USAGE_MIPI_CLK") : "PIN4_RX_USAGE_GPIO" ),
        .pin5_rx_usage( BYTE_N == 0 && DPHY_RX_EN == 1 ? ( CONTINUOUS_CLK == 1 ? "PIN5_RX_USAGE_MIPI_CLK_CONTINUOUS" : "PIN5_RX_USAGE_MIPI_CLK") : "PIN5_RX_USAGE_GPIO" ),
        .pin6_rx_usage( ( BYTE_N == 1 || NUM_LANES > 2) && DPHY_RX_EN == 1 ? "PIN6_RX_USAGE_MIPI" : "PIN6_RX_USAGE_GPIO" ),
        .pin7_rx_usage( ( BYTE_N == 1 || NUM_LANES > 2) && DPHY_RX_EN == 1 ? "PIN7_RX_USAGE_MIPI" : "PIN7_RX_USAGE_GPIO" ),
        .pin8_rx_usage( ( BYTE_N == 1 || NUM_LANES > 3) && DPHY_RX_EN == 1 ? "PIN8_RX_USAGE_MIPI" : "PIN8_RX_USAGE_GPIO" ),
        .pin9_rx_usage( ( BYTE_N == 1 || NUM_LANES > 3) && DPHY_RX_EN == 1 ? "PIN9_RX_USAGE_MIPI" : "PIN9_RX_USAGE_GPIO" ),
        .pin10_rx_usage( "PIN10_RX_USAGE_GPIO" ),
        .pin11_rx_usage( "PIN11_RX_USAGE_GPIO" ),			 
        .outputenable_to_wrfifo_offset( 0 ),
        .rcven_coarse_delay("RCVEN_COARSE_DELAY_0"), 
        .rcven_fine_delay(0),
        .rcven_to_read_valid_offset(0),
        
        .pin0_tx_usage( ( BYTE_N == 1 || NUM_LANES > 0) && DPHY_TX_EN == 1 ? "PIN0_TX_USAGE_MIPI" : "PIN0_TX_USAGE_GPIO" ),
        .pin1_tx_usage( ( BYTE_N == 1 || NUM_LANES > 0) && DPHY_TX_EN == 1 ? "PIN1_TX_USAGE_MIPI" : "PIN1_TX_USAGE_GPIO" ),
        .pin2_tx_usage( ( BYTE_N == 1 || NUM_LANES > 1) && DPHY_TX_EN == 1 ? "PIN2_TX_USAGE_MIPI" : "PIN2_TX_USAGE_GPIO" ),
        .pin3_tx_usage( ( BYTE_N == 1 || NUM_LANES > 1) && DPHY_TX_EN == 1 ? "PIN3_TX_USAGE_MIPI" : "PIN3_TX_USAGE_GPIO" ),
        .pin4_tx_usage( BYTE_N == 0 && DPHY_TX_EN == 1 ? ( CONTINUOUS_CLK == 1 ? "PIN4_TX_USAGE_MIPI_CLK_CONTINUOUS" : "PIN4_TX_USAGE_MIPI_CLK") : "PIN4_TX_USAGE_GPIO" ),
        .pin5_tx_usage( BYTE_N == 0 && DPHY_TX_EN == 1 ? ( CONTINUOUS_CLK == 1 ? "PIN5_TX_USAGE_MIPI_CLK_CONTINUOUS" : "PIN5_TX_USAGE_MIPI_CLK") : "PIN5_TX_USAGE_GPIO" ),
        .pin6_tx_usage( ( BYTE_N == 1 || NUM_LANES > 2) && DPHY_TX_EN == 1 ? "PIN6_TX_USAGE_MIPI" : "PIN6_TX_USAGE_GPIO" ),
        .pin7_tx_usage( ( BYTE_N == 1 || NUM_LANES > 2) && DPHY_TX_EN == 1 ? "PIN7_TX_USAGE_MIPI" : "PIN7_TX_USAGE_GPIO" ),
        .pin8_tx_usage( ( BYTE_N == 1 || NUM_LANES > 3) && DPHY_TX_EN == 1 ? "PIN8_TX_USAGE_MIPI" : "PIN8_TX_USAGE_GPIO" ),
        .pin9_tx_usage( ( BYTE_N == 1 || NUM_LANES > 3) && DPHY_TX_EN == 1 ? "PIN9_TX_USAGE_MIPI" : "PIN9_TX_USAGE_GPIO" ),
        .pin10_tx_usage( "PIN10_TX_USAGE_GPIO" ),
        .pin11_tx_usage( "PIN11_TX_USAGE_GPIO" )

        
    ) byte_control_inst (
        .o_phyctrl_rddata_valid_upper( o_phyctrl_rddata_valid_upper ),            
        .o_phyctrl_rddata_valid_lower( o_phyctrl_rddata_valid_lower ),            
        .o_phyctrl_wr_dqs_en4_del( o_phyctrl_dqs_en4_del ),        
        .o_phyctrl_wr_dqs_en5_del( o_phyctrl_dqs_en5_del ),        
        .o_phyctrl_wr_dqs_en6_del( o_phyctrl_dqs_en6_del ),        
        .o_phyctrl_wr_dqs_en7_del( o_phyctrl_dqs_en7_del ),        
        .o_phyctrl_wrdata_en0_del( o_phyctrl_wrdata_en0_del ),              
        .o_phyctrl_wrdata_en1_del( o_phyctrl_wrdata_en1_del ),              
        .o_phyctrl_wrdata_en2_del( o_phyctrl_wrdata_en2_del ),              
        .o_phyctrl_wrdata_en3_del( o_phyctrl_wrdata_en3_del ),              
        .o_phyctrl_wrdata_en8_del( o_phyctrl_wrdata_en8_del ),              
        .o_phyctrl_wrdata_en9_del( o_phyctrl_wrdata_en9_del ),              
        .o_phyctrl_wrdata_en10_del( o_phyctrl_wrdata_en10_del ),            
        .o_phyctrl_wrdata_en11_del( o_phyctrl_wrdata_en11_del ),            
        .o_phyctrl_tx_picode0( o_phyctrl_tx_picode0 ),                
        .o_phyctrl_tx_picode1( o_phyctrl_tx_picode1 ),                
        .o_phyctrl_tx_picode2( o_phyctrl_tx_picode2 ),                
        .o_phyctrl_tx_picode3( o_phyctrl_tx_picode3 ),                
        .o_phyctrl_tx_picode4( o_phyctrl_tx_picode4 ),                
        .o_phyctrl_tx_picode5( o_phyctrl_tx_picode5 ),                
        .o_phyctrl_tx_picode6( o_phyctrl_tx_picode6 ),                
        .o_phyctrl_tx_picode7( o_phyctrl_tx_picode7 ),                
        .o_phyctrl_tx_picode8( o_phyctrl_tx_picode8 ),                
        .o_phyctrl_tx_picode9( o_phyctrl_tx_picode9 ),                
        .o_phyctrl_tx_picode10( o_phyctrl_tx_picode10 ),              
        .o_phyctrl_tx_picode11( o_phyctrl_tx_picode11 ),              
        .o_phyctrl_byte_tx_ctrl( o_phyctrl_byte_tx_ctrl ),            
        .o_phyctrl_fifo_pack_select( o_phyctrl_fifo_pack_select ),    
        .o_phyctrl_fifo_read_enable_upper( o_phyctrl_fifo_read_enable_upper ),    
        .o_phyctrl_fifo_read_enable_lower( o_phyctrl_fifo_read_enable_lower ),    
        .o_phyctrl_trainreset( o_phyctrl_trainreset ),                
        .o_phyctrl_byte_rx_ctrl( o_phyctrl_byte_rx_ctrl ),            
        .i_phyctrl_pll_lock( i_phyctrl_pll_lock ),                    
        .o_phyctrl_avbb_avl_out_avm_readdata(  ),                     
        .i_phyctrl_avbb_avl_in_clk(),                                  
        .i_phyctrl_avbb_avl_in_rst_n(),                                
        .i_phyctrl_avbb_avl_in_avm_write(),                            
        .i_phyctrl_avbb_avl_in_avm_read(),                             
        .i_phyctrl_avbb_avl_in_avm_address(),                          
        .i_phyctrl_avbb_avl_in_avm_writedata(),                        
        .i_phyctrl_avbb_avl_in_avm_readdata(),                         
        .i_phyctrl_rd_rank( i_phyctrl_rd_rank ),                      
        .i_phyctrl_wr_rank( i_phyctrl_wr_rank ),                      
        .i_phyctrl_pa_sideband( i_phyctrl_pa_sideband ),              
        .i_phyctrl_rddata_en( i_phyctrl_rddata_en ),                  
        .i_phyctrl_wr_dqs0_en( i_phyctrl_wr_dqs0_en ),                  
        .i_phyctrl_wr_dqs1_en( i_phyctrl_wr_dqs1_en ),                  
        .i_phyctrl_wrdata_en( i_phyctrl_wrdata_en ),                  
        .i_phyctrl_pllvcoclk( i_phyctrl_pllvcoclk ),                  
	.i_phyctrl_rb_txfifo_in_sel( i_phyctrl_rb_txfifo_in_sel ),
        .i_phyctrl_phyclk_sync( i_phyctrl_phyclk_sync ),              
        .i_phyctrl_phy_clk( i_phyctrl_phy_clk ),                      
        .o_phyctrl_gated_tx_phy_clk( o_phyctrl_gated_tx_phy_clk ),    
        .o_phyctrl_gated_rx_phy_clk( o_phyctrl_gated_rx_phy_clk ),    
        .o_phyctrl_tx_clkrefdivby2( o_phyctrl_tx_clkrefdivby2 ),      
        .o_phyctrl_tx_clkpi( o_phyctrl_tx_clkpi ),                    
        .o_phyctrl_sdll0_dqsp( o_phyctrl_sdll0_dqsp ),                
        .o_phyctrl_sdll0_dqsn( o_phyctrl_sdll0_dqsn ),                
        .o_phyctrl_sdll1_dqsp( o_phyctrl_sdll1_dqsp ),                
        .o_phyctrl_sdll1_dqsn( o_phyctrl_sdll1_dqsn ),                
        .o_phyctrl_ckx16dqsn_to_bottom(o_phyctrl_ckx16dqsn_to_bottom),
        .o_phyctrl_ckx16dqsp_to_bottom(o_phyctrl_ckx16dqsp_to_bottom),
        .o_phyctrl_ckx16dqsn_to_top(o_phyctrl_ckx16dqsn_to_top),
        .o_phyctrl_ckx16dqsp_to_top(o_phyctrl_ckx16dqsp_to_top),

        .i_phyctrl_rx_dqs_p4( i_phyctrl_rx_dqs_p4 ),                  
        .i_phyctrl_rx_dqs_n4( i_phyctrl_rx_dqs_n4 ),                  
        .i_phyctrl_rx_dqs_amp_p5( i_phyctrl_rx_dqs_amp_p5 ),          
        .i_phyctrl_rx_dqs_p6( i_phyctrl_rx_dqs_p6 ),                  
        .i_phyctrl_rx_dqs_n6( i_phyctrl_rx_dqs_n6 ),                  
        .i_phyctrl_rx_dqs_amp_p7( i_phyctrl_rx_dqs_amp_p7 ),          
        .o_phyctrl_phyclk_notgated(o_phyctrl_phyclk_notgated),          
        .o_phyctrl_rx_senseampen( o_phyctrl_rx_senseampen ),          
        .i_phyctrl_sdll1_dqspin_x16_clk(i_phyctrl_sdll1_dqspin_x16_clk),
        .i_phyctrl_sdll1_dqsnin_x16_clk(i_phyctrl_sdll1_dqsnin_x16_clk),
        .i_phyctrl_sdll0_dqspin_x16_clk(i_phyctrl_sdll0_dqspin_x16_clk),
        .i_phyctrl_sdll0_dqsnin_x16_clk(i_phyctrl_sdll0_dqsnin_x16_clk),
        .o_phyctrl_sdll0_rx_d0pienable( o_phyctrl_sdll0_rx_d0pienable ), 
        .o_phyctrl_sdll0_rx_d0rcvenpre( o_phyctrl_sdll0_rx_d0rcvenpre ), 
        .o_phyctrl_sdll0_rx_d0reset( o_phyctrl_sdll0_rx_d0reset ),    
`ifdef REVA
        .o_phyctrl_sdll0_rx_d0sdlparkvalue( o_phyctrl_sdll0_rx_d0sdlparkvalue ), 
        .o_phyctrl_sdll1_rx_d0sdlparkvalue( o_phyctrl_sdll1_rx_d0sdlparkvalue ),  
`else
        .o_phyctrl_parkclk_to_rxtop_n0_pl1( o_phyctrl_parkclk_to_rxtop_n0_pl1 ), 
        .o_phyctrl_parkclk_to_rxtop_n1_pl1( o_phyctrl_parkclk_to_rxtop_n1_pl1 ), 
`endif
        .o_phyctrl_sdll1_rx_d0pienable( o_phyctrl_sdll1_rx_d0pienable ), 
        .o_phyctrl_sdll1_rx_d0rcvenpre( o_phyctrl_sdll1_rx_d0rcvenpre ), 
        .o_phyctrl_sdll1_rx_d0reset( o_phyctrl_sdll1_rx_d0reset ),    
	.i_DCCXtalkControl_DCCSamples(i_DCCXtalkControl_DCCSamples),
        .i_DCCXtalkControl_RunDCC(i_DCCXtalkControl_RunDCC),
        .i_DCCXtalkControl_SelMeasPoint(i_DCCXtalkControl_SelMeasPoint),
        .i_DDRCrRxEQRank01_RxDFETap0Rank0(i_DDRCrRxEQRank01_RxDFETap0Rank0),
        .i_DDRCrRxEQRank01_RxDFETap1Rank0(i_DDRCrRxEQRank01_RxDFETap1Rank0),
        .i_DDRCrRxEQRank01_RxDFETap2Rank0(i_DDRCrRxEQRank01_RxDFETap2Rank0),
        .i_DDRCrRxEQRank01_RxDFETap3Rank0(i_DDRCrRxEQRank01_RxDFETap3Rank0),
        .i_DDRCrRxEQRank01_RxDFETap0Rank1(i_DDRCrRxEQRank01_RxDFETap0Rank1),
        .i_DDRCrRxEQRank01_RxDFETap1Rank1(i_DDRCrRxEQRank01_RxDFETap1Rank1),
        .i_DDRCrRxEQRank01_RxDFETap2Rank1(i_DDRCrRxEQRank01_RxDFETap2Rank1),
        .i_DDRCrRxEQRank01_RxDFETap3Rank1(i_DDRCrRxEQRank01_RxDFETap3Rank1),
        .i_DDRCrRxEQRank23_RxDFETap0Rank2(i_DDRCrRxEQRank23_RxDFETap0Rank2),
        .i_DDRCrRxEQRank23_RxDFETap1Rank2(i_DDRCrRxEQRank23_RxDFETap1Rank2),
        .i_DDRCrRxEQRank23_RxDFETap2Rank2(i_DDRCrRxEQRank23_RxDFETap2Rank2),
        .i_DDRCrRxEQRank23_RxDFETap3Rank2(i_DDRCrRxEQRank23_RxDFETap3Rank2),
        .i_DDRCrRxEQRank23_RxDFETap0Rank3(i_DDRCrRxEQRank23_RxDFETap0Rank3),
        .i_DDRCrRxEQRank23_RxDFETap1Rank3(i_DDRCrRxEQRank23_RxDFETap1Rank3),
        .i_DDRCrRxEQRank23_RxDFETap2Rank3(i_DDRCrRxEQRank23_RxDFETap2Rank3),
        .i_DDRCrRxEQRank23_RxDFETap3Rank3(i_DDRCrRxEQRank23_RxDFETap3Rank3),
	.i_delayed_oe_p0_toviewdigin(i_delayed_oe_p0_toviewdigin),
	.i_delayed_oe_p4_toviewdigin(i_delayed_oe_p4_toviewdigin),
	.i_from_phytop_core_data(i_from_phytop_core_data),
	.i_mipi_rb_rxdly_direct_ctrl(i_mipi_rb_rxdly_direct_ctrl),
	.i_mipi_rx_diff_en(i_mipi_rx_diff_en),
	.i_mipi_rx_dphylprxen(i_mipi_rx_dphylprxen),
	.i_phyctrl_gpio_dout_sel(i_phyctrl_gpio_dout_sel),
	.i_pa_2_phytop_rx_analog_en(i_pa_2_phytop_rx_analog_en),
	.i_pa_2_phytop_tx_analog_en(i_pa_2_phytop_tx_analog_en),
	.i_phyctrl_io_pad_doe_0(i_phyctrl_io_pad_doe[0]),
	.i_phyctrl_io_pad_doe_1(i_phyctrl_io_pad_doe[1]),
	.i_phyctrl_io_pad_doe_2(i_phyctrl_io_pad_doe[2]),
	.i_phyctrl_io_pad_doe_3(i_phyctrl_io_pad_doe[3]),
	.i_phyctrl_io_pad_doe_4(i_phyctrl_io_pad_doe[4]),
	.i_phyctrl_io_pad_doe_5(i_phyctrl_io_pad_doe[5]),
	.i_phyctrl_io_pad_doe_6(i_phyctrl_io_pad_doe[6]),
	.i_phyctrl_io_pad_doe_7(i_phyctrl_io_pad_doe[7]),
	.i_phyctrl_io_pad_doe_8(i_phyctrl_io_pad_doe[8]),
	.i_phyctrl_io_pad_doe_9(i_phyctrl_io_pad_doe[9]),
	.i_phyctrl_io_pad_doe_10(i_phyctrl_io_pad_doe[10]),
	.i_phyctrl_io_pad_doe_11(i_phyctrl_io_pad_doe[11]),
	.i_phyctrl_mipi_idle(i_phyctrl_mipi_idle),
	.i_phyctrl_tx_wr_data_pl(i_phyctrl_tx_wr_data_pl),
	.i_rx_rxdqsampresult(i_rx_rxdqsampresult),
	.i_rx_x16dqsn_p4(i_rx_x16dqsn_p4),
	.i_rx_x16dqsp_p4(i_rx_x16dqsp_p4),
	.i_rxdphylprxen_0(i_rxdphylprxen[0]),
	.i_rxdphylprxen_1(i_rxdphylprxen[1]),
	.i_rxdphylprxen_2(i_rxdphylprxen[2]),
	.i_rxdphylprxen_3(i_rxdphylprxen[3]),
	.i_rxdphylprxen_4(i_rxdphylprxen[4]),
	.i_rxdphylprxen_5(i_rxdphylprxen[5]),
	.i_rxdphylprxen_6(i_rxdphylprxen[6]),
	.i_rxdphylprxen_7(i_rxdphylprxen[7]),
	.i_rxdphylprxen_8(i_rxdphylprxen[8]),
	.i_rxdphylprxen_9(i_rxdphylprxen[9]),
	.i_rxdphylprxen_10(i_rxdphylprxen[10]),
	.i_rxdphylprxen_11(i_rxdphylprxen[11]),
	.i_rxlvdien_0(i_rxlvdien[0]),
	.i_rxlvdien_1(i_rxlvdien[1]),
	.i_rxlvdien_2(i_rxlvdien[2]),
	.i_rxlvdien_3(i_rxlvdien[3]),
	.i_rxlvdien_4(i_rxlvdien[4]),
	.i_rxlvdien_5(i_rxlvdien[5]),
	.i_rxlvdien_6(i_rxlvdien[6]),
	.i_rxlvdien_7(i_rxlvdien[7]),
	.i_rxlvdien_8(i_rxlvdien[8]),
	.i_rxlvdien_9(i_rxlvdien[9]),
	.i_rxlvdien_10(i_rxlvdien[10]),
	.i_rxlvdien_11(i_rxlvdien[11]),
	.i_rzq_en(i_rzq_en),
	.i_tx_modectrl_4(i_tx_modectrl_4),
	.i_txdigitop_0_o_tx_drven_ph0(i_txdigitop_0_o_tx_drven_ph0),
	.i_txdigitop_0_o_tx_drven_ph1(i_txdigitop_0_o_tx_drven_ph1),
	.i_txdigitop_4_o_tx_drven_ph0(i_txdigitop_4_o_tx_drven_ph0),
	.i_txdigitop_4_o_tx_drven_ph1(i_txdigitop_4_o_tx_drven_ph1),
	.o_dcd_ter_en(o_dcd_ter_en),
	.o_from_sdll0_o_dcdsawl_clk(o_from_sdll0_o_dcdsawl_clk),
	.o_from_sdll1_o_dcdsawl_clk(o_from_sdll1_o_dcdsawl_clk),
	.o_io12phyctrl_dqsmode(o_io12phyctrl_dqsmode),
	.o_n0_odt_seg_rotate_en(o_n0_odt_seg_rotate_en),
	.o_n1_odt_seg_rotate_en(o_n1_odt_seg_rotate_en),
	.o_occ_mux_auxclk(o_occ_mux_auxclk),
	.o_odt_en(o_odt_en),
	.o_odt_parken(o_odt_parken),
	.o_odt_parken_dqsn(o_odt_parken_dqsn),
	.o_phyctrl_ddrcrdatacontrol0_enodtrotation(o_phyctrl_ddrcrdatacontrol0_enodtrotation),
	.o_phyctrl_ddrcrdatacontrol4_unmatchedrx(o_phyctrl_ddrcrdatacontrol4_unmatchedrx),
	.o_phyctrl_dfemuxout_0(o_phyctrl_dfemuxout_0),
	.o_phyctrl_dfemuxout_1(o_phyctrl_dfemuxout_1),
	.o_phyctrl_o_occ_phy_clk(o_phyctrl_o_occ_phy_clk),
	.o_phyctrl_rcvenmuxout_0(o_phyctrl_rcvenmuxout_0),
	.o_phyctrl_rcvenmuxout_1(o_phyctrl_rcvenmuxout_1),
	.o_phyctrl_rddata_en_dly(o_phyctrl_rddata_en_dly),
 	.o_phyctrl_rx_d0cben(o_phyctrl_rx_d0cben),
	.o_phyctrl_rx_d0drvsel(o_phyctrl_rx_d0drvsel),
	.o_phyctrl_rxfifo_rb_avm_wr_pipestage(o_phyctrl_rxfifo_rb_avm_wr_pipestage),
	.o_phyctrl_u_io12phyctrl_logic_o_phy_clk_gated(o_phyctrl_u_io12phyctrl_logic_o_phy_clk_gated),
	.o_phyctrl_u_io12phyctrl_logic_o_phy_reset_n(o_phyctrl_u_io12phyctrl_logic_o_phy_reset_n),
	.o_phyctrl_wrdata_en0(o_phyctrl_wrdata_en0),
	.o_phyctrl_wrdata_en1(o_phyctrl_wrdata_en1),
	.o_phyctrl_wrdata_en2(o_phyctrl_wrdata_en2),
	.o_phyctrl_wrdata_en3(o_phyctrl_wrdata_en3),
	.o_phyctrl_wr_dqs_en4(o_phyctrl_wr_dqs_en4),
	.o_phyctrl_wr_dqs_en5(o_phyctrl_wr_dqs_en5),
	.o_phyctrl_wr_dqs_en6(o_phyctrl_wr_dqs_en6),
	.o_phyctrl_wr_dqs_en7(o_phyctrl_wr_dqs_en7),
	.o_phyctrl_wrdata_en8(o_phyctrl_wrdata_en8),
	.o_phyctrl_wrdata_en9(o_phyctrl_wrdata_en9),
	.o_phyctrl_wrdata_en10(o_phyctrl_wrdata_en10),
	.o_phyctrl_wrdata_en11(o_phyctrl_wrdata_en11),
	.o_phyctrl_X1CounterDCCPin_00_DCCCount(o_phyctrl_X1CounterDCCPin_00_DCCCount),
	.o_phyctrl_X1CounterDCCPin_01_DCCCount(o_phyctrl_X1CounterDCCPin_01_DCCCount),
	.o_phyctrl_X1CounterDCCPin_02_DCCCount(o_phyctrl_X1CounterDCCPin_02_DCCCount),
	.o_phyctrl_X1CounterDCCPin_03_DCCCount(o_phyctrl_X1CounterDCCPin_03_DCCCount),
	.o_phyctrl_X1CounterDCCPin_04_DCCCount(o_phyctrl_X1CounterDCCPin_04_DCCCount),
	.o_phyctrl_X1CounterDCCPin_05_DCCCount(o_phyctrl_X1CounterDCCPin_05_DCCCount),
	.o_phyctrl_X1CounterDCCPin_06_DCCCount(o_phyctrl_X1CounterDCCPin_06_DCCCount),
	.o_phyctrl_X1CounterDCCPin_07_DCCCount(o_phyctrl_X1CounterDCCPin_07_DCCCount),
	.o_phyctrl_X1CounterDCCPin_08_DCCCount(o_phyctrl_X1CounterDCCPin_08_DCCCount),
	.o_phyctrl_X1CounterDCCPin_09_DCCCount(o_phyctrl_X1CounterDCCPin_09_DCCCount),
	.o_phyctrl_X1CounterDCCPin_10_DCCCount(o_phyctrl_X1CounterDCCPin_10_DCCCount),
	.o_phyctrl_X1CounterDCCPin_11_DCCCount(o_phyctrl_X1CounterDCCPin_11_DCCCount),
	.o_rxfifo_skew(o_rxfifo_skew),
	.o_rxfifo_spare(o_rxfifo_spare),
	.rxnpathenable_0(rxnpathenable[0]),
	.rxnpathenable_1(rxnpathenable[1]),
	.rxnpathenable_2(rxnpathenable[2]),
	.rxnpathenable_3(rxnpathenable[3]),
	.rxnpathenable_4(rxnpathenable[4]),
	.rxnpathenable_5(rxnpathenable[5]),
	.rxnpathenable_6(rxnpathenable[6]),
	.rxnpathenable_7(rxnpathenable[7]),
	.rxnpathenable_8(rxnpathenable[8]),
	.rxnpathenable_9(rxnpathenable[9]),
	.rxnpathenable_10(rxnpathenable[10]),
	.rxnpathenable_11(rxnpathenable[11]),
	.rxppathenable_0(rxppathenable[0]),
	.rxppathenable_1(rxppathenable[1]),
	.rxppathenable_2(rxppathenable[2]),
	.rxppathenable_3(rxppathenable[3]),
	.rxppathenable_4(rxppathenable[4]),
	.rxppathenable_5(rxppathenable[5]),
	.rxppathenable_6(rxppathenable[6]),
	.rxppathenable_7(rxppathenable[7]),
	.rxppathenable_8(rxppathenable[8]),
	.rxppathenable_9(rxppathenable[9]),
	.rxppathenable_10(rxppathenable[10]),
	.rxppathenable_11(rxppathenable[11]),
	.o_phyctrl_datatrainfeedback_dqsnparklovohcode(o_phyctrl_datatrainfeedback_dqsnparklovohcode),
	.o_phyctrl_datatrainfeedback_dqsnparklowvoh(o_phyctrl_datatrainfeedback_dqsnparklowvoh),
	.o_phyctrl_ddrcrcmdbustrain_ddrdqovrddata(o_phyctrl_ddrcrcmdbustrain_ddrdqovrddata),
	.o_phyctrl_ddrcrcmdbustrain_ddrdqovrdmodeen(o_phyctrl_ddrcrcmdbustrain_ddrdqovrdmodeen),
	.i_phyctrl_cr_iamca_00(i_phyctrl_cr_iamca_00),
	.i_phyctrl_cr_iamca_01(i_phyctrl_cr_iamca_01),
	.i_phyctrl_cr_iamca_02(i_phyctrl_cr_iamca_02),
	.i_phyctrl_cr_iamca_03(i_phyctrl_cr_iamca_03),
	.i_phyctrl_cr_iamca_04(i_phyctrl_cr_iamca_04),
	.i_phyctrl_cr_iamca_05(i_phyctrl_cr_iamca_05),
	.i_phyctrl_cr_iamca_06(i_phyctrl_cr_iamca_06),
	.i_phyctrl_cr_iamca_07(i_phyctrl_cr_iamca_07),
	.i_phyctrl_cr_iamca_08(i_phyctrl_cr_iamca_08),
	.i_phyctrl_cr_iamca_09(i_phyctrl_cr_iamca_09),
	.i_phyctrl_cr_iamca_10(i_phyctrl_cr_iamca_10),
	.i_phyctrl_cr_iamca_11(i_phyctrl_cr_iamca_11),
	.o_nbiasen(o_nbiasen),
	.o_pbiasen(o_pbiasen)
   );
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "mee/gkV9zeKLvGqNntLTSsObQ14wNSIHwecTPHvpjCmsnnk0ZTGlHC9OJ2J7QtOlYKo2Bc2VVDqOZoN51yloE5tY0a0/Y/RVN0fm/CU2oP6/dvCD+ss5w+WhSKVRWbbV3uCzU3e1heptSc2fi9jvNXQmD1Bn9cDRf7CXSebhPv5vfKL8eLlrpemzQLBQeCmvpGlylP/A/8fOufmAzy3w7MC/jmSYwdMjhC8qIri/+oLIFZgta9TAEXGjl0iq5aZ7H2il5AbyYZaut3YyDu+f93Me1AA0XJI8p4KoceaEdKkYKQikkHhVWwsydeiCZ77LIoz3GGtt5/+GCm66i0RZqkFKJ8eCYrQQrv1wGYUoWYOCr9F0D0JBnWV+tEyHt/geblfZvAqasW7DPAQIFq3N1bpmZrNmnzigSWoK9Tx1rjQZHl0dAnAYB9eOLIOqEFlKqKugDO6ztviqIFVeY9JcQl8VtNKYHR9m+SHbU+Uk6gtFhH7L+lDWz9SCmKbUXjthMjMr2kqzVUGIj0lYbpsIeAnviutUYohDTHH9CafN+TLUc7zw97j83efBpZt7TiD+qFqoa1MtUmqEsIhfS6AT9ghLfjlLzYJPnYF+EdDEMZPUByHnOs/UOFVST6v2bWj2hRSp7b5nWAeTDJIEGuGIg1c/yO9M7OSfgY/ti42Pe6P9LaeizusZ+TrfsOdgtZJLlAnyDbagWPPmuRUcyH0G2DP3fkkHO8zlLc6RrfqyDGCPntTCy1bmyuAFYu2IwxWNZKnc4qDdjQmvgoZQUhC8FYr/H7Xd2B818bohJsI8NGN8ZfiO/z9NboR+nlqZz9nHjJrz7LMPYz3K/lAfunMwY3vcB4h93g3VcpqwwNfXaYbojbf0SEYyfEEGFUZzByncSa+FSMiGRySTqzMpddkATwcYUdHUdipcVlRHAxXjxQFOG1uI+jS7g1NS0NKOGtyHy82fhGO+4pzpSMfQyqtZygjcNYLhvIOyycm5svntTt0gOG6g7+h7K2TsbDlOdaB8"
`endif
