


module RAW_RGB_BIN  (
input CLK , 
input RESET_N , 
input [9:0] D0,
input [9:0] D1,
input X,
input Y,

output reg		[9:0]	R,
output reg		[9:0]	G, 
output reg		[9:0]	B
);

reg  [9:0]	rD0;
reg  [9:0]	rD1;

wire [10:0] T1,T2 ; 
assign T1 = rD0+D1;
assign T2 = rD1+D0;

wire [1:0] beat0;
wire [1:0] beat1;
wire [1:0] beat2;
wire [1:0] beat3;
wire [1:0] beat ; 

//change ch00(
//		.source(beat), // sources.source
//      .probe (beat[0])   //  probes.probe
//	);
//
//assign  beat0 = ( beat==0)?2'b10: ((beat==1)?2'b01:((beat==2)? 2'b00:2'b11)) ;
//assign  beat1 = ( beat==0)?2'b11: ((beat==1)?2'b10:((beat==2)? 2'b01:2'b00));
//assign  beat2 = ( beat==0)?2'b00: ((beat==1)?2'b11:((beat==2)? 2'b10:2'b01));
//assign  beat3 = ( beat==0)?2'b01: ((beat==1)?2'b00:((beat==2)? 2'b11:2'b10));

assign  beat0[1:0] = 2'b00;
assign  beat1[1:0] = 2'b01;
assign  beat2[1:0] = 2'b10;
assign  beat3[1:0] = 2'b11;


assign T1 = rD0+D1;
assign T2 = rD1+D0;


always@(posedge CLK or negedge RESET_N)
begin
	if( !RESET_N )
	begin
		R	<=	0;
		G	<=	0;
		B	<=	0;
		rD0<=	0;
		rD1<=	0;
	end
	else
	begin
		rD0	<=	D0;
		rD1	<=	D1;
		if({Y ,X }     == beat0)//2'b10)
		begin
			B	<=	 rD1;
			G	<=  T1[10:1];//D1;//T1[10:1];
			R	<=	 D0;//<--- rD1;
		end	
		else if({Y ,X }== beat1)//2'b11)
		begin
			B	<=	 D1;//rD0;
			G	<=  T2[10:1];//D0;//<---  T2[10:1];
			R	<=	 rD0;//D1
		end
		else if({Y ,X }== beat2)//2'b00)
		begin
			B	<=	rD0;//D1;
			G	<= T2[10:1];//D0 ;//<---- T2[10:1];
			R	<=	D1 ;//rD0;
		end
		else if({Y ,X }== beat3)//2'b01)
		begin
			B	<=	D0;//<----  rD1;
			G	<= T1[10:1];//D1;// T1[10:1];
			R	<=	rD1;//D0;
		end
	end
end


endmodule 