
module RAW2RGB_J(	
//---ccd 
input	  [9:0]	 iDATA,
input           VGA_CLK, 
input           READ_Request ,
input           VGA_VS ,	
input           VGA_HS ,
output	[7:0]  oRed,
output 	[7:0]  oGreen,
output	[7:0]    oBlue,
output   [7:0]    R_mean,
output   [7:0]    G_mean,
output   [7:0]    B_mean,

output reg [15:0] R_gain,
output reg [15:0] B_gain

);
//---R/B GAIN--
wire [15:0] G_mean_t ; 
assign G_mean_t ={ G_mean[7:0] , 8'h0 } ; 
//assign R_gain = G_mean_t/R_mean;
//assign B_gain = G_mean_t/B_mean;
always @(posedge VGA_VS )begin 

R_gain <= { G_mean[7:0] , 8'h0 }/R_mean;
B_gain <= { G_mean[7:0] , 8'h0 }/B_mean;
end

//------min--  max  --mean ----
wire [20:0] TCNT ; 

Comp_C_R  Comp_R(.CLK(VGA_CLK),.RST_N(VGA_VS ), .EN(READ_Request),.iCOLOR ( oRed	),.COLOR_min(),.COLOR_max(),.COLOR_mean(R_mean) );//,.TCNT(TCNT) );
Comp_C_R  Comp_G(.CLK(VGA_CLK),.RST_N(VGA_VS ), .EN(READ_Request),.iCOLOR (oGreen),.COLOR_min(),.COLOR_max(),.COLOR_mean(G_mean) );//,.TCNT(TCNT));
Comp_C_R  Comp_B(.CLK(VGA_CLK),.RST_N(VGA_VS ), .EN(READ_Request),.iCOLOR (oBlue),.COLOR_min() ,.COLOR_max(),.COLOR_mean(B_mean) );//,.TCNT(TCNT));
//---------------------------------
parameter VAL_LINE_MAX  = 640;//1280;//1920; 
parameter VAL_LINE_MIN	= 5 ; 
parameter VAL_HIGH_MAX  = 480;//720;//1080; 
parameter VAL_HIGH_MIN	= 2 ; 

//----- WIRE /REG --
wire	   [9:0]	mDAT0_0;
wire	   [9:0]	mDAT0_1;
wire 		[9:0]	mCCD_R;
wire 		[9:0]	mCCD_G; 
wire 		[9:0]	mCCD_B;
wire	[10:0]	mX_Cont;
wire	[10:0]	mY_Cont;

//-------- RGB OUT ---- 
assign   oRed	 = mCCD_R[9:2];
assign  oGreen  = mCCD_G[9:2] ;
assign	oBlue	 = mCCD_B[9:2];

//--------
VGA_RD_COUNTER  tr( 
  .VGA_CLK      (VGA_CLK     ),
  .VGA_VS       (VGA_VS      ), 
  .VGA_HS       (VGA_HS      ),
  .VGA_DE       (READ_Request),
  .X_Cont       (mX_Cont      ),
  .Y_Cont       (mY_Cont      )
 
) ;

//----3 2-PORT-LINE-BUFFER----  
Line_Buffer_J 	u0	(	
						.CCD_PIXCLK( VGA_CLK ),
						.mCCD_FVAL ( VGA_VS   ) ,
                  .mCCD_LVAL ( READ_Request) , 	
						.X_Cont    ( mX_Cont) , 
						.mCCD_DATA ( iDATA),
						.VGA_CLK   ( VGA_CLK), 
                  .READ_Request (READ_Request),	
                  .READ_Cont ( mX_Cont ),
                  .V_Cont    ( mY_Cont ),
						.taps0x    ( mDAT0_0),
						.taps1x    ( mDAT0_1)
						);					

//---ACTIVE REGION--
reg    RD_EN ; 
always @( posedge VGA_CLK  )  RD_EN <= (
                                       (( mX_Cont >= VAL_LINE_MIN ) && (mX_Cont < VAL_LINE_MAX )) & 
                                       (( mY_Cont >= VAL_HIGH_MIN ) && (mY_Cont < VAL_HIGH_MAX ))
													)?1:0 ; 		
//--- RAW10  TO  RGB 						
RAW_RGB_BIN  bin(
      .CLK  ( VGA_CLK ), 
      .RESET_N ( RD_EN ) , 
      .D0   ( mDAT0_0),
      .D1   ( mDAT0_1),
      .X    ( mX_Cont [0] ),
      .Y    ( mY_Cont [0] ),
       
      .R    ( mCCD_R),
      .G    ( mCCD_G), 
      .B    ( mCCD_B)
); 


endmodule
