

// free run pattern
module PATTERN_GEN(
	clk,
	reset_n,
	
	// start & result
	pat_start, // one pulse for start of pattern
	pattern
);

parameter PATTERN_WIDTH	= 32;
parameter PATTERN_CLK_NUM	= 1000;


	input													clk;
	input													reset_n;
	
	// start & result
	output	reg										pat_start; // one pulse for start of pattern
	output	reg	[(PATTERN_WIDTH-1):0] 	pattern;

//==============================
// pattern generator

reg [2:0] test_case;
reg [7:0]	shift_num;

`define ST_IDEL		3'd0
`define ST_CLK_1	3'd1 // 0x00, 0xFF, 0x00, 0xFF
`define ST_CLK_2	3'd2 // 0xAA, 0x55, 0xAA, 0x55
`define ST_ONE_1	3'd3
`define ST_ONE_0	3'd4

reg [31:0]	clk_cnt;
always @(posedge clk or negedge reset_n)
begin
	if (~reset_n)
	begin
		test_case <= `ST_IDEL;	
		shift_num <= 0;
	end
	
	else if (test_case == `ST_IDEL)
	begin
		test_case <= `ST_CLK_1;
		clk_cnt <= 0;
	end
	
	else if (test_case == `ST_CLK_1)
	begin
		if ((clk_cnt+1) < PATTERN_CLK_NUM)
			clk_cnt <= clk_cnt + 1;
		else 
		begin
			clk_cnt <= 0;
			test_case <= `ST_CLK_2;
		end
	end
	
	else if (test_case == `ST_CLK_2)
	begin
		if ((clk_cnt+1) < PATTERN_CLK_NUM)
			clk_cnt <= clk_cnt + 1;
		else 
		begin
			test_case <= `ST_ONE_1;
			shift_num <= 0;
		end	
	end
	
	else if (test_case == `ST_ONE_1)	
	begin
		if ((shift_num+1) == PATTERN_WIDTH)
		begin
			test_case <= `ST_ONE_0;
			shift_num <= 0;
		end
		else
			shift_num <= shift_num + 1; 
	end
	
	else if (test_case == `ST_ONE_0)	
	begin
		if ((shift_num+1) == PATTERN_WIDTH)
		begin
			test_case <= `ST_CLK_1; // from start
			clk_cnt <= 0;
		end
		else
			shift_num <= shift_num + 1; 
	end	
end


always @(posedge clk)
begin
	case(test_case)	
		`ST_IDEL:  pattern <= {(PATTERN_WIDTH){1'b0}};
		`ST_CLK_1: pattern <= {(PATTERN_WIDTH){(clk_cnt & 1'b1)?1'b1:1'b0}};
		`ST_CLK_2: pattern <= {((PATTERN_WIDTH+1)/2){(clk_cnt & 1'b1)?2'b01:2'b10}}; 
		`ST_ONE_1: pattern <= {{(PATTERN_WIDTH-1){1'b0}},1'b1} << shift_num;
		`ST_ONE_0: pattern <= ~{{{(PATTERN_WIDTH-1){1'b0}},1'b1} << shift_num};
	endcase
end

always @(posedge clk or negedge reset_n)
begin
	if (~reset_n)
		pat_start <= 1'b0;
	else if ((test_case == `ST_CLK_1)	&& (clk_cnt == 0))
		pat_start <= 1'b1;
	else
		pat_start <= 1'b0;
end


endmodule

