// Qsys_mm_ccb_1_mm_ccb_st_dc_fifo_1940_t75gi6a.v

// Generated using ACDS version 25.3.1 100

`timescale 1 ps / 1 ps
module Qsys_mm_ccb_1_mm_ccb_st_dc_fifo_1940_t75gi6a #(
		parameter SYMBOLS_PER_BEAT          = 1,
		parameter BITS_PER_SYMBOL           = 69,
		parameter FIFO_DEPTH                = 4,
		parameter ADDR_WIDTH                = 2,
		parameter CHANNEL_WIDTH             = 0,
		parameter ERROR_WIDTH               = 0,
		parameter USE_PACKETS               = 0,
		parameter USE_IN_FILL_LEVEL         = 1,
		parameter USE_OUT_FILL_LEVEL        = 1,
		parameter WR_SYNC_DEPTH             = 2,
		parameter RD_SYNC_DEPTH             = 2,
		parameter BACKPRESSURE_DURING_RESET = 1,
		parameter USE_SPACE_AVAIL_IF        = 1,
		parameter PIPELINE_POINTERS         = 0,
		parameter SYNC_RESET                = 0,
		parameter retiming_reg_en           = 0
	) (
		input  wire                                          in_clk,            //        in_clk.clk
		input  wire                                          in_reset_n,        //  in_clk_reset.reset_n
		input  wire                                          out_clk,           //       out_clk.clk
		input  wire                                          out_reset_n,       // out_clk_reset.reset_n
		input  wire                                          in_csr_address,    //        in_csr.address
		input  wire                                          in_csr_read,       //              .read
		input  wire                                          in_csr_write,      //              .write
		output wire [31:0]                                   in_csr_readdata,   //              .readdata
		input  wire [31:0]                                   in_csr_writedata,  //              .writedata
		input  wire                                          out_csr_address,   //       out_csr.address
		input  wire                                          out_csr_read,      //              .read
		input  wire                                          out_csr_write,     //              .write
		output wire [31:0]                                   out_csr_readdata,  //              .readdata
		input  wire [31:0]                                   out_csr_writedata, //              .writedata
		input  wire [(SYMBOLS_PER_BEAT*BITS_PER_SYMBOL)-1:0] in_data,           //            in.data
		input  wire                                          in_valid,          //              .valid
		output wire                                          in_ready,          //              .ready
		output wire [(SYMBOLS_PER_BEAT*BITS_PER_SYMBOL)-1:0] out_data,          //           out.data
		output wire                                          out_valid,         //              .valid
		input  wire                                          out_ready,         //              .ready
		output wire [2:0]                                    space_avail_data   //   space_avail.data
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (SYNC_RESET != 0)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					sync_reset_check ( .error(1'b1) );
		end
		if (retiming_reg_en != 0)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					retiming_reg_en_check ( .error(1'b1) );
		end
	endgenerate

	Qsys_mm_ccb_1_st_dc_fifo_1953_phmrs5y #(
		.SYMBOLS_PER_BEAT          (SYMBOLS_PER_BEAT),
		.BITS_PER_SYMBOL           (BITS_PER_SYMBOL),
		.FIFO_DEPTH                (FIFO_DEPTH),
		.ADDR_WIDTH                (ADDR_WIDTH),
		.CHANNEL_WIDTH             (CHANNEL_WIDTH),
		.ERROR_WIDTH               (ERROR_WIDTH),
		.USE_PACKETS               (USE_PACKETS),
		.USE_IN_FILL_LEVEL         (USE_IN_FILL_LEVEL),
		.USE_OUT_FILL_LEVEL        (USE_OUT_FILL_LEVEL),
		.WR_SYNC_DEPTH             (WR_SYNC_DEPTH),
		.RD_SYNC_DEPTH             (RD_SYNC_DEPTH),
		.BACKPRESSURE_DURING_RESET (BACKPRESSURE_DURING_RESET),
		.USE_SPACE_AVAIL_IF        (USE_SPACE_AVAIL_IF),
		.PIPELINE_POINTERS         (PIPELINE_POINTERS),
		.SYNC_RESET                (0),
		.retiming_reg_en           (0)
	) my_altera_avalon_dc_fifo_cmd_fifo (
		.in_clk             (in_clk),            //   input,                                   width = 1,        in_clk.clk
		.in_reset_n         (in_reset_n),        //   input,                                   width = 1,  in_clk_reset.reset_n
		.out_clk            (out_clk),           //   input,                                   width = 1,       out_clk.clk
		.out_reset_n        (out_reset_n),       //   input,                                   width = 1, out_clk_reset.reset_n
		.in_csr_address     (in_csr_address),    //   input,                                   width = 1,        in_csr.address
		.in_csr_read        (in_csr_read),       //   input,                                   width = 1,              .read
		.in_csr_write       (in_csr_write),      //   input,                                   width = 1,              .write
		.in_csr_readdata    (in_csr_readdata),   //  output,                                  width = 32,              .readdata
		.in_csr_writedata   (in_csr_writedata),  //   input,                                  width = 32,              .writedata
		.out_csr_address    (out_csr_address),   //   input,                                   width = 1,       out_csr.address
		.out_csr_read       (out_csr_read),      //   input,                                   width = 1,              .read
		.out_csr_write      (out_csr_write),     //   input,                                   width = 1,              .write
		.out_csr_readdata   (out_csr_readdata),  //  output,                                  width = 32,              .readdata
		.out_csr_writedata  (out_csr_writedata), //   input,                                  width = 32,              .writedata
		.in_data            (in_data),           //   input,  width = (SYMBOLS_PER_BEAT*BITS_PER_SYMBOL),            in.data
		.in_valid           (in_valid),          //   input,                                   width = 1,              .valid
		.in_ready           (in_ready),          //  output,                                   width = 1,              .ready
		.out_data           (out_data),          //  output,  width = (SYMBOLS_PER_BEAT*BITS_PER_SYMBOL),           out.data
		.out_valid          (out_valid),         //  output,                                   width = 1,              .valid
		.out_ready          (out_ready),         //   input,                                   width = 1,              .ready
		.space_avail_data   (space_avail_data),  //  output,                                   width = 3,   space_avail.data
		.in_startofpacket   (1'b0),              // (terminated),                                                            
		.in_endofpacket     (1'b0),              // (terminated),                                                            
		.out_startofpacket  (),                  // (terminated),                                                            
		.out_endofpacket    (),                  // (terminated),                                                            
		.in_empty           (1'b0),              // (terminated),                                                            
		.out_empty          (),                  // (terminated),                                                            
		.in_error           (1'b0),              // (terminated),                                                            
		.out_error          (),                  // (terminated),                                                            
		.in_channel         (1'b0),              // (terminated),                                                            
		.out_channel        (),                  // (terminated),                                                            
		.almost_full_valid  (),                  // (terminated),                                                            
		.almost_full_data   (),                  // (terminated),                                                            
		.almost_empty_valid (),                  // (terminated),                                                            
		.almost_empty_data  ()                   // (terminated),                                                            
	);

endmodule
