// Qsys_mm_ccb_0.v

// Generated using ACDS version 25.3.1 100

`timescale 1 ps / 1 ps
module Qsys_mm_ccb_0 #(
		parameter DATA_WIDTH             = 32,
		parameter SYMBOL_WIDTH           = 8,
		parameter HDL_ADDR_WIDTH         = 33,
		parameter BURSTCOUNT_WIDTH       = 1,
		parameter COMMAND_FIFO_DEPTH     = 4,
		parameter RESPONSE_FIFO_DEPTH    = 4,
		parameter MASTER_SYNC_DEPTH      = 2,
		parameter SLAVE_SYNC_DEPTH       = 2,
		parameter SYNC_RESET             = 0,
		parameter USE_IN_FILL_LEVEL_CSR  = 0,
		parameter USE_OUT_FILL_LEVEL_CSR = 0,
		parameter PIPELINE_ENABLE        = 0
	) (
		input  wire                        m0_clk,           //   m0_clk.clk,           Clock input
		input  wire                        m0_reset,         // m0_reset.reset,         Reset input
		input  wire                        s0_clk,           //   s0_clk.clk,           Clock input
		input  wire                        s0_reset,         // s0_reset.reset,         Reset input
		output wire                        s0_waitrequest,   //       s0.waitrequest,   Wait request to Avalon Memory Mapped Host, indicates agent is not ready
		output wire [DATA_WIDTH-1:0]       s0_readdata,      //         .readdata,      Read Data output from Avalon Memory Mapped Agent
		output wire                        s0_readdatavalid, //         .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		input  wire [BURSTCOUNT_WIDTH-1:0] s0_burstcount,    //         .burstcount,    Indicates number of burst transfers in each burst
		input  wire [DATA_WIDTH-1:0]       s0_writedata,     //         .writedata,     Write Data from Avalon Memory Mapped Host
		input  wire [HDL_ADDR_WIDTH-1:0]   s0_address,       //         .address,       Address output from Avalon Memory Mapped Host
		input  wire                        s0_write,         //         .write,         Write command from Avalon Memory Mapped Host
		input  wire                        s0_read,          //         .read,          Read command from Avalon Memory Mapped Host
		input  wire [3:0]                  s0_byteenable,    //         .byteenable,    Indicates valid read/write data location
		input  wire                        s0_debugaccess,   //         .debugaccess
		input  wire                        m0_waitrequest,   //       m0.waitrequest,   Wait request from Avalon Memory Mapped Agent, indicates agent is not ready
		input  wire [DATA_WIDTH-1:0]       m0_readdata,      //         .readdata,      Read Data input to Avalon Memory Mapped Host
		input  wire                        m0_readdatavalid, //         .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		output wire [BURSTCOUNT_WIDTH-1:0] m0_burstcount,    //         .burstcount,    Indicates number of burst transfers in each burst
		output wire [DATA_WIDTH-1:0]       m0_writedata,     //         .writedata,     Write Data from Avalon Memory Mapped Host
		output wire [HDL_ADDR_WIDTH-1:0]   m0_address,       //         .address,       Address output from Avalon Memory Mapped Host
		output wire                        m0_write,         //         .write,         Write command from Avalon Memory Mapped Host
		output wire                        m0_read,          //         .read,          Read command from Avalon Memory Mapped Host
		output wire [3:0]                  m0_byteenable,    //         .byteenable,    Indicates valid read/write data location
		output wire                        m0_debugaccess    //         .debugaccess
	);

	Qsys_mm_ccb_0_mm_ccb_1940_lr4at6q #(
		.DATA_WIDTH             (DATA_WIDTH),
		.SYMBOL_WIDTH           (SYMBOL_WIDTH),
		.HDL_ADDR_WIDTH         (HDL_ADDR_WIDTH),
		.BURSTCOUNT_WIDTH       (BURSTCOUNT_WIDTH),
		.COMMAND_FIFO_DEPTH     (COMMAND_FIFO_DEPTH),
		.RESPONSE_FIFO_DEPTH    (RESPONSE_FIFO_DEPTH),
		.MASTER_SYNC_DEPTH      (MASTER_SYNC_DEPTH),
		.SLAVE_SYNC_DEPTH       (SLAVE_SYNC_DEPTH),
		.ENABLE_RESPONSE        (0),
		.SYNC_RESET             (SYNC_RESET),
		.USE_IN_FILL_LEVEL_CSR  (USE_IN_FILL_LEVEL_CSR),
		.USE_OUT_FILL_LEVEL_CSR (USE_OUT_FILL_LEVEL_CSR),
		.PIPELINE_ENABLE        (PIPELINE_ENABLE)
	) mm_ccb_0 (
		.m0_clk                (m0_clk),                               //   input,                 width = 1,   m0_clk.clk
		.m0_reset              (m0_reset),                             //   input,                 width = 1, m0_reset.reset
		.s0_clk                (s0_clk),                               //   input,                 width = 1,   s0_clk.clk
		.s0_reset              (s0_reset),                             //   input,                 width = 1, s0_reset.reset
		.s0_waitrequest        (s0_waitrequest),                       //  output,                 width = 1,       s0.waitrequest
		.s0_readdata           (s0_readdata),                          //  output,        width = DATA_WIDTH,         .readdata
		.s0_readdatavalid      (s0_readdatavalid),                     //  output,                 width = 1,         .readdatavalid
		.s0_burstcount         (s0_burstcount),                        //   input,  width = BURSTCOUNT_WIDTH,         .burstcount
		.s0_writedata          (s0_writedata),                         //   input,        width = DATA_WIDTH,         .writedata
		.s0_address            (s0_address),                           //   input,    width = HDL_ADDR_WIDTH,         .address
		.s0_write              (s0_write),                             //   input,                 width = 1,         .write
		.s0_read               (s0_read),                              //   input,                 width = 1,         .read
		.s0_byteenable         (s0_byteenable),                        //   input,                 width = 4,         .byteenable
		.s0_debugaccess        (s0_debugaccess),                       //   input,                 width = 1,         .debugaccess
		.m0_waitrequest        (m0_waitrequest),                       //   input,                 width = 1,       m0.waitrequest
		.m0_readdata           (m0_readdata),                          //   input,        width = DATA_WIDTH,         .readdata
		.m0_readdatavalid      (m0_readdatavalid),                     //   input,                 width = 1,         .readdatavalid
		.m0_burstcount         (m0_burstcount),                        //  output,  width = BURSTCOUNT_WIDTH,         .burstcount
		.m0_writedata          (m0_writedata),                         //  output,        width = DATA_WIDTH,         .writedata
		.m0_address            (m0_address),                           //  output,    width = HDL_ADDR_WIDTH,         .address
		.m0_write              (m0_write),                             //  output,                 width = 1,         .write
		.m0_read               (m0_read),                              //  output,                 width = 1,         .read
		.m0_byteenable         (m0_byteenable),                        //  output,                 width = 4,         .byteenable
		.m0_debugaccess        (m0_debugaccess),                       //  output,                 width = 1,         .debugaccess
		.s0_response           (),                                     // (terminated),                                     
		.s0_writeresponsevalid (),                                     // (terminated),                                     
		.m0_response           (2'b00),                                // (terminated),                                     
		.m0_writeresponsevalid (1'b0),                                 // (terminated),                                     
		.in_csr_address        (6'b000000),                            // (terminated),                                     
		.in_csr_read           (1'b0),                                 // (terminated),                                     
		.in_csr_write          (1'b0),                                 // (terminated),                                     
		.in_csr_readdata       (),                                     // (terminated),                                     
		.in_csr_writedata      (32'b00000000000000000000000000000000), // (terminated),                                     
		.out_csr_address       (6'b000000),                            // (terminated),                                     
		.out_csr_read          (1'b0),                                 // (terminated),                                     
		.out_csr_write         (1'b0),                                 // (terminated),                                     
		.out_csr_readdata      (),                                     // (terminated),                                     
		.out_csr_writedata     (32'b00000000000000000000000000000000)  // (terminated),                                     
	);

endmodule
