// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $File: //acds/rel/25.3.1/ip/iconnect/avalon_st/altera_avalon_dc_fifo/altera_dcfifo_synchronizer_bundle.v $
// $Revision: #1 $
// $Date: 2025/10/16 $
// $Author: psgswbuild $
//-------------------------------------------------------------------------------

`timescale 1 ns / 1 ns
module altera_dcfifo_synchronizer_bundle(
                                     clk,
                                     reset_n,
                                     din,
                                     dout
                                     );
   parameter WIDTH = 1;
   parameter DEPTH = 3;   
   parameter retiming_reg_en = 0;

   input clk;
   input reset_n;
   input [WIDTH-1:0] din;
   output [WIDTH-1:0] dout;
   
   genvar i;
   
   generate
      for (i=0; i<WIDTH; i=i+1)
        begin : sync
           altera_std_synchronizer_nocut #(.depth(DEPTH), .retiming_reg_en(retiming_reg_en))
                                   u (
                                      .clk(clk), 
                                      .reset_n(reset_n), 
                                      .din(din[i]), 
                                      .dout(dout[i])
                                      );
        end
   endgenerate
   
endmodule 

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "FQbdgc6L7IBAY6fOekGDZSoPPgzAvTLS5KI4ZFuNrzNpTW8vAdrHoXjbN9QDDni9wandNqca4alTzfPQdbuyX8xJkBUKByOgHDrbWP9Om8Wf/wBzwdp7QRgAIoMl3XHkp6wfCOAmKGBGXhS+D0N58GZjgAxZE5k1kPkGwTW2HK66FVEKxZmgFTH/3PkyONzjSYFAnIyDnLAccODH1NLcP+QMpGqPUsBsbddxoMEc9m4nkUasWpOf/asFAWkNYySlC70D+uoSMjq6YrcUJ7oRsfg6WM/Wln2evTHVCDXW2m84i87zFDXZSEEjH6m0XlarmH/wnCgDu1J6n/KLVBq8sgwU/NLOzIbPYAEr3zhcdRhwBbdS1Zn759KW6u0APU4LL9AnSJSWyFO2TAyOQdL2XQi0hy5etR7ar7QLlSt6m/Hw3mX6WdRWVGXArmgus9cZjONXdQlKCwqHrf0A5Z5f1STgVKXDEvXa8lwHizGM+K+AJx4mkT/K0Q3eEIgVwAM9n9LOO25qaOfJhpNITalTg+mb6V9pKnIQfoA7rZtAmNDiU5dH5iAG/zGmktbhUqQDVVVfxBBekAztgYWVRBkgPbybsRvtYfqpW2HmAeFe23XCdM9wkOVhJa+pEL8FpZX+QG/Yc/6F2IClkkDZ+BeoY/r+W1hMC2JRHZAmTpQZdzxcScr8FLpUEGFnZLBhCIcAuKTmY1bmJPoIMn2+7DSF+bcBl4DnWnxKnovoAHCOHNfWnwnnchb4D9enSx3/4/aYEVPbhTn6VgkutGuV5YJv9Kmv6KM2Lxuy5PeIZUvzuFSdnP7ILK60/bfI9fiElVI+C8QQIE0ErldlP0IhQSKdzd6Elm7v2W0I9CAUqPmej0pW7oPv8OhrPmcx5AT5JmhkHnHQg48J53Ul58GfoQMUoQBTRmR1zxtJBEEsc1VmhXxdECVOfBEENvf/q9Wr7wTkJjZejYuDNEfV/b42NPu0pgGZWFu0GhF4lfpRxqUsOLLiE49KYUQe6a9hD3sCwotM"
`endif