// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module rd_sipo_plus_cwyib4q #(
    parameter DEPTH = 1, 
    parameter TOTAL_W = 35,
    parameter ID_W    =10
) (
    input clk,
    input rst,
    input in_valid,
    input [TOTAL_W-2:0] in_data, 
    output in_ready,
    input [DEPTH-1:0] clr, 
    output [DEPTH-1:0] shift_occurred, 
    output [TOTAL_W-1:0] dout0

);

logic [TOTAL_W-1:0] mem[DEPTH-1:0];




logic shift_in;



assign shift_in  = in_ready & in_valid;




always @ (posedge clk) begin
    if (shift_in)
        mem[1-1][TOTAL_W-2:0] <= in_data[TOTAL_W-2:0];

end

always @ (posedge clk) begin

    if (rst)
        mem[0][TOTAL_W-1] <= 0;
    else if (shift_in)
        mem[0][TOTAL_W-1] <= 1 & (! clr[0]);
    else if (clr[0])
        mem[0][TOTAL_W-1] <= 0;

end

assign in_ready = !(  mem[0][TOTAL_W-1]  );

assign dout0 = mem[0];

endmodule
    


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkZ9cq8yj3Jzl6OAwDf/CB1N3n4F8xQmfsn4uRfxcbrCHdcIPHtoNVZGsefMb8HptMH9gVaQHNlx16pw0IW216PpFytNd4ZTdCzFJ9EdKWe/eNprHFF8tWvd8Q4QHwIxHIYX2jWcXBMmgZWpl9pbMZvezafHJAAO2KkFEaGZMxAdE9kP3imG+ep4iEbHcq4KhEcPW91JytufKZtNpYa3BODD0ArsueUPLW51lLAs6W1BlW6W+6/pBkmrAlyD6q/vgizhounpIwgn/7EKg3Fpo+nRd0//hY8AYZlrQilXvdXArAElPaya1bqZsl3uUM277bdioPYykkrAX/ofsuyzSyf6Uk8wZCPSpgUibJCqbLnkmEfsxy9vrVGipUEOlOoCOecVQaNbAHciiHO1Zmv0bomyBIbAHahZQAyTE3QKuIA/mj2Yr6IQDViH00ueXhhGmDvxgKD5p147U1T9mirNhj1vSQyqe+sVbveG/PMoJ6hfYb42bBm0jOYoLiEu2/o0lqbKt1RkO2LROF5n0s7ldXsq8YaJ7NCTMsobxLHnNEVgV0onoGsQ62A/IOAyHqiEsjrudfjKJ2FwOfct6/zBNXjjCU9kBkPD8E7OaWDSzkX2M0RsxZJlO3ORBSpxnD3vu51A2yJTrFBM+POZeZr/m5laBIIv+bALw3yNgJzTjzZlVV8aCoNwhGOBjd+EJRdWxMX3G3rb1ly9KVNjScAAD4FkTJ1oSDE7++GfkgOMwUMVqolvpDbVyDh4dyg39tIkY1XJkuulhNNUDlq6a8BPWtlY"
`endif