// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`ifndef CAL_ARCH_FP_INTERFACE

`define CAL_ARCH_FP_INTERFACE 1

// altera message_off 18455
interface AXILITE_BUS #(
  parameter int signed PORT_AXI_AXADDR_WIDTH  = 0,
  parameter int signed PORT_AXI_AXID_WIDTH    = 0,
  parameter int signed PORT_AXI_AXBURST_WIDTH = 0,
  parameter int signed PORT_AXI_AXLEN_WIDTH   = 0,
  parameter int signed PORT_AXI_AXSIZE_WIDTH  = 0,
  parameter int signed PORT_AXI_AXUSER_WIDTH  = 0,
  parameter int signed PORT_AXI_DATA_WIDTH    = 0,
  parameter int signed PORT_AXI_STRB_WIDTH    = 0,
  parameter int signed PORT_AXI_RESP_WIDTH    = 0,
  parameter int signed PORT_AXI_ID_WIDTH      = 0,
  parameter int signed PORT_AXI_USER_WIDTH    = 0,
  parameter int signed PORT_AXI_AXQOS_WIDTH   = 0,
  parameter int signed PORT_AXI_AXCACHE_WIDTH = 0,
  parameter int signed PORT_AXI_AXPROT_WIDTH  = 0
);

typedef logic                              clk_t;
typedef logic                              rst_n_t;
typedef logic [PORT_AXI_AXADDR_WIDTH-1:0]  addr_t;
typedef logic [PORT_AXI_AXID_WIDTH-1:0]    id_t;
typedef logic [PORT_AXI_AXBURST_WIDTH-1:0] burst_t;
typedef logic [PORT_AXI_AXLEN_WIDTH-1:0]   len_t;
typedef logic [PORT_AXI_AXSIZE_WIDTH-1:0]  size_t;
typedef logic [PORT_AXI_AXUSER_WIDTH-1:0]  user_t;
typedef logic [PORT_AXI_DATA_WIDTH-1:0]    data_t;
typedef logic [PORT_AXI_STRB_WIDTH-1:0]    strb_t;
typedef logic [PORT_AXI_RESP_WIDTH-1:0]    resp_t;
typedef logic [PORT_AXI_ID_WIDTH-1:0]      respid_t;
typedef logic [PORT_AXI_USER_WIDTH-1:0]    respuser_t;
typedef logic [PORT_AXI_AXQOS_WIDTH-1:0]   qos_t;
typedef logic [PORT_AXI_AXCACHE_WIDTH-1:0] cache_t;
typedef logic [PORT_AXI_AXPROT_WIDTH-1:0]  prot_t;

clk_t             clk;
rst_n_t           rst_n;

id_t              awid;
addr_t            awaddr;
len_t             awlen;
size_t            awsize;
burst_t           awburst;
logic             awlock;
cache_t           awcache;
prot_t            awprot;
qos_t             awqos;
user_t            awuser;
logic             awvalid;
logic             awready;

data_t            wdata;
strb_t            wstrb;
logic             wlast;
respuser_t        wuser;
logic             wvalid;
logic             wready;

respid_t          bid;
resp_t            bresp;
respuser_t        buser;
logic             bvalid;
logic             bready;

id_t              arid;
addr_t            araddr;
len_t             arlen;
size_t            arsize;
burst_t           arburst;
logic             arlock;
cache_t           arcache;
prot_t            arprot;
qos_t             arqos;
user_t            aruser;
logic             arvalid;
logic             arready;

respid_t          rid;
data_t            rdata;
resp_t            rresp;
logic             rlast;
respuser_t        ruser;
logic             rvalid;
logic             rready;

modport Manager (
   input clk, rst_n,
   output awid, awaddr, awlen, awsize, awburst, awlock, awcache, awprot, awqos, awuser, awvalid, input awready,
   output wdata, wstrb, wlast, wuser, wvalid, input wready,
   input bid, bresp, buser, bvalid, output bready,
   output arid, araddr, arlen, arsize, arburst, arlock, arcache, arprot, arqos, aruser, arvalid, input arready,
   input rid, rdata, rresp, rlast, ruser, rvalid, output rready
);

modport Subordinate (
   output clk, rst_n,
   input awid, awaddr, awlen, awsize, awburst, awlock, awcache, awprot, awqos, awuser, awvalid, output awready,
   input wdata, wstrb, wlast, wuser, wvalid, output wready,
   output bid, bresp, buser, bvalid, input bready,
   input arid, araddr, arlen, arsize, arburst, arlock, arcache, arprot, arqos, aruser, arvalid, output arready,
   output rid, rdata, rresp, rlast, ruser, rvalid, input rready
);

endinterface

`endif 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "YYu88PT9izVA6NeFBTvys98gjk5g4irS06EuwH1QIcjAsdKMl9ssGNiFxUvg0X1zJGfpILv/90vMEPJVPe8MsfXkGkQT4YnCYV4m1u31DU3z8Un4IPgXSRwNd7X1QQGUFqeqK4HSuF5OVrS4MvdocQiF7NToppLvCmgBiOI2Yq4yZYSrNXJQll0Iyk0CWtf9tbCXxTLOBSNS917xUaRMNbpZjjuVFpJ89QWUrIpm+hxmWi5n8kb4PlsRpljI2mcX+bYf3D44UZvoj2ZlzNn199nDTZBEJbZ9utn87a7/2RyVKldEp/8T19h9tJr/UGcm7+MEwCB/QWg4XUgRXBQB+j6SWAXVFwMtlbVIMo8p4IEEr78/NqRvWaZTCYzfJT41mjPphFdhwOH86bLIn++lOB1vqaRS4VnbmtsQnTqqiKGDyBA6FTA+FA+DlXqD0L+Wer4JKGWE0uYcO7S1izjI44vENKecL1Xw75gK0GevEtJpHaxPBCRJebaLVdShet/5wfS1pwIp/bvbFqyKlChGmViZLXjDVnaGBo+7ezj3FseJNrkwHVYa9bdIiwkAoy5hI382qvEzeLyDhRMlK22OqLMqV1MvibdfJFUicF5FyRPVLdTWa3h/JKOph3vy1DG4YHRIXKk3kOkfEh34ZxsVKCFmGqlFSNNtdCi/XrJjC7Xm6vMQsBLIKP7kTjgNELkAkaSZRGsUgL5p3KT58CgIGN7I0p9tCh3HHcbJUjMZMdKPsC3kfNC9Pid79n49HcLELhpQ0StuvdqLj6yD2iOZBjpGG2Da/0z0hFpMUszjeqbSotDXjKduZnmetuuGhWNDwnYWU930uB34LhaPzWgmVtiy9Kb3HNrl/7YfKDaf4pVJoGf7RjB/Zjv5xpHzM+6a+AqyBsb1n3AsE1HKmbsywS/gztxedMaX6MHLSEGA7e2A6ruyUg4flqUYxX8uOY7EwDpX+G77wxxHIS/GYq+HC0qrzvKrSOhB/qjTJZ+T0df4zLQwGHNdL3Bx7B0NUKDa"
`endif