// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.






`timescale 1 ns / 1 ns



// altera message_off 16753
module ed_synth_dut_altera_merlin_demultiplexer_1921_c2mlp5i
(
    input  [1-1      : 0]   sink_valid,
    input  [440-1    : 0]   sink_data, 
    input  [2-1 : 0]   sink_channel, 
    input                         sink_startofpacket,
    input                         sink_endofpacket,
    output                        sink_ready,

    output reg                      src0_valid,
    output reg [440-1    : 0] src0_data, 
    output reg [2-1 : 0] src0_channel, 
    output reg                      src0_startofpacket,
    output reg                      src0_endofpacket,
    input                           src0_ready,


    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input clk,
    (*altera_attribute = "-name MESSAGE_DISABLE 15610" *) 
    input reset

);

    localparam NUM_OUTPUTS = 1;
    wire [NUM_OUTPUTS - 1 : 0] ready_vector;

    always @* begin
        src0_data          = sink_data;
        src0_startofpacket = sink_startofpacket;
        src0_endofpacket   = sink_endofpacket;
        src0_channel       = sink_channel >> NUM_OUTPUTS;

        src0_valid         = sink_channel[0] && sink_valid;

    end

    assign ready_vector[0] = src0_ready;

    assign sink_ready = |(sink_channel & {{1{1'b0}},{ready_vector[NUM_OUTPUTS - 1 : 0]}});

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "TCSI+l9TsvpNm5zWo4wf8S4CBVeml6hxYnRcvYFHGVdKrV70QtjK/Q97rnYnju29dHEElln5C63xhDaAHrDBjpTVdTMpcZmuTN8lZKh5UsIF1+KNWjGCPGEcQfOpPms/DsTE+mwaq652nt9MxysR2++l9VLHamXPFWmxpBLBMiG3v0i3UjbzPV6heoBbtnxsCXSHasHlrPtUh5zo5ECSylkvBjcVwStL/mWtlrEp1x+aFx16g5J14kS1y8gr9lUkvT9iXwpMWrP96P1qejIP1biJrSUSaQF7Knk6AihlA7OTLpTb6T1j4VG4XUUd+A1qtzeWE1J41Jhdzb7TUaxASQVCVpxwDNZ2zdywyKClOPodqwBIw8UYutUmo6twOmJxOIvLdF9ajQJFCXsQPWfnqq3fawgVuVn4TV9f8ytwDX66/QExNo3tHum/j49tO+PGBgbB/QQfY8yQMtmO0ZpzrROZWID4r2Xp26fIgAEBy3zHZu9pv2u89drzPLbPTOBr5LYxw4wdC14cQshffzKPNiYLa9D494Hci/+/n57OF1LrbZcaL9H4PZRWrPd7PCqsU4btKIuZK3xqJ7EqfOXQHA97w/V65NtEPCJjl946xLktU+B0d1Ewr+vR4iK2fwqvVXLAN0tpX+HSP8OJiy4jNsqHETpkxH23a/gIXSktuTruItnu8BTipTrMeVFJKtdbg7OfpNUIgthyzC5VdJd16l0PjBLlZHEbIuDk/xhnxHjBU53vzK6tm5leMG4iECid/jqhZE+6ZYvbgES0/hsMq/0W7ApyFG58VKvCVNbH3PxAp5GPEiEZC7N4Wz2vJO6XHYYAxRcDFDVMYnXfaCJLczkkGKoDm+Wc43o1Rg7ND5/08+m8AHgQoL8PSv9cdx8HRkePG8jSkIguerWPFR9jvqEMYWmElEqZ4Q142tIpnw7bFsIcLr5KwIQuMB6Tt812xqVZXbNsnWm//RvfbcU21Gz0d5D9/vB5R729W5gReQoLGm9TqX4Y6Msu4Vqiw7jh"
`endif