
// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue Oct 21 15:55:14 2025
// ============================================================================

`define ENABLE_LPDDR4A
`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM
//`define ENABLE_HDMI

module golden_top(

      ///////// CLOCK /////////
//      input              CLK_100_B2A_p,
      input              CLK_100_p,
      input              CLK_50_B5A,
//      input              CLK_50_B6A,
//      input              CLK_50_B6C,
//      input              CLK_50_B6F,
//      input              CLK_50_B6H,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active

      ///////// Switches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output   [ 1: 0]   LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output   [ 1: 0]   LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 1: 0]   LPDDR4B_DM,
      inout    [15: 0]   LPDDR4B_DQ,
      inout    [ 1: 0]   LPDDR4B_DQS,
      inout    [ 1: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      input              HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,
`endif /*ENABLE_HDMI*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 3: 0]   CAM_D_p,
      input    [ 3: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ0,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout              HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout    [ 1: 0]   HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p,
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n, 
`endif /*ENABLE_HPS*/

      ///////// I2Cs /////////
      inout              FAN_I2C_SCL,
      inout              FAN_I2C_SDA,
      input              FAN_ALERT_n,

      ///////// PM /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D
);


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================

wire ninit_done;
    agilex_reset_release agilex_reset_release_Inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );


//=======================================================
//  Reset and Control Signals
//=======================================================
wire reset_n;
assign reset_n =  !ninit_done;




//=======================================================
//  Qsys Platform Designer Instantiation
//=======================================================

    Qsys Qsys_Inst (
        .clk_clk                                 (CLK_50_B5A),                                 //   input,   width = 1,                             clk.clk
        //.emif_lpddr4a_s0_axi4_ctrl_ready_reset_n (_connected_to_emif_lpddr4a_s0_axi4_ctrl_ready_reset_n_), //  output,   width = 1, emif_lpddr4a_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4a_mem_mem_cs                        (LPDDR4A_CS_n),                        //  output,    width = 2,                        emif_lpddr4a_mem.mem_cs
        .emif_lpddr4a_mem_mem_ca                        (LPDDR4A_CA),                        //  output,    width = 6,                                        .mem_ca
        .emif_lpddr4a_mem_mem_cke                       (LPDDR4A_CKE),                       //  output,    width = 2,                                        .mem_cke
        .emif_lpddr4a_mem_mem_dq                        (LPDDR4A_DQ),                        //   inout,   width = 32,                                        .mem_dq
        .emif_lpddr4a_mem_mem_dqs_t                     (LPDDR4A_DQS),                     //   inout,    width = 4,                                        .mem_dqs_t
        .emif_lpddr4a_mem_mem_dqs_c                     (LPDDR4A_DQS_n),                     //   inout,    width = 4,                                        .mem_dqs_c
        .emif_lpddr4a_mem_mem_dmi                       (LPDDR4A_DM),                       //   inout,    width = 4,                                        .mem_dmi
        .emif_lpddr4a_mem_ck_mem_ck_t                   (LPDDR4A_CK),                   //  output,    width = 1,                     emif_lpddr4a_mem_ck.mem_ck_t
        .emif_lpddr4a_mem_ck_mem_ck_c                   (LPDDR4A_CK_n),                   //  output,    width = 1,                                        .mem_ck_c
        .emif_lpddr4a_mem_reset_n_mem_reset_n           (LPDDR4A_RESET_n),           //  output,    width = 1,                emif_lpddr4a_mem_reset_n.mem_reset_n
        .emif_lpddr4a_oct_oct_rzqin                     (LPDDR4A_RZQ),                     //   input,    width = 1,                        emif_lpddr4a_oct.oct_rzqin
        .emif_lpddr4a_ref_clk_clk                       (LPDDR4A_REFCLK_p),                       //   input,    width = 1,                    emif_lpddr4a_ref_clk.clk
        
		  //.emif_lpddr4b_s0_axi4_ctrl_ready_reset_n (_connected_to_emif_lpddr4b_s0_axi4_ctrl_ready_reset_n_), //  output,   width = 1, emif_lpddr4b_s0_axi4_ctrl_ready.reset_n
        .emif_lpddr4b_mem_mem_cs                        (LPDDR4B_CS_n),                        //  output,    width = 1,                        emif_lpddr4b_mem.mem_cs
        .emif_lpddr4b_mem_mem_ca                        (LPDDR4B_CA),                        //  output,    width = 6,                                        .mem_ca
        .emif_lpddr4b_mem_mem_cke                       (LPDDR4B_CKE),                       //  output,    width = 1,                                        .mem_cke
        .emif_lpddr4b_mem_mem_dq                        (LPDDR4B_DQ),                        //   inout,   width = 16,                                        .mem_dq
        .emif_lpddr4b_mem_mem_dqs_t                     (LPDDR4B_DQS),                     //   inout,    width = 2,                                        .mem_dqs_t
        .emif_lpddr4b_mem_mem_dqs_c                     (LPDDR4B_DQS_n),                     //   inout,    width = 2,                                        .mem_dqs_c
        .emif_lpddr4b_mem_mem_dmi                       (LPDDR4B_DM),                       //   inout,    width = 2,                                        .mem_dmi
        .emif_lpddr4b_mem_ck_mem_ck_t                   (LPDDR4B_CK),                   //  output,    width = 1,                     emif_lpddr4b_mem_ck.mem_ck_t
        .emif_lpddr4b_mem_ck_mem_ck_c                   (LPDDR4B_CK_n),                   //  output,    width = 1,                                        .mem_ck_c
        .emif_lpddr4b_mem_reset_n_mem_reset_n           (LPDDR4B_RESET_n),           //  output,    width = 1,                emif_lpddr4b_mem_reset_n.mem_reset_n
        .emif_lpddr4b_oct_oct_rzqin                     (LPDDR4B_RZQ),                     //   input,    width = 1,                        emif_lpddr4b_oct.oct_rzqin
        .emif_lpddr4b_ref_clk_clk                       (LPDDR4B_REFCLK_p),                       //   input,    width = 1,                    emif_lpddr4b_ref_clk.clk
        
		  .pio_key_external_connection_export      (USER_BUTTON),      //   input,   width = 1,     pio_key_external_connection.export
        .pio_led_external_connection_export      (USER_LED),      //  output,   width = 1,     pio_led_external_connection.export
        .reset_reset_n                           (reset_n)                            //   input,   width = 1,                           reset.reset_n
    );



endmodule
