#**************************************************************
# This .sdc file is created by Terasic Tool.
# Users are recommended to modify this file to match users logic.
#**************************************************************

#**************************************************************
# Create Clock
#**************************************************************
# CLOCK
create_clock -period "100MHz" [get_ports CLK_100_B2A_p]
create_clock -period "100MHz" [get_ports CLK_100_p]
create_clock -period "50MHz" [get_ports CLK_50_B5A]
create_clock -period "50MHz" [get_ports CLK_50_B6A]
create_clock -period "50MHz" [get_ports CLK_50_B6C]
create_clock -period "50MHz" [get_ports CLK_50_B6F]
create_clock -period "50MHz" [get_ports CLK_50_B6H]
# LPDDR4A
create_clock -period "166.666MHz" [get_ports LPDDR4A_REFCLK_p]
# LPDDR4B
create_clock -period "166.666MHz" [get_ports LPDDR4B_REFCLK_p]
# USB3
create_clock -period "100MHz" [get_ports HPS_USB3_REFCLK_100M_p]


#**************************************************************
# Create Generated Clock
#**************************************************************
# HDMI CLK
create_generated_clock  -name hdmi_tx_clk -source [get_pins {u_sys_pll|iopll_0|tennm_ph2_iopll|out_clk[0]}] \
                        -invert [get_ports {HDMI_TX_CLK_p}]



#**************************************************************
# Set Clock Latency
#**************************************************************



#**************************************************************
# Set Clock Uncertainty
#**************************************************************
derive_clock_uncertainty


#**************************************************************
# Set Input Delay
#**************************************************************



#**************************************************************
# Set Output Delay
#**************************************************************
set clk_name "hdmi_tx_clk"
set fpga_output_ports [get_ports {HDMI_TX_D[*] HDMI_TX_DE HDMI_TX_HS HDMI_TX_VS}]
set max_output_delay [expr {1.2 + 0.0}] ; # 1.2ns t_su + 0.0ns board_delay_max
set min_output_delay [expr {-1.3 + 0.0}] ; # -1.3ns t_h + 0.0ns board_delay_min
set_output_delay -clock $clk_name -max $max_output_delay $fpga_output_ports
set_output_delay -clock $clk_name -min $min_output_delay $fpga_output_ports



#**************************************************************
# Set Clock Groups
#**************************************************************



#**************************************************************
# Set False Path
#**************************************************************



#**************************************************************
# Set Multicycle Path
#**************************************************************



#**************************************************************
# Set Maximum Delay
#**************************************************************



#**************************************************************
# Set Minimum Delay
#**************************************************************



#**************************************************************
# Set Input Transition
#**************************************************************



#**************************************************************
# Set Load
#**************************************************************



