from struct import unpack

width = 0
height = 0
bit_count = 0

def analyze_bmp_color_table(filename):
    with open(filename, 'rb') as f:
        # 讀取 BMP 標頭 (前 54 個位元組)
        header = f.read(54)

        global bit_count
        global width
        global height
        # 從標頭中提取顏色深度
        bit_count = unpack('<H', header[28:30])[0]
        # 提取圖像寬度和高度
        width, height = unpack('<II', header[18:26])

        # 如果顏色深度大於 8，表示不是索引色圖像，沒有調色盤
        if bit_count > 8:
            # print("此 BMP 檔案沒有 color table，將從 pixel table 生成。")

            # 計算每行像素數據的位元組數 (需要考慮 4 位元組對齊)
            row_size = ((bit_count * width + 31) // 32) * 4

            # 跳到像素數據的起始位置
            f.seek(unpack('<I', header[10:14])[0])

            # 掃描像素數據，構建 color table
            color_table = set()  # 使用集合避免重複顏色
            for _ in range(height):
                row_data = f.read(row_size)
                for i in range(0, len(row_data), bit_count // 8):
                    color = row_data[i:i + bit_count // 8]
                    color_table.add(color)

            color_table = list(color_table)  # 轉換為列表
            color_table.sort()

        else:
            # 提取調色盤中的顏色數量
            num_colors = unpack('<I', header[46:50])[0]
            if num_colors == 0:
                num_colors = 2 ** bit_count

            # 讀取調色盤中的顏色條目
            color_table = []
            for _ in range(num_colors):
                b, g, r, _ = unpack('<BBBB', f.read(4))
                color_table.append((b, g, r))

    return color_table

def replace_pixels_with_color_indices(filename, color_table):
    pixel_index = []
    with open(filename, 'rb') as f:  # 打開檔案，允許讀寫
        # 讀取 BMP 標頭 (前 54 個位元組)
        header = f.read(54)

        # 從標頭中提取顏色深度、圖像寬度和高度
        bit_count = unpack('<H', header[28:30])[0]
        width, height = unpack('<II', header[18:26])

        # 計算每行像素數據的位元組數 (需要考慮 4 位元組對齊)
        row_size = ((bit_count * width + 31) // 32) * 4

        # 跳到像素數據的起始位置
        f.seek(unpack('<I', header[10:14])[0])

        # 逐行掃描像素數據，替換為 color table 索引
        for j in range(height):
            row_data = f.read(row_size)
            # 如果顏色深度大於 8，表示不是索引色圖像，沒有調色盤
            if bit_count > 8:
                for i in range(0, len(row_data), bit_count // 8):
                    color = row_data[i:i + bit_count // 8]
                    try:
                        index = color_table.index(color)  # 找到顏色在 color table 中的索引
                    except ValueError:
                        # 如果顏色不在 color table 中，可以選擇忽略或進行其他處理
                        index = 255  # 這裡簡單地將其設置為 255
                    pixel_index.append(index)
            else:
                for i in range(len(row_data)):
                    index = row_data[i]
                    pixel_index.append(index)

        return pixel_index

# 範例用法
filename = 'test.bmp'
color_table = analyze_bmp_color_table(filename)

print(f"height = {height}")
print(f"width = {width}")


if len(color_table) > 256:
    print("顏色數量超過256")
    exit()

pixel_index = replace_pixels_with_color_indices(filename, color_table)

# for i, color in enumerate(pixel_index):
    # print(f"Index {i}: color={color}")

# for i in range(16):
    # print(f"Index {i}: color={hex(pixel_index[i])}")

for i in range(256 - len(color_table)):
    color_table.append(b'\xFF\xFF\xFF')

with open("index.mif", "w") as f:
    f.write("WIDTH = 24;\nDEPTH = 256;\n\nADDRESS_RADIX = HEX;\nDATA_RADIX = HEX;\n\nCONTENT BEGIN\n")
    for i, color in enumerate(color_table):
        b, g, r = color if len(color) == 3 else color + b'\0'  # 處理不同顏色深度
        f.write(f"{format(i, '02x')}:{format(b, '02x')}{format(g, '02x')}{format(r, '02x')};\n")
    f.write("END;\n")

# 計算每行像素數據的位元組數 (需要考慮 4 位元組對齊)
row_size = ((bit_count * width + 31) // 32) * 4

with open("data.mif", "w") as f:
    f.write(f"WIDTH = 8;\nDEPTH = {(height-10)*width};\n\nADDRESS_RADIX = HEX;\nDATA_RADIX = HEX;\n\nCONTENT BEGIN\n")
    address = 0
    for j in range(height - 1, 9, -1):
        for i in range(width):
            index = j * width + i
            color = pixel_index[index]
            f.write(f"{format(address, '05x')}:{format(color, '02x')};\n")
            address += 1
    f.write("END;\n")



with open("data_mlab.mif", "w") as f:
    f.write(f"WIDTH = 8;\nDEPTH = {10*width};\n\nADDRESS_RADIX = HEX;\nDATA_RADIX = HEX;\n\nCONTENT BEGIN\n")
    address = 0
    for j in range(9, -1, -1):
        for i in range(width):
            index = j * width + i
            color = pixel_index[index]
            f.write(f"{format(address, '05x')}:{format(color, '02x')};\n")
            address += 1
    f.write("END;\n")
