module POWER_MEASURE ( 
    output  reg  I2C_READY,
    input        clk_50,
    input        reset_n,

    // device i2c interface
    inout        I2C_SCL,
    inout        I2C_SDA,	
    output [15:0] SOM_VOL,   // unit: mV
    output [15:0] SOM_CUR,   // unit: mA
	 
	 	 
//----USER PORT 
    output reg [ 15:0] Configuration,
    output reg [ 15:0] Shunt_Voltage,
    output reg [ 15:0] Bus_Voltage  ,
    output reg [ 15:0] Power        ,
    output reg [ 15:0] Current      ,
	 output reg [ 15:0] Calibration  ,
	

		
	//--TEST -- 
   output reg       I2C_LO0P,
	//-
	output reg [7:0] SLAVE_ADDR , 
   output reg [7:0] ST ,
   output reg [7:0] CNT,
	output reg [7:0] WCNT,
   output reg [15:0] W_WORD_DATA,
   output reg [7:0]  W_POINTER_REG,
	
	output            W_WORD_END ,
   output reg        W_WORD_GO ,

   output     [15:0] R_DATA,
	output reg        TEMP_VALID,
	output wire       CLK_400K

);





//---- output
assign SOM_VOL= (Bus_Voltage*125)/100; // unit: mV
assign SOM_CUR=  Current;// // unit: mA

 
//----400KHZ generater-----
CLOCKMEM CLOCKMEM_inst2(   .CLK    (clk_50),.CLK_FREQ(125) ,.CK_1HZ (CLK_400K)) ;

//=======================================================
//  WIRE /REGISETER 
//=======================================================

//--I2C Main Controller--- 
reg  [31:0] DELY;

//-----I2C-BUS-I/O----
wire        SDAO;
wire        SCLO;
wire        W_WORD_SCL; 
wire        W_WORD_SDAO;  
wire        W_POINTER_SCL; 
wire        W_POINTER_END; 
reg         W_POINTER_GO;
wire        W_POINTER_SDAO; 
wire        R_SCL; 
wire        R_END; 
reg         R_GO; 
wire        R_SDAO;  


//=======================================================
//  Parameter  
//=======================================================
// I2C  W/R NUMBER 
parameter    WRITE_MAX      = 1; 
parameter    READ_MAX       = 6; 
    
//--- POWER-Monitor IC (INA231) Register ----- 
//slave address   
parameter    SLAVE_ADDR_F   = 8'h80;


parameter    P_Configuration = 8'h00 ; //This register resets all registers and
                                                 //controls shunt voltage and bus voltage,
                                                 //ADC conversion times and averaging,
                                                 //well as the device operating mode.

parameter    P_Shunt_Voltage = 8'h01;// Shunt Voltage Shunt voltage measurement data
parameter    P_Bus_Voltage   = 8'h02;// Bus voltage measurement data
parameter    P_Power         = 8'h03;// This register contains the value of the calculated power being delivered to the load.
parameter    P_Current       = 8'h04;// This register contains the value of the calculated current flowing through the shunt resistor.
parameter    P_Calibration   = 8'h05;//

//see datasheet page16					 

//-------Software-RPM Control Mode (Fan Speed Regulator)
//=======================================================
//  Structural coding
//======================================================= 
parameter    SEC    = 400_000;
parameter    SEC0d1 = SEC/10;
parameter    SEC0d5 = SEC/2;

																	 
																	 

//--I2C Main Controller--- 
reg do_config ; //<--
always @(negedge reset_n or posedge CLK_400K )begin 
if (!reset_n  ) begin 
    ST    <=0;
 	 W_POINTER_GO <=1;
    R_GO  <=1 ;		 
	 W_WORD_GO <=1;
	 WCNT <=0;  
	 CNT  <=0;
	 DELY <=0 ; 
	 TEMP_VALID <=0;
	 I2C_READY   <=0;
end 
else 
case (ST)
0: begin 
    ST           <=30;     //---First ,  to Write calibration . 
	 W_POINTER_GO <=1;
    R_GO         <=1 ;		 
	 W_WORD_GO    <=1;
	 WCNT <=0;  
	 CNT  <=0;
	 DELY <=0 ;   
   end
//------------- READ -------	
1: begin 
    if (DELY < 4000) DELY <= DELY +1 ; //10ms
	 else ST<=2;
	end	
2: begin
        // FAN READ 		  
	          if ( CNT==0)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Configuration};
	     else if ( CNT==1)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Shunt_Voltage};
	     else if ( CNT==2)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Bus_Voltage  };	 
		  else if ( CNT==3)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Power        };
		  else if ( CNT==4)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Current      };
		  else if ( CNT==5)      {SLAVE_ADDR[7:0] ,W_POINTER_REG}<= {SLAVE_ADDR_F[7:0] ,P_Calibration      };
		                
	if ( W_POINTER_END ) begin  
	   W_POINTER_GO  <=0; 
		ST<=3 ; 
		DELY<=0;  
	 end
	end                
	//------- Write Pointer
3: begin 
    DELY  <=DELY +1;
    if ( DELY ==2 ) begin 
      W_POINTER_GO  <=1;
      ST<=4 ; 
	 end
	end       
4: begin 
    if  ( W_POINTER_END ) ST<=5 ; 	
	end              
5: begin 
    ST<=6 ; 
	end 
	//------- Read DATA  		 
6: begin 
	 if ( R_END ) begin  
	  R_GO  <=0; 
	  ST<=7 ; 
	  DELY<=0; 
	 end
	end                
7: begin 
    DELY  <=DELY +1;
    if ( DELY ==2 ) begin 	 
      R_GO  <=1;
      ST<=8 ; 
	 end
	end       
8: begin 
     ST<=9 ; 
	end       
9: begin 
   if  ( R_END ) 
	 begin 		
	      //--READ  
		        if ( CNT==0) 	Configuration <=R_DATA ; 			
		   else if ( CNT==1) 	Shunt_Voltage <=R_DATA ; 
		   else if ( CNT==2) 	Bus_Voltage   <=R_DATA ; 				 	  
		   else if ( CNT==3) 	Power         <=R_DATA ;
		   else if ( CNT==4) 	Current       <=R_DATA ;
		   else if ( CNT==5) 	Calibration   <=R_DATA ;
	      CNT<=CNT+1 ;
	      ST<=10 ; 	
	 end 
  end	
  
  
10: begin   
     if ( CNT == READ_MAX) 
	   begin  
		  I2C_READY   <=1;
	     CNT  <= 0 ;   
		  ST   <= 1;
		  DELY <= 0;		  
		end
	  else begin   
	        ST<=2; 
		end 	
	     W_POINTER_GO <=1;
        R_GO         <=1 ;		 
	     W_WORD_GO    <=1; 		    		 		  
	 end 
//----  READ END ----

//----  WRITE----
30: begin 
	  ST<=31; 
    end	
31: begin 
      //TEMP 
		     if ( WCNT==0 ) begin {SLAVE_ADDR ,W_POINTER_REG ,W_WORD_DATA}   <= { SLAVE_ADDR_F ,P_Calibration ,16'h06aa };  end //Rshunt =0.003 ,0.00512/(1mA*Rshunt)
//      else if ( WCNT==1 ) begin {SLAVE_ADDR ,W_POINTER_REG ,W_WORD_DATA}   <= { SLAVE_ADDR_F ,P_CONFIG3 ,CONFIG3 };  end

		
	 if (  W_WORD_END ) begin  
	   W_WORD_GO  <=0; 
		ST   <=32 ;  
		DELY <=0;  
	 end
	end           
32: begin 
    DELY  <=DELY +1;
		if (DELY ==5 ) begin 
        W_WORD_GO  <=1;
        ST         <=33 ; 
	   end
	end       
33: begin 
    ST<=34 ; 
	end       	
34: begin 
     if  ( W_WORD_END )  begin 	
			 WCNT<=WCNT+1 ;			 
			 ST<=35 ; 
	  end
	end              
35: begin
	 if ( WCNT != WRITE_MAX )  ST<=31 ; 	  
	 else  
		begin 
	         ST       <= 37; 
	 			WCNT     <= 0;  
				CNT      <= 0; 
				DELY     <= 0;
				I2C_LO0P <= 0;
	   end 
	 end

37: begin 
		 ST <=1;
	 end  
endcase
end
//-----------------------------MAIN-ST END ------------------------------------------

//============i2c bus  ===============  
assign I2C_SDA        = (SDAO)?1'bz :0;
assign I2C_SCL        = (SCLO)?1'bz :0;
assign SDAO           = W_POINTER_SDAO & R_SDAO  & W_WORD_SDAO;
assign SCLO           = W_POINTER_SCL  & R_SCL   & W_WORD_SCL;

//==== I2C WRITE WORD ===
I2C_WRITE_P  u_I2C_WRITE_P(
   .RESET_N      ( reset_n),
	.PT_CK        ( CLK_400K),
	.GO           ( W_WORD_GO),
	.POINTER      ( W_POINTER_REG),
   .WDATA 	     ( W_WORD_DATA[15:0]),
	.SLAVE_ADDRESS( SLAVE_ADDR ),
	.SDAI         ( I2C_SDA),
	.SDAO         ( W_WORD_SDAO),
	.SCLO         ( W_WORD_SCL ),
	.END_OK       ( W_WORD_END)
);

//==== I2C WRITE POINTER ===
I2C_WRITE_POINTER_P  u_I2C_WRITE_POINTER_P(
   .RESET_N      (reset_n   ),
	.PT_CK        ( CLK_400K ),
	.GO           ( W_POINTER_GO ),
	.POINTER      ( W_POINTER_REG),
	.SLAVE_ADDRESS( SLAVE_ADDR ),
	.SDAI         ( I2C_SDA    ),
	.SDAO         ( W_POINTER_SDAO),
	.SCLO         ( W_POINTER_SCL ),
	.END_OK       ( W_POINTER_END )
);

//-----I2C TO READ---- 
I2C_READ_DATA_P u_I2C_READ_DATA_P( 
   .RESET_N      ( reset_n    ),
	.PT_CK        ( CLK_400K   ),
	.GO           ( R_GO       ),
	.SLAVE_ADDRESS( SLAVE_ADDR ),
 	.BYTE_NUM     ( 1          ) , // I2C read 16 bit data 
	.SDAI         ( I2C_SDA),
	.SDAO         ( R_SDAO ),
	.SCLO         ( R_SCL  ),
	.END_OK       ( R_END  ),
	.DATA         ( R_DATA )
);
	
endmodule
	