// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 13469 16735 16788 

module altera_avalon_jtag_uart_log_module #(
  parameter FIFO_WIDTH = 8
  ) (
  // inputs:
   clk,
   data,
   strobe,
   valid
    )
;

  input                     clk;
  input   [FIFO_WIDTH-1: 0] data;
  input                     strobe;
  input                     valid;



//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
   reg [31:0] text_handle; // for $fopen
   initial text_handle = $fopen ("altera_avalon_jtag_uart_output_stream.dat");

   always @(posedge clk) begin
      if (valid && strobe) begin
	 // Send \n (linefeed) instead of \r (^M, Carriage Return)...
         $fwrite (text_handle, "%s", ((data == 8'hd) ? 8'ha : data));
	 // non-standard; poorly documented; required to get real data stream.
	 $fflush (text_handle);
      end
   end // clk


//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "E3DP+rueYwfrR4ojrl2OEjoJywhJaMW5WlgJtfj+5tptZjiuuDLF2iraNpnJOGT+3UOTXHF3UAz83vkYsSmcHTnnSZIpHI/qX5arWGTSH8pr1Uho9XbGObyxEZWSi9ZOz9MM8xDd9UZuSs2brkq5JmWs4MfEAFN2VJTXOmHvaT0rg5dUCJSrEmgsSJAON0LpCuXp9A8QjW9/QkTlZz0xqCp4ug0+/CORmw+kYKIX7Trj9l5k3WnU0MN5Zfn9WbzK9DFiEVFL+TVhku2eWx5JMzSeoEdG9O5iSX/IQjfGhyy88n7S2yNhzrsFN8zOYMMrAfTDi4MOGJ1ayc8NA/5kATNGcmPn7DaO6qd+vQWd0t53CM7ETe7znafJUpRu8Qw1fEAdtS4UiWZ0rfWE3CUBn17Ds3E2DXc9u5H7ABNRO3s6lRPXAB7C/6jt89AfcYRlow0YoNSxHjVir00ujMKcVKJFP7NAtHiCtMuu9CI9E4HqL40/kogYnRDVMhHDw2nd1Abe8OeHOLyoa/lL678GmRjCa0zzWUCUgA0+KldPCwbyolsbSWBSY7KWrg8G2F7sRuqah0ON9c0w+WzDxfYJYFLcYvTUWtx/GlCs3KIumdFtDcwAACkFlkZbLNhzYi8XNoGcIxdVsrSu45HC2WFwKBBw0lXaERiPv6NbD7QL29PwNDl8mxHTlsOmgaAzB/8V9GV0/K/2rVG6wWGo25e53usl762HbC9EmcwSB1MnwuXdb3p/fq7T3ShNC/Y2d9ezRzXzAEivRp3/iYqqSsBDBsSnALVDLnBt/kHdPO9eld3Vk8zJgxk9jPxpV0VIa/Wbr5BdK0RMPc0uzSnWJDEET8l4mIWEp/K0eSK9o9raGExzPxNLyxW3ecOUkaUXe4y5Qjtwfsi24QFtmaIEx2Knuc5R9Qtur4QgHEacu/zBEw27YE85ttHMaMi+sfOJF9XeADwLVf+1vLAsSwxTRBLlljhzAF3mi8nzjVbAF6YAfH5mzgViNlK/47VzLYL049YC"
`endif