// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/25.3.1/ip/iconnect/pd_components/altera_std_synchronizer/altera_std_synchronizer_bundle.v#1 $
// $Revision: #1 $
// $Date: 2025/10/16 $
//----------------------------------------------------------------
//
// File: altera_std_synchronizer_bundle.v
//
// Abstract: Bundle of bit synchronizers. 
//           WARNING: only use this to synchronize a bundle of 
//           *independent* single bit signals or a Gray encoded 
//           bus of signals. Also remember that pulses entering 
//           the synchronizer will be swallowed upon a metastable
//           condition if the pulse width is shorter than twice
//           the synchronizing clock period.
//
// Copyright (C) Altera Corporation 2008, All Rights Reserved
//----------------------------------------------------------------

module altera_std_synchronizer_bundle(
				     clk,
				     reset_n,
				     din,
				     dout
				     );
   parameter width = 1;
   parameter depth = 3;   
   
   input clk;
   input reset_n;
   input [width-1:0] din;
   output [width-1:0] dout;
   
   generate
      genvar i;
      for (i=0; i<width; i=i+1)
	begin : sync
	   altera_std_synchronizer #(.depth(depth))
                                   u (
				      .clk(clk), 
				      .reset_n(reset_n), 
				      .din(din[i]), 
				      .dout(dout[i])
				      );
	end
   endgenerate
   
endmodule 

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "XueRlU49FXh5YUVjzbaPhu81LPyb0GMjXivAT68DWnczB515rL83gLWIqbzHFME9Pi0A2YH7WI+K3ey6O2AVz3GlOxacuOHwqo3DSfLDZi/zitW80zJMi43q2q5N0K5/w++i1zzdsqZFkBU2EZ5PujM/XenU55WZ24Z/ryJ79gmJczCtLgP8xRKVvQPD1oHGSvApdCwEBmjcBAHmEJeGV7vI5GS9O8QXn7amAdWMzRHVsH18YmWAgJeS7xgnvnBWonfLaKb6H4+gzIFSW0lLJE4Jq1Ds5+yvhC7ZMTNTr51mszEUsYzZnOLFUNRGa0srN4AmpnDwCsCcbVc8eAVUODMGdULYzksQJrq377N0bR6phwbDPnBopIxUmY2EB8IdK66jqYuqK6SXQsBEhBnHEj2bq1HVU0Tem0oZzFcEYWZmpviiCqHHBsuFHekSkENutGL5E4bMkPh+1NkVJHfEfNNYTn/W+JXku267eiZrgJXi4+RdlR0cQicfu5FHIjOED3a2bEaOC+s81R8dV23jaoRaBwEwAturfTIJplZcnsqk51tKz5jgNAzter3KXQklzvytO7czPj8kDLkFjA5pLvhY2tUnQi2ssnnbo4iHxE4oAg2y6KTDKOshZdyaNpKnHWyxaiT8HSXWRzw+Z1aRaRm1xt3pP5NBC22iYH0q6hTr8uzHOWK14bU1cewFPnlIn3+3E+sxk4ZO20QtoL53HReyPvM/QSiAtyqAIjyRgxFxHwOfOpvCAedmMbjtCU2hmEgI+klsNgV9Mi+2+fKPRpXuFF/4Wui9vTA0LIz/Bv94Y+RaY+6+TugmbUboH7hyq6wLI3udz2GdpIjKEoLswqPV0/qD5+JY5a9IS8UmgZ8mB85Pvkc6KUdG+kGz3KnwLs3i5lUjeME51clEYlF3T7Yk2bKuvvM7luTDwXDYIw79FoXZ/wRI02V8o5buSNftfDO+nTLkWVb1QO3DZnxEI9Tum3liqHjhDuWl2McKJMeVRZYVZ6Gsa4KlnLguv3CW"
`endif