// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue Oct 21 15:55:14 2025
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_HPS
//`define ENABLE_CAM
//`define ENABLE_HDMI

module golden_top(

      ///////// CLOCK /////////
//      input              CLK_100_B2A_p,
      input              CLK_100_p,
      input              CLK_50_B5A,
//      input              CLK_50_B6A,
//      input              CLK_50_B6C,
//      input              CLK_50_B6F,
//      input              CLK_50_B6H,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active

      ///////// Switches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output   [ 1: 0]   LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output   [ 1: 0]   LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 1: 0]   LPDDR4B_DM,
      inout    [15: 0]   LPDDR4B_DQ,
      inout    [ 1: 0]   LPDDR4B_DQS,
      inout    [ 1: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_HDMI
      ///////// HDMI /////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      input              HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,
`endif /*ENABLE_HDMI*/

`ifdef ENABLE_CAM
      ///////// CAM /////////
      input              CAM_CLK_p,
      input              CAM_CLK_n,
      input    [ 3: 0]   CAM_D_p,
      input    [ 3: 0]   CAM_D_n,
      inout              CAM_I2C_SCL,
      inout              CAM_I2C_SDA,
      inout              CAM_GPIO,
      input              CAM_RZQ0,
`endif /*ENABLE_CAM*/

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout              HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout    [ 1: 0]   HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p,
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n,
`endif /*ENABLE_HPS*/

      ///////// I2Cs /////////
      inout              FAN_I2C_SCL,
      inout              FAN_I2C_SDA,
      input              FAN_ALERT_n,

      ///////// PM /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D
);


//=======================================================
//  REG/WIRE declarations
//=======================================================

wire reset_n;

wire GTSL1A_REFCLK_100M_p_clk;
wire gts_pll_lock_status;

//System Monitor IP
//IP interface
wire signed [15:0] FPGA_Temperature;    // unit: C
wire signed [15:0] Board_Temperature;   // unit: C
wire        [15:0] Fan_Speed;           // unit: RPM
wire               Auto_Fan_Speed;      // 1: enable auto speed control. 0: user specify fan speed
wire        [15:0] Set_Fan_Speed;       // used when Auto_Fan_Speed is low
wire               AMC6821_I2C_READY;   // 1: I2C BUS ready, 0: I2C BUS not ready

//--input power
wire        [15:0] SOM_VOL;             // unit: mV
wire        [15:0] SOM_CUR;             // unit: mA
wire               INA231_I2C_READY;    // 1: I2C BUS ready, 0: I2C BUS not ready

//User IO
wire               pio_led;
wire        [31:0] pio_fan_in;
wire        [31:0] pio_fan_out;

assign USER_LED = ~pio_led;
assign pio_fan_in = {15'b0, AMC6821_I2C_READY, Fan_Speed};
// pio_fan_out reset default value in Qsys: 0x0001251c
// - Bit[16] = 1: Enable auto speed control
// - Bit[15:0] = 0x251c (9500): Default fan speed = 9500 RPM
assign {Auto_Fan_Speed, Set_Fan_Speed} = pio_fan_out[16:0];



//=======================================================
//  Structural coding
//=======================================================

wire ninit_done;
agilex_reset_release agilex_reset_release_Inst (
    .ninit_done(ninit_done)  //  output,  width = 1, ninit_done.ninit_done
);
assign reset_n = ~ninit_done;

Qsys Qsys_Inst (
    .clk_clk                                               (CLK_50_B5A),                //   input,   width = 1,                                            clk.clk
    .reset_reset_n                                         (!ninit_done),               //   input,   width = 1,                                          reset.reset_n

    .pio_button_export                                     (~USER_BUTTON),              //   input,   width = 1,                                     pio_button.export
    .pio_led_export                                        (pio_led),                   //  output,   width = 1,                                        pio_led.export
    .pio_sw_export                                         ({SD_MMC_SEL,USER_SW}),      //   input,   width = 3,                                         pio_sw.export
    .pio_fan_in_port                                       (pio_fan_in),                //   input,  width = 32,                                        pio_fan.in_port
    .pio_fan_out_port                                      (pio_fan_out),               //  output,  width = 32,                                               .out_port
    .fpga_temperature_export                               (FPGA_Temperature),          //   input,  width = 16,                               fpga_temperature.export
    .board_temperature_export                              (Board_Temperature),         //   input,  width = 16,                              board_temperature.export
    .power_voltage_export                                  (SOM_VOL),                   //   input,  width = 16,                                  power_voltage.export
    .power_current_export                                  (SOM_CUR)                    //   input,  width = 16,                                  power_current.export

);

// INA231AIYFFT (in carrier board) monitor input SOM V/I
POWER_MEASURE u_POWER_MEASURE (
    .clk_50 (CLK_50_B5A),
    .reset_n(reset_n),

    // device i2c interface
    .I2C_SCL  (PM_I2C_SCL),
    .I2C_SDA  (PM_I2C_SDA),
    .I2C_READY(INA231_I2C_READY),

    // board info and control
    .SOM_VOL(SOM_VOL),  // unit: mV
    .SOM_CUR(SOM_CUR)   // unit: mA

);

// AMC6821
BOARD_MANAGEMENT u_BOARD_MANAGEMENT (
    .clk_50 (CLK_50_B5A),
    .reset_n(reset_n & USER_BUTTON),

    // device i2c interface
    .I2C_SCL  (FAN_I2C_SCL),
    .I2C_SDA  (FAN_I2C_SDA),
    .I2C_READY(AMC6821_I2C_READY),

    // temperature monitor
    .FPGA_Temperature (FPGA_Temperature),   // unit: C
    .Board_Temperature(Board_Temperature),  // unit: C

    // fan control and monitor
    .Fan_Speed        (Fan_Speed)           // unit: RPM
    // fan speed control disabled for revA
    //.Auto_Fan_Speed(Auto_Fan_Speed),        // 1: enable auto speed control. 0: user specify fan speed
    //.Set_Fan_Speed (Set_Fan_Speed)          // used when Auto_Fan_Speed is low
);


endmodule
