// Qsys.v

// Generated using ACDS version 25.3.1 100

`timescale 1 ps / 1 ps
module Qsys (
		input  wire [15:0] board_temperature_export, // board_temperature.export
		input  wire        clk_clk,                  //               clk.clk
		input  wire [15:0] fpga_temperature_export,  //  fpga_temperature.export
		input  wire        pio_button_export,        //        pio_button.export
		output wire        pio_led_export,           //           pio_led.export
		input  wire [31:0] pio_fan_in_port,          //           pio_fan.in_port
		output wire [31:0] pio_fan_out_port,         //                  .out_port
		input  wire [15:0] power_current_export,     //     power_current.export
		input  wire [15:0] power_voltage_export,     //     power_voltage.export
		input  wire        reset_reset_n,            //             reset.reset_n
		input  wire [2:0]  pio_sw_export             //            pio_sw.export
	);

	wire         clock_in_out_clk_clk;                                         // clock_in:out_clk -> [board_temperature:clk, fpga_temperature:clk, intel_niosv_m:clk, intel_onchip_memory:clk, irq_mapper:clk, jtag_uart:clk, key:clk, led:clk, mm_interconnect_0:clock_in_out_clk_clk, pio_fan:clk, power_current:clk, power_voltage:clk, reset_controller_clock_in:clk, rst_controller:clk, rst_controller_001:clk, sw:clk, sysid_qsys:clock]
	wire         reset_in_out_reset_reset;                                     // reset_in:out_reset_n -> reset_controller_clock_in:reset_in0
	wire  [31:0] intel_niosv_m_data_manager_awaddr;                            // intel_niosv_m:data_manager_awaddr -> mm_interconnect_0:intel_niosv_m_data_manager_awaddr
	wire   [1:0] intel_niosv_m_data_manager_bresp;                             // mm_interconnect_0:intel_niosv_m_data_manager_bresp -> intel_niosv_m:data_manager_bresp
	wire         intel_niosv_m_data_manager_arready;                           // mm_interconnect_0:intel_niosv_m_data_manager_arready -> intel_niosv_m:data_manager_arready
	wire  [31:0] intel_niosv_m_data_manager_rdata;                             // mm_interconnect_0:intel_niosv_m_data_manager_rdata -> intel_niosv_m:data_manager_rdata
	wire   [3:0] intel_niosv_m_data_manager_wstrb;                             // intel_niosv_m:data_manager_wstrb -> mm_interconnect_0:intel_niosv_m_data_manager_wstrb
	wire         intel_niosv_m_data_manager_wready;                            // mm_interconnect_0:intel_niosv_m_data_manager_wready -> intel_niosv_m:data_manager_wready
	wire         intel_niosv_m_data_manager_awready;                           // mm_interconnect_0:intel_niosv_m_data_manager_awready -> intel_niosv_m:data_manager_awready
	wire         intel_niosv_m_data_manager_rready;                            // intel_niosv_m:data_manager_rready -> mm_interconnect_0:intel_niosv_m_data_manager_rready
	wire         intel_niosv_m_data_manager_bready;                            // intel_niosv_m:data_manager_bready -> mm_interconnect_0:intel_niosv_m_data_manager_bready
	wire         intel_niosv_m_data_manager_wvalid;                            // intel_niosv_m:data_manager_wvalid -> mm_interconnect_0:intel_niosv_m_data_manager_wvalid
	wire  [31:0] intel_niosv_m_data_manager_araddr;                            // intel_niosv_m:data_manager_araddr -> mm_interconnect_0:intel_niosv_m_data_manager_araddr
	wire   [2:0] intel_niosv_m_data_manager_arprot;                            // intel_niosv_m:data_manager_arprot -> mm_interconnect_0:intel_niosv_m_data_manager_arprot
	wire   [1:0] intel_niosv_m_data_manager_rresp;                             // mm_interconnect_0:intel_niosv_m_data_manager_rresp -> intel_niosv_m:data_manager_rresp
	wire   [2:0] intel_niosv_m_data_manager_awprot;                            // intel_niosv_m:data_manager_awprot -> mm_interconnect_0:intel_niosv_m_data_manager_awprot
	wire  [31:0] intel_niosv_m_data_manager_wdata;                             // intel_niosv_m:data_manager_wdata -> mm_interconnect_0:intel_niosv_m_data_manager_wdata
	wire         intel_niosv_m_data_manager_arvalid;                           // intel_niosv_m:data_manager_arvalid -> mm_interconnect_0:intel_niosv_m_data_manager_arvalid
	wire         intel_niosv_m_data_manager_bvalid;                            // mm_interconnect_0:intel_niosv_m_data_manager_bvalid -> intel_niosv_m:data_manager_bvalid
	wire         intel_niosv_m_data_manager_awvalid;                           // intel_niosv_m:data_manager_awvalid -> mm_interconnect_0:intel_niosv_m_data_manager_awvalid
	wire         intel_niosv_m_data_manager_rvalid;                            // mm_interconnect_0:intel_niosv_m_data_manager_rvalid -> intel_niosv_m:data_manager_rvalid
	wire  [31:0] intel_niosv_m_instruction_manager_awaddr;                     // intel_niosv_m:instruction_manager_awaddr -> mm_interconnect_0:intel_niosv_m_instruction_manager_awaddr
	wire   [1:0] intel_niosv_m_instruction_manager_bresp;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_bresp -> intel_niosv_m:instruction_manager_bresp
	wire         intel_niosv_m_instruction_manager_arready;                    // mm_interconnect_0:intel_niosv_m_instruction_manager_arready -> intel_niosv_m:instruction_manager_arready
	wire  [31:0] intel_niosv_m_instruction_manager_rdata;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_rdata -> intel_niosv_m:instruction_manager_rdata
	wire   [3:0] intel_niosv_m_instruction_manager_wstrb;                      // intel_niosv_m:instruction_manager_wstrb -> mm_interconnect_0:intel_niosv_m_instruction_manager_wstrb
	wire         intel_niosv_m_instruction_manager_wready;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_wready -> intel_niosv_m:instruction_manager_wready
	wire         intel_niosv_m_instruction_manager_awready;                    // mm_interconnect_0:intel_niosv_m_instruction_manager_awready -> intel_niosv_m:instruction_manager_awready
	wire         intel_niosv_m_instruction_manager_rready;                     // intel_niosv_m:instruction_manager_rready -> mm_interconnect_0:intel_niosv_m_instruction_manager_rready
	wire         intel_niosv_m_instruction_manager_bready;                     // intel_niosv_m:instruction_manager_bready -> mm_interconnect_0:intel_niosv_m_instruction_manager_bready
	wire         intel_niosv_m_instruction_manager_wvalid;                     // intel_niosv_m:instruction_manager_wvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_wvalid
	wire  [31:0] intel_niosv_m_instruction_manager_araddr;                     // intel_niosv_m:instruction_manager_araddr -> mm_interconnect_0:intel_niosv_m_instruction_manager_araddr
	wire   [2:0] intel_niosv_m_instruction_manager_arprot;                     // intel_niosv_m:instruction_manager_arprot -> mm_interconnect_0:intel_niosv_m_instruction_manager_arprot
	wire   [1:0] intel_niosv_m_instruction_manager_rresp;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_rresp -> intel_niosv_m:instruction_manager_rresp
	wire   [2:0] intel_niosv_m_instruction_manager_awprot;                     // intel_niosv_m:instruction_manager_awprot -> mm_interconnect_0:intel_niosv_m_instruction_manager_awprot
	wire  [31:0] intel_niosv_m_instruction_manager_wdata;                      // intel_niosv_m:instruction_manager_wdata -> mm_interconnect_0:intel_niosv_m_instruction_manager_wdata
	wire         intel_niosv_m_instruction_manager_arvalid;                    // intel_niosv_m:instruction_manager_arvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_arvalid
	wire         intel_niosv_m_instruction_manager_bvalid;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_bvalid -> intel_niosv_m:instruction_manager_bvalid
	wire         intel_niosv_m_instruction_manager_awvalid;                    // intel_niosv_m:instruction_manager_awvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_awvalid
	wire         intel_niosv_m_instruction_manager_rvalid;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_rvalid -> intel_niosv_m:instruction_manager_rvalid
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;     // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;       // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest;    // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;        // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;           // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;          // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;      // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_sysid_qsys_control_slave_readdata;          // sysid_qsys:readdata -> mm_interconnect_0:sysid_qsys_control_slave_readdata
	wire   [0:0] mm_interconnect_0_sysid_qsys_control_slave_address;           // mm_interconnect_0:sysid_qsys_control_slave_address -> sysid_qsys:address
	wire  [31:0] mm_interconnect_0_intel_niosv_m_dm_agent_readdata;            // intel_niosv_m:dm_agent_readdata -> mm_interconnect_0:intel_niosv_m_dm_agent_readdata
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest;         // intel_niosv_m:dm_agent_waitrequest -> mm_interconnect_0:intel_niosv_m_dm_agent_waitrequest
	wire  [15:0] mm_interconnect_0_intel_niosv_m_dm_agent_address;             // mm_interconnect_0:intel_niosv_m_dm_agent_address -> intel_niosv_m:dm_agent_address
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_read;                // mm_interconnect_0:intel_niosv_m_dm_agent_read -> intel_niosv_m:dm_agent_read
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid;       // intel_niosv_m:dm_agent_readdatavalid -> mm_interconnect_0:intel_niosv_m_dm_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_write;               // mm_interconnect_0:intel_niosv_m_dm_agent_write -> intel_niosv_m:dm_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_m_dm_agent_writedata;           // mm_interconnect_0:intel_niosv_m_dm_agent_writedata -> intel_niosv_m:dm_agent_writedata
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_readdata;            // intel_onchip_memory:readdata -> mm_interconnect_0:intel_onchip_memory_s1_readdata
	wire  [16:0] mm_interconnect_0_intel_onchip_memory_s1_address;             // mm_interconnect_0:intel_onchip_memory_s1_address -> intel_onchip_memory:address
	wire         mm_interconnect_0_intel_onchip_memory_s1_read;                // mm_interconnect_0:intel_onchip_memory_s1_read -> intel_onchip_memory:read
	wire   [3:0] mm_interconnect_0_intel_onchip_memory_s1_byteenable;          // mm_interconnect_0:intel_onchip_memory_s1_byteenable -> intel_onchip_memory:byteenable
	wire         mm_interconnect_0_intel_onchip_memory_s1_write;               // mm_interconnect_0:intel_onchip_memory_s1_write -> intel_onchip_memory:write
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_writedata;           // mm_interconnect_0:intel_onchip_memory_s1_writedata -> intel_onchip_memory:writedata
	wire         mm_interconnect_0_sw_s1_chipselect;                           // mm_interconnect_0:sw_s1_chipselect -> sw:chipselect
	wire  [31:0] mm_interconnect_0_sw_s1_readdata;                             // sw:readdata -> mm_interconnect_0:sw_s1_readdata
	wire   [1:0] mm_interconnect_0_sw_s1_address;                              // mm_interconnect_0:sw_s1_address -> sw:address
	wire         mm_interconnect_0_sw_s1_write;                                // mm_interconnect_0:sw_s1_write -> sw:write_n
	wire  [31:0] mm_interconnect_0_sw_s1_writedata;                            // mm_interconnect_0:sw_s1_writedata -> sw:writedata
	wire         mm_interconnect_0_key_s1_chipselect;                          // mm_interconnect_0:key_s1_chipselect -> key:chipselect
	wire  [31:0] mm_interconnect_0_key_s1_readdata;                            // key:readdata -> mm_interconnect_0:key_s1_readdata
	wire   [1:0] mm_interconnect_0_key_s1_address;                             // mm_interconnect_0:key_s1_address -> key:address
	wire         mm_interconnect_0_key_s1_write;                               // mm_interconnect_0:key_s1_write -> key:write_n
	wire  [31:0] mm_interconnect_0_key_s1_writedata;                           // mm_interconnect_0:key_s1_writedata -> key:writedata
	wire         mm_interconnect_0_led_s1_chipselect;                          // mm_interconnect_0:led_s1_chipselect -> led:chipselect
	wire  [31:0] mm_interconnect_0_led_s1_readdata;                            // led:readdata -> mm_interconnect_0:led_s1_readdata
	wire   [1:0] mm_interconnect_0_led_s1_address;                             // mm_interconnect_0:led_s1_address -> led:address
	wire         mm_interconnect_0_led_s1_write;                               // mm_interconnect_0:led_s1_write -> led:write_n
	wire  [31:0] mm_interconnect_0_led_s1_writedata;                           // mm_interconnect_0:led_s1_writedata -> led:writedata
	wire         mm_interconnect_0_pio_fan_s1_chipselect;                      // mm_interconnect_0:pio_fan_s1_chipselect -> pio_fan:chipselect
	wire  [31:0] mm_interconnect_0_pio_fan_s1_readdata;                        // pio_fan:readdata -> mm_interconnect_0:pio_fan_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_fan_s1_address;                         // mm_interconnect_0:pio_fan_s1_address -> pio_fan:address
	wire         mm_interconnect_0_pio_fan_s1_write;                           // mm_interconnect_0:pio_fan_s1_write -> pio_fan:write_n
	wire  [31:0] mm_interconnect_0_pio_fan_s1_writedata;                       // mm_interconnect_0:pio_fan_s1_writedata -> pio_fan:writedata
	wire  [31:0] mm_interconnect_0_fpga_temperature_s1_readdata;               // fpga_temperature:readdata -> mm_interconnect_0:fpga_temperature_s1_readdata
	wire   [1:0] mm_interconnect_0_fpga_temperature_s1_address;                // mm_interconnect_0:fpga_temperature_s1_address -> fpga_temperature:address
	wire  [31:0] mm_interconnect_0_board_temperature_s1_readdata;              // board_temperature:readdata -> mm_interconnect_0:board_temperature_s1_readdata
	wire   [1:0] mm_interconnect_0_board_temperature_s1_address;               // mm_interconnect_0:board_temperature_s1_address -> board_temperature:address
	wire  [31:0] mm_interconnect_0_power_voltage_s1_readdata;                  // power_voltage:readdata -> mm_interconnect_0:power_voltage_s1_readdata
	wire   [1:0] mm_interconnect_0_power_voltage_s1_address;                   // mm_interconnect_0:power_voltage_s1_address -> power_voltage:address
	wire  [31:0] mm_interconnect_0_power_current_s1_readdata;                  // power_current:readdata -> mm_interconnect_0:power_current_s1_readdata
	wire   [1:0] mm_interconnect_0_power_current_s1_address;                   // mm_interconnect_0:power_current_s1_address -> power_current:address
	wire  [31:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata;      // intel_niosv_m:timer_sw_agent_readdata -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_readdata
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest;   // intel_niosv_m:timer_sw_agent_waitrequest -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_waitrequest
	wire   [5:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_address;       // mm_interconnect_0:intel_niosv_m_timer_sw_agent_address -> intel_niosv_m:timer_sw_agent_address
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_read;          // mm_interconnect_0:intel_niosv_m_timer_sw_agent_read -> intel_niosv_m:timer_sw_agent_read
	wire   [3:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable;    // mm_interconnect_0:intel_niosv_m_timer_sw_agent_byteenable -> intel_niosv_m:timer_sw_agent_byteenable
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid; // intel_niosv_m:timer_sw_agent_readdatavalid -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_write;         // mm_interconnect_0:intel_niosv_m_timer_sw_agent_write -> intel_niosv_m:timer_sw_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata;     // mm_interconnect_0:intel_niosv_m_timer_sw_agent_writedata -> intel_niosv_m:timer_sw_agent_writedata
	wire         irq_mapper_receiver0_irq;                                     // jtag_uart:av_irq -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                     // key:irq -> irq_mapper:receiver1_irq
	wire         irq_mapper_receiver2_irq;                                     // sw:irq -> irq_mapper:receiver2_irq
	wire  [15:0] intel_niosv_m_platform_irq_rx_irq;                            // irq_mapper:sender_irq -> intel_niosv_m:platform_irq_rx_irq
	wire         rst_controller_reset_out_reset;                               // rst_controller:reset_out -> [board_temperature:reset_n, fpga_temperature:reset_n, intel_niosv_m:reset_reset, intel_onchip_memory:reset, irq_mapper:reset, jtag_uart:rst_n, key:reset_n, led:reset_n, pio_fan:reset_n, power_current:reset_n, power_voltage:reset_n, rst_translator:in_reset, sw:reset_n, sysid_qsys:reset_n]
	wire         rst_controller_reset_out_reset_req;                           // rst_controller:reset_req -> [intel_onchip_memory:reset_req, rst_translator:reset_req_in]
	wire         reset_controller_clock_in_reset_out_reset;                    // reset_controller_clock_in:reset_out -> [rst_controller:reset_in0, rst_controller_001:reset_in0]
	wire         rst_controller_001_reset_out_reset;                           // rst_controller_001:reset_out -> [mm_interconnect_0:intel_niosv_m_data_manager_translator_clk_reset_reset_bridge_in_reset_reset, mm_interconnect_0:intel_niosv_m_reset_reset_bridge_in_reset_reset]

	pio_board_info board_temperature (
		.clk      (clock_in_out_clk_clk),                            //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                 //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_temperature_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_temperature_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_temperature_export)                         //   input,  width = 16, external_connection.export
	);

	Qsys_clock_in clock_in (
		.in_clk  (clk_clk),              //   input,  width = 1,  in_clk.clk
		.out_clk (clock_in_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	pio_board_info fpga_temperature (
		.clk      (clock_in_out_clk_clk),                           //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_fpga_temperature_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_fpga_temperature_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (fpga_temperature_export)                         //   input,  width = 16, external_connection.export
	);

	Qsys_intel_niosv_m_0 intel_niosv_m (
		.clk                          (clock_in_out_clk_clk),                                         //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_reset_out_reset),                               //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (intel_niosv_m_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awaddr   (intel_niosv_m_instruction_manager_awaddr),                     //  output,  width = 32, instruction_manager.awaddr
		.instruction_manager_awprot   (intel_niosv_m_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (intel_niosv_m_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awready  (intel_niosv_m_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (intel_niosv_m_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (intel_niosv_m_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wvalid   (intel_niosv_m_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (intel_niosv_m_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (intel_niosv_m_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (intel_niosv_m_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (intel_niosv_m_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (intel_niosv_m_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arprot   (intel_niosv_m_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (intel_niosv_m_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arready  (intel_niosv_m_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (intel_niosv_m_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (intel_niosv_m_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rvalid   (intel_niosv_m_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (intel_niosv_m_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.data_manager_awaddr          (intel_niosv_m_data_manager_awaddr),                            //  output,  width = 32,        data_manager.awaddr
		.data_manager_awprot          (intel_niosv_m_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (intel_niosv_m_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (intel_niosv_m_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (intel_niosv_m_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (intel_niosv_m_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wvalid          (intel_niosv_m_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (intel_niosv_m_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (intel_niosv_m_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (intel_niosv_m_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (intel_niosv_m_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (intel_niosv_m_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arprot          (intel_niosv_m_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (intel_niosv_m_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (intel_niosv_m_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (intel_niosv_m_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (intel_niosv_m_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rvalid          (intel_niosv_m_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rready          (intel_niosv_m_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_address       (mm_interconnect_0_intel_niosv_m_timer_sw_agent_address),       //   input,   width = 6,      timer_sw_agent.address
		.timer_sw_agent_byteenable    (mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_read          (mm_interconnect_0_intel_niosv_m_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_write         (mm_interconnect_0_intel_niosv_m_timer_sw_agent_write),         //   input,   width = 1,                    .write
		.timer_sw_agent_writedata     (mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_waitrequest   (mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.timer_sw_agent_readdatavalid (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.dm_agent_address             (mm_interconnect_0_intel_niosv_m_dm_agent_address),             //   input,  width = 16,            dm_agent.address
		.dm_agent_read                (mm_interconnect_0_intel_niosv_m_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_intel_niosv_m_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_write               (mm_interconnect_0_intel_niosv_m_dm_agent_write),               //   input,   width = 1,                    .write
		.dm_agent_writedata           (mm_interconnect_0_intel_niosv_m_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_waitrequest         (mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dm_agent_readdatavalid       (mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid)        //  output,   width = 1,                    .readdatavalid
	);

	Qsys_intel_onchip_memory_0 intel_onchip_memory (
		.clk        (clock_in_out_clk_clk),                                //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_intel_onchip_memory_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_intel_onchip_memory_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_intel_onchip_memory_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_intel_onchip_memory_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_intel_onchip_memory_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_intel_onchip_memory_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_reset_out_reset),                      //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req)                   //   input,   width = 1,       .reset_req
	);

	Qsys_jtag_uart_0 jtag_uart (
		.clk            (clock_in_out_clk_clk),                                      //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver0_irq)                                   //  output,   width = 1,               irq.irq
	);

	pio_button key (
		.clk        (clock_in_out_clk_clk),                //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_key_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_key_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_key_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_key_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_key_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (pio_button_export),                   //   input,   width = 1, external_connection.export
		.irq        (irq_mapper_receiver1_irq)             //  output,   width = 1,                 irq.irq
	);

	pio_led led (
		.clk        (clock_in_out_clk_clk),                //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_led_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_led_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_led_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_led_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_led_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_led_export)                       //  output,   width = 1, external_connection.export
	);

	pio_fan pio_fan (
		.clk        (clock_in_out_clk_clk),                    //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),         //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_fan_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_fan_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_fan_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_fan_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_fan_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (pio_fan_in_port),                         //   input,  width = 32, external_connection.in_port
		.out_port   (pio_fan_out_port)                         //  output,  width = 32,                    .out_port
	);

	pio_board_info power_current (
		.clk      (clock_in_out_clk_clk),                        //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_power_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_power_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (power_current_export)                         //   input,  width = 16, external_connection.export
	);

	pio_board_info power_voltage (
		.clk      (clock_in_out_clk_clk),                        //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),             //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_power_voltage_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_power_voltage_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (power_voltage_export)                         //   input,  width = 16, external_connection.export
	);

	reset_controller reset_controller_clock_in (
		.reset_in0 (~reset_in_out_reset_reset),                 //   input,  width = 1, reset_in0.reset
		.clk       (clock_in_out_clk_clk),                      //   input,  width = 1,       clk.clk
		.reset_out (reset_controller_clock_in_reset_out_reset)  //  output,  width = 1, reset_out.reset
	);

	Qsys_reset_in reset_in (
		.in_reset_n  (reset_reset_n),            //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_in_out_reset_reset)  //  output,  width = 1, out_reset.reset_n
	);

	pio_sw sw (
		.clk        (clock_in_out_clk_clk),               //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),    //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_sw_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_sw_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_sw_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_sw_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_sw_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (pio_sw_export),                      //   input,   width = 3, external_connection.export
		.irq        (irq_mapper_receiver2_irq)            //  output,   width = 1,                 irq.irq
	);

	Qsys_sysid_qsys_0 sysid_qsys (
		.clock    (clock_in_out_clk_clk),                                //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_0_sysid_qsys_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_0_sysid_qsys_control_slave_address)   //   input,   width = 1,              .address
	);

	Qsys_altera_mm_interconnect_1920_qaqzt6q mm_interconnect_0 (
		.intel_niosv_m_data_manager_awaddr                                           (intel_niosv_m_data_manager_awaddr),                            //   input,  width = 32,                                            intel_niosv_m_data_manager.awaddr
		.intel_niosv_m_data_manager_awprot                                           (intel_niosv_m_data_manager_awprot),                            //   input,   width = 3,                                                                      .awprot
		.intel_niosv_m_data_manager_awvalid                                          (intel_niosv_m_data_manager_awvalid),                           //   input,   width = 1,                                                                      .awvalid
		.intel_niosv_m_data_manager_awready                                          (intel_niosv_m_data_manager_awready),                           //  output,   width = 1,                                                                      .awready
		.intel_niosv_m_data_manager_wdata                                            (intel_niosv_m_data_manager_wdata),                             //   input,  width = 32,                                                                      .wdata
		.intel_niosv_m_data_manager_wstrb                                            (intel_niosv_m_data_manager_wstrb),                             //   input,   width = 4,                                                                      .wstrb
		.intel_niosv_m_data_manager_wvalid                                           (intel_niosv_m_data_manager_wvalid),                            //   input,   width = 1,                                                                      .wvalid
		.intel_niosv_m_data_manager_wready                                           (intel_niosv_m_data_manager_wready),                            //  output,   width = 1,                                                                      .wready
		.intel_niosv_m_data_manager_bresp                                            (intel_niosv_m_data_manager_bresp),                             //  output,   width = 2,                                                                      .bresp
		.intel_niosv_m_data_manager_bvalid                                           (intel_niosv_m_data_manager_bvalid),                            //  output,   width = 1,                                                                      .bvalid
		.intel_niosv_m_data_manager_bready                                           (intel_niosv_m_data_manager_bready),                            //   input,   width = 1,                                                                      .bready
		.intel_niosv_m_data_manager_araddr                                           (intel_niosv_m_data_manager_araddr),                            //   input,  width = 32,                                                                      .araddr
		.intel_niosv_m_data_manager_arprot                                           (intel_niosv_m_data_manager_arprot),                            //   input,   width = 3,                                                                      .arprot
		.intel_niosv_m_data_manager_arvalid                                          (intel_niosv_m_data_manager_arvalid),                           //   input,   width = 1,                                                                      .arvalid
		.intel_niosv_m_data_manager_arready                                          (intel_niosv_m_data_manager_arready),                           //  output,   width = 1,                                                                      .arready
		.intel_niosv_m_data_manager_rdata                                            (intel_niosv_m_data_manager_rdata),                             //  output,  width = 32,                                                                      .rdata
		.intel_niosv_m_data_manager_rresp                                            (intel_niosv_m_data_manager_rresp),                             //  output,   width = 2,                                                                      .rresp
		.intel_niosv_m_data_manager_rvalid                                           (intel_niosv_m_data_manager_rvalid),                            //  output,   width = 1,                                                                      .rvalid
		.intel_niosv_m_data_manager_rready                                           (intel_niosv_m_data_manager_rready),                            //   input,   width = 1,                                                                      .rready
		.intel_niosv_m_instruction_manager_awaddr                                    (intel_niosv_m_instruction_manager_awaddr),                     //   input,  width = 32,                                     intel_niosv_m_instruction_manager.awaddr
		.intel_niosv_m_instruction_manager_awprot                                    (intel_niosv_m_instruction_manager_awprot),                     //   input,   width = 3,                                                                      .awprot
		.intel_niosv_m_instruction_manager_awvalid                                   (intel_niosv_m_instruction_manager_awvalid),                    //   input,   width = 1,                                                                      .awvalid
		.intel_niosv_m_instruction_manager_awready                                   (intel_niosv_m_instruction_manager_awready),                    //  output,   width = 1,                                                                      .awready
		.intel_niosv_m_instruction_manager_wdata                                     (intel_niosv_m_instruction_manager_wdata),                      //   input,  width = 32,                                                                      .wdata
		.intel_niosv_m_instruction_manager_wstrb                                     (intel_niosv_m_instruction_manager_wstrb),                      //   input,   width = 4,                                                                      .wstrb
		.intel_niosv_m_instruction_manager_wvalid                                    (intel_niosv_m_instruction_manager_wvalid),                     //   input,   width = 1,                                                                      .wvalid
		.intel_niosv_m_instruction_manager_wready                                    (intel_niosv_m_instruction_manager_wready),                     //  output,   width = 1,                                                                      .wready
		.intel_niosv_m_instruction_manager_bresp                                     (intel_niosv_m_instruction_manager_bresp),                      //  output,   width = 2,                                                                      .bresp
		.intel_niosv_m_instruction_manager_bvalid                                    (intel_niosv_m_instruction_manager_bvalid),                     //  output,   width = 1,                                                                      .bvalid
		.intel_niosv_m_instruction_manager_bready                                    (intel_niosv_m_instruction_manager_bready),                     //   input,   width = 1,                                                                      .bready
		.intel_niosv_m_instruction_manager_araddr                                    (intel_niosv_m_instruction_manager_araddr),                     //   input,  width = 32,                                                                      .araddr
		.intel_niosv_m_instruction_manager_arprot                                    (intel_niosv_m_instruction_manager_arprot),                     //   input,   width = 3,                                                                      .arprot
		.intel_niosv_m_instruction_manager_arvalid                                   (intel_niosv_m_instruction_manager_arvalid),                    //   input,   width = 1,                                                                      .arvalid
		.intel_niosv_m_instruction_manager_arready                                   (intel_niosv_m_instruction_manager_arready),                    //  output,   width = 1,                                                                      .arready
		.intel_niosv_m_instruction_manager_rdata                                     (intel_niosv_m_instruction_manager_rdata),                      //  output,  width = 32,                                                                      .rdata
		.intel_niosv_m_instruction_manager_rresp                                     (intel_niosv_m_instruction_manager_rresp),                      //  output,   width = 2,                                                                      .rresp
		.intel_niosv_m_instruction_manager_rvalid                                    (intel_niosv_m_instruction_manager_rvalid),                     //  output,   width = 1,                                                                      .rvalid
		.intel_niosv_m_instruction_manager_rready                                    (intel_niosv_m_instruction_manager_rready),                     //   input,   width = 1,                                                                      .rready
		.jtag_uart_avalon_jtag_slave_address                                         (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),        //  output,   width = 1,                                           jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                                           (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),          //  output,   width = 1,                                                                      .write
		.jtag_uart_avalon_jtag_slave_read                                            (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),           //  output,   width = 1,                                                                      .read
		.jtag_uart_avalon_jtag_slave_readdata                                        (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),       //   input,  width = 32,                                                                      .readdata
		.jtag_uart_avalon_jtag_slave_writedata                                       (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),      //  output,  width = 32,                                                                      .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                                     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest),    //   input,   width = 1,                                                                      .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                                      (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),     //  output,   width = 1,                                                                      .chipselect
		.sysid_qsys_control_slave_address                                            (mm_interconnect_0_sysid_qsys_control_slave_address),           //  output,   width = 1,                                              sysid_qsys_control_slave.address
		.sysid_qsys_control_slave_readdata                                           (mm_interconnect_0_sysid_qsys_control_slave_readdata),          //   input,  width = 32,                                                                      .readdata
		.intel_niosv_m_dm_agent_address                                              (mm_interconnect_0_intel_niosv_m_dm_agent_address),             //  output,  width = 16,                                                intel_niosv_m_dm_agent.address
		.intel_niosv_m_dm_agent_write                                                (mm_interconnect_0_intel_niosv_m_dm_agent_write),               //  output,   width = 1,                                                                      .write
		.intel_niosv_m_dm_agent_read                                                 (mm_interconnect_0_intel_niosv_m_dm_agent_read),                //  output,   width = 1,                                                                      .read
		.intel_niosv_m_dm_agent_readdata                                             (mm_interconnect_0_intel_niosv_m_dm_agent_readdata),            //   input,  width = 32,                                                                      .readdata
		.intel_niosv_m_dm_agent_writedata                                            (mm_interconnect_0_intel_niosv_m_dm_agent_writedata),           //  output,  width = 32,                                                                      .writedata
		.intel_niosv_m_dm_agent_readdatavalid                                        (mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid),       //   input,   width = 1,                                                                      .readdatavalid
		.intel_niosv_m_dm_agent_waitrequest                                          (mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest),         //   input,   width = 1,                                                                      .waitrequest
		.intel_onchip_memory_s1_address                                              (mm_interconnect_0_intel_onchip_memory_s1_address),             //  output,  width = 17,                                                intel_onchip_memory_s1.address
		.intel_onchip_memory_s1_write                                                (mm_interconnect_0_intel_onchip_memory_s1_write),               //  output,   width = 1,                                                                      .write
		.intel_onchip_memory_s1_read                                                 (mm_interconnect_0_intel_onchip_memory_s1_read),                //  output,   width = 1,                                                                      .read
		.intel_onchip_memory_s1_readdata                                             (mm_interconnect_0_intel_onchip_memory_s1_readdata),            //   input,  width = 32,                                                                      .readdata
		.intel_onchip_memory_s1_writedata                                            (mm_interconnect_0_intel_onchip_memory_s1_writedata),           //  output,  width = 32,                                                                      .writedata
		.intel_onchip_memory_s1_byteenable                                           (mm_interconnect_0_intel_onchip_memory_s1_byteenable),          //  output,   width = 4,                                                                      .byteenable
		.sw_s1_address                                                               (mm_interconnect_0_sw_s1_address),                              //  output,   width = 2,                                                                 sw_s1.address
		.sw_s1_write                                                                 (mm_interconnect_0_sw_s1_write),                                //  output,   width = 1,                                                                      .write
		.sw_s1_readdata                                                              (mm_interconnect_0_sw_s1_readdata),                             //   input,  width = 32,                                                                      .readdata
		.sw_s1_writedata                                                             (mm_interconnect_0_sw_s1_writedata),                            //  output,  width = 32,                                                                      .writedata
		.sw_s1_chipselect                                                            (mm_interconnect_0_sw_s1_chipselect),                           //  output,   width = 1,                                                                      .chipselect
		.key_s1_address                                                              (mm_interconnect_0_key_s1_address),                             //  output,   width = 2,                                                                key_s1.address
		.key_s1_write                                                                (mm_interconnect_0_key_s1_write),                               //  output,   width = 1,                                                                      .write
		.key_s1_readdata                                                             (mm_interconnect_0_key_s1_readdata),                            //   input,  width = 32,                                                                      .readdata
		.key_s1_writedata                                                            (mm_interconnect_0_key_s1_writedata),                           //  output,  width = 32,                                                                      .writedata
		.key_s1_chipselect                                                           (mm_interconnect_0_key_s1_chipselect),                          //  output,   width = 1,                                                                      .chipselect
		.led_s1_address                                                              (mm_interconnect_0_led_s1_address),                             //  output,   width = 2,                                                                led_s1.address
		.led_s1_write                                                                (mm_interconnect_0_led_s1_write),                               //  output,   width = 1,                                                                      .write
		.led_s1_readdata                                                             (mm_interconnect_0_led_s1_readdata),                            //   input,  width = 32,                                                                      .readdata
		.led_s1_writedata                                                            (mm_interconnect_0_led_s1_writedata),                           //  output,  width = 32,                                                                      .writedata
		.led_s1_chipselect                                                           (mm_interconnect_0_led_s1_chipselect),                          //  output,   width = 1,                                                                      .chipselect
		.pio_fan_s1_address                                                          (mm_interconnect_0_pio_fan_s1_address),                         //  output,   width = 2,                                                            pio_fan_s1.address
		.pio_fan_s1_write                                                            (mm_interconnect_0_pio_fan_s1_write),                           //  output,   width = 1,                                                                      .write
		.pio_fan_s1_readdata                                                         (mm_interconnect_0_pio_fan_s1_readdata),                        //   input,  width = 32,                                                                      .readdata
		.pio_fan_s1_writedata                                                        (mm_interconnect_0_pio_fan_s1_writedata),                       //  output,  width = 32,                                                                      .writedata
		.pio_fan_s1_chipselect                                                       (mm_interconnect_0_pio_fan_s1_chipselect),                      //  output,   width = 1,                                                                      .chipselect
		.fpga_temperature_s1_address                                                 (mm_interconnect_0_fpga_temperature_s1_address),                //  output,   width = 2,                                                   fpga_temperature_s1.address
		.fpga_temperature_s1_readdata                                                (mm_interconnect_0_fpga_temperature_s1_readdata),               //   input,  width = 32,                                                                      .readdata
		.board_temperature_s1_address                                                (mm_interconnect_0_board_temperature_s1_address),               //  output,   width = 2,                                                  board_temperature_s1.address
		.board_temperature_s1_readdata                                               (mm_interconnect_0_board_temperature_s1_readdata),              //   input,  width = 32,                                                                      .readdata
		.power_voltage_s1_address                                                    (mm_interconnect_0_power_voltage_s1_address),                   //  output,   width = 2,                                                      power_voltage_s1.address
		.power_voltage_s1_readdata                                                   (mm_interconnect_0_power_voltage_s1_readdata),                  //   input,  width = 32,                                                                      .readdata
		.power_current_s1_address                                                    (mm_interconnect_0_power_current_s1_address),                   //  output,   width = 2,                                                      power_current_s1.address
		.power_current_s1_readdata                                                   (mm_interconnect_0_power_current_s1_readdata),                  //   input,  width = 32,                                                                      .readdata
		.intel_niosv_m_timer_sw_agent_address                                        (mm_interconnect_0_intel_niosv_m_timer_sw_agent_address),       //  output,   width = 6,                                          intel_niosv_m_timer_sw_agent.address
		.intel_niosv_m_timer_sw_agent_write                                          (mm_interconnect_0_intel_niosv_m_timer_sw_agent_write),         //  output,   width = 1,                                                                      .write
		.intel_niosv_m_timer_sw_agent_read                                           (mm_interconnect_0_intel_niosv_m_timer_sw_agent_read),          //  output,   width = 1,                                                                      .read
		.intel_niosv_m_timer_sw_agent_readdata                                       (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata),      //   input,  width = 32,                                                                      .readdata
		.intel_niosv_m_timer_sw_agent_writedata                                      (mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata),     //  output,  width = 32,                                                                      .writedata
		.intel_niosv_m_timer_sw_agent_byteenable                                     (mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable),    //  output,   width = 4,                                                                      .byteenable
		.intel_niosv_m_timer_sw_agent_readdatavalid                                  (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid), //   input,   width = 1,                                                                      .readdatavalid
		.intel_niosv_m_timer_sw_agent_waitrequest                                    (mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest),   //   input,   width = 1,                                                                      .waitrequest
		.intel_niosv_m_reset_reset_bridge_in_reset_reset                             (rst_controller_001_reset_out_reset),                           //   input,   width = 1,                             intel_niosv_m_reset_reset_bridge_in_reset.reset
		.intel_niosv_m_data_manager_translator_clk_reset_reset_bridge_in_reset_reset (rst_controller_001_reset_out_reset),                           //   input,   width = 1, intel_niosv_m_data_manager_translator_clk_reset_reset_bridge_in_reset.reset
		.clock_in_out_clk_clk                                                        (clock_in_out_clk_clk)                                          //   input,   width = 1,                                                      clock_in_out_clk.clk
	);

	Qsys_altera_irq_mapper_2001_k3auftq irq_mapper (
		.clk           (clock_in_out_clk_clk),              //   input,   width = 1,       clk.clk
		.reset         (rst_controller_reset_out_reset),    //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),          //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),          //   input,   width = 1, receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),          //   input,   width = 1, receiver2.irq
		.sender_irq    (intel_niosv_m_platform_irq_rx_irq)  //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (reset_controller_clock_in_reset_out_reset), //   input,  width = 1, reset_in0.reset
		.clk            (clock_in_out_clk_clk),                      //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset),            //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req),        //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                                      // (terminated),                       
		.reset_in1      (1'b0),                                      // (terminated),                       
		.reset_req_in1  (1'b0),                                      // (terminated),                       
		.reset_in2      (1'b0),                                      // (terminated),                       
		.reset_req_in2  (1'b0),                                      // (terminated),                       
		.reset_in3      (1'b0),                                      // (terminated),                       
		.reset_req_in3  (1'b0),                                      // (terminated),                       
		.reset_in4      (1'b0),                                      // (terminated),                       
		.reset_req_in4  (1'b0),                                      // (terminated),                       
		.reset_in5      (1'b0),                                      // (terminated),                       
		.reset_req_in5  (1'b0),                                      // (terminated),                       
		.reset_in6      (1'b0),                                      // (terminated),                       
		.reset_req_in6  (1'b0),                                      // (terminated),                       
		.reset_in7      (1'b0),                                      // (terminated),                       
		.reset_req_in7  (1'b0),                                      // (terminated),                       
		.reset_in8      (1'b0),                                      // (terminated),                       
		.reset_req_in8  (1'b0),                                      // (terminated),                       
		.reset_in9      (1'b0),                                      // (terminated),                       
		.reset_req_in9  (1'b0),                                      // (terminated),                       
		.reset_in10     (1'b0),                                      // (terminated),                       
		.reset_req_in10 (1'b0),                                      // (terminated),                       
		.reset_in11     (1'b0),                                      // (terminated),                       
		.reset_req_in11 (1'b0),                                      // (terminated),                       
		.reset_in12     (1'b0),                                      // (terminated),                       
		.reset_req_in12 (1'b0),                                      // (terminated),                       
		.reset_in13     (1'b0),                                      // (terminated),                       
		.reset_req_in13 (1'b0),                                      // (terminated),                       
		.reset_in14     (1'b0),                                      // (terminated),                       
		.reset_req_in14 (1'b0),                                      // (terminated),                       
		.reset_in15     (1'b0),                                      // (terminated),                       
		.reset_req_in15 (1'b0)                                       // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (reset_controller_clock_in_reset_out_reset), //   input,  width = 1, reset_in0.reset
		.clk            (clock_in_out_clk_clk),                      //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset),        //  output,  width = 1, reset_out.reset
		.reset_req      (),                                          // (terminated),                       
		.reset_req_in0  (1'b0),                                      // (terminated),                       
		.reset_in1      (1'b0),                                      // (terminated),                       
		.reset_req_in1  (1'b0),                                      // (terminated),                       
		.reset_in2      (1'b0),                                      // (terminated),                       
		.reset_req_in2  (1'b0),                                      // (terminated),                       
		.reset_in3      (1'b0),                                      // (terminated),                       
		.reset_req_in3  (1'b0),                                      // (terminated),                       
		.reset_in4      (1'b0),                                      // (terminated),                       
		.reset_req_in4  (1'b0),                                      // (terminated),                       
		.reset_in5      (1'b0),                                      // (terminated),                       
		.reset_req_in5  (1'b0),                                      // (terminated),                       
		.reset_in6      (1'b0),                                      // (terminated),                       
		.reset_req_in6  (1'b0),                                      // (terminated),                       
		.reset_in7      (1'b0),                                      // (terminated),                       
		.reset_req_in7  (1'b0),                                      // (terminated),                       
		.reset_in8      (1'b0),                                      // (terminated),                       
		.reset_req_in8  (1'b0),                                      // (terminated),                       
		.reset_in9      (1'b0),                                      // (terminated),                       
		.reset_req_in9  (1'b0),                                      // (terminated),                       
		.reset_in10     (1'b0),                                      // (terminated),                       
		.reset_req_in10 (1'b0),                                      // (terminated),                       
		.reset_in11     (1'b0),                                      // (terminated),                       
		.reset_req_in11 (1'b0),                                      // (terminated),                       
		.reset_in12     (1'b0),                                      // (terminated),                       
		.reset_req_in12 (1'b0),                                      // (terminated),                       
		.reset_in13     (1'b0),                                      // (terminated),                       
		.reset_req_in13 (1'b0),                                      // (terminated),                       
		.reset_in14     (1'b0),                                      // (terminated),                       
		.reset_req_in14 (1'b0),                                      // (terminated),                       
		.reset_in15     (1'b0),                                      // (terminated),                       
		.reset_req_in15 (1'b0)                                       // (terminated),                       
	);

endmodule
