	component Qsys is
		port (
			board_temperature_export : in  std_logic_vector(15 downto 0) := (others => 'X'); -- export
			clk_clk                  : in  std_logic                     := 'X';             -- clk
			fpga_temperature_export  : in  std_logic_vector(15 downto 0) := (others => 'X'); -- export
			pio_button_export        : in  std_logic                     := 'X';             -- export
			pio_led_export           : out std_logic;                                        -- export
			pio_fan_in_port          : in  std_logic_vector(31 downto 0) := (others => 'X'); -- in_port
			pio_fan_out_port         : out std_logic_vector(31 downto 0);                    -- out_port
			power_current_export     : in  std_logic_vector(15 downto 0) := (others => 'X'); -- export
			power_voltage_export     : in  std_logic_vector(15 downto 0) := (others => 'X'); -- export
			reset_reset_n            : in  std_logic                     := 'X';             -- reset_n
			pio_sw_export            : in  std_logic_vector(2 downto 0)  := (others => 'X')  -- export
		);
	end component Qsys;

	u0 : component Qsys
		port map (
			board_temperature_export => CONNECTED_TO_board_temperature_export, -- board_temperature.export
			clk_clk                  => CONNECTED_TO_clk_clk,                  --               clk.clk
			fpga_temperature_export  => CONNECTED_TO_fpga_temperature_export,  --  fpga_temperature.export
			pio_button_export        => CONNECTED_TO_pio_button_export,        --        pio_button.export
			pio_led_export           => CONNECTED_TO_pio_led_export,           --           pio_led.export
			pio_fan_in_port          => CONNECTED_TO_pio_fan_in_port,          --           pio_fan.in_port
			pio_fan_out_port         => CONNECTED_TO_pio_fan_out_port,         --                  .out_port
			power_current_export     => CONNECTED_TO_power_current_export,     --     power_current.export
			power_voltage_export     => CONNECTED_TO_power_voltage_export,     --     power_voltage.export
			reset_reset_n            => CONNECTED_TO_reset_reset_n,            --             reset.reset_n
			pio_sw_export            => CONNECTED_TO_pio_sw_export             --            pio_sw.export
		);

