// system_terasic_sdio_0.v

// Generated using ACDS version 25.1 129

`timescale 1 ps / 1 ps
module system_terasic_sdio_0 #(
		parameter CLK_FREQ = 50000000
	) (
		input  wire        clk,           //        clock.clk
		input  wire        reset_n,       //        reset.reset_n
		input  wire [11:0] avs_address,   // avalon_slave.address
		input  wire        avs_write,     //             .write
		input  wire        avs_read,      //             .read
		input  wire [7:0]  avs_writedata, //             .writedata
		output wire [7:0]  avs_readdata,  //             .readdata
		output wire        sd_clk,        //  conduit_end.sd_clk
		inout  wire        sd_cmd,        //             .sd_cmd
		inout  wire [3:0]  sd_data        //             .sd_data
	);

	terasic_sdio #(
		.CLK_FREQ (CLK_FREQ)
	) terasic_sdio_0 (
		.clk           (clk),           //   input,   width = 1,        clock.clk
		.reset_n       (reset_n),       //   input,   width = 1,        reset.reset_n
		.avs_address   (avs_address),   //   input,  width = 12, avalon_slave.address
		.avs_write     (avs_write),     //   input,   width = 1,             .write
		.avs_read      (avs_read),      //   input,   width = 1,             .read
		.avs_writedata (avs_writedata), //   input,   width = 8,             .writedata
		.avs_readdata  (avs_readdata),  //  output,   width = 8,             .readdata
		.sd_clk        (sd_clk),        //  output,   width = 1,  conduit_end.sd_clk
		.sd_cmd        (sd_cmd),        //   inout,   width = 1,             .sd_cmd
		.sd_data       (sd_data)        //   inout,   width = 4,             .sd_data
	);

endmodule
