// nios_system.v

// Generated using ACDS version 25.1 129

`timescale 1 ps / 1 ps
module nios_system (
		input  wire        clk_clk,                                    //                               clk.clk
		output wire        intel_vvp_cvo_vid_status_vid_locked,        //          intel_vvp_cvo_vid_status.vid_locked
		output wire        intel_vvp_cvo_vid_status_vid_is_full,       //                                  .vid_is_full
		output wire        intel_vvp_cvo_vid_status_vid_stall_error,   //                                  .vid_stall_error
		output wire        intel_vvp_cvo_vid_status_vid_size_mismatch, //                                  .vid_size_mismatch
		input  wire        intel_vvp_cvo_frame_start_conduit,          //         intel_vvp_cvo_frame_start.conduit
		output wire        intel_vvp_fr2cv_cv_clk_out_clk,             //        intel_vvp_fr2cv_cv_clk_out.clk
		output wire [23:0] intel_vvp_fr2cv_cv_vid_out_vid_data,        //        intel_vvp_fr2cv_cv_vid_out.vid_data
		output wire        intel_vvp_fr2cv_cv_vid_out_underflow,       //                                  .underflow
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_datavalid,   //                                  .vid_datavalid
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_v_sync,      //                                  .vid_v_sync
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_h_sync,      //                                  .vid_h_sync
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_f,           //                                  .vid_f
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_h,           //                                  .vid_h
		output wire        intel_vvp_fr2cv_cv_vid_out_vid_v,           //                                  .vid_v
		input  wire        intel_vvp_vfr_fsync_in_read,                //            intel_vvp_vfr_fsync_in.read
		output wire        sdram_clk_clk,                              //                         sdram_clk.clk
		output wire        iopll_vga_outclk1_clk,                      //                 iopll_vga_outclk1.clk
		output wire        pio_fsync_out_external_connection_export,   // pio_fsync_out_external_connection.export
		input  wire [1:0]  key_external_connection_export,             //           key_external_connection.export
		output wire [3:0]  led_external_connection_export,             //           led_external_connection.export
		input  wire [1:0]  sw_external_connection_export,              //            sw_external_connection.export
		input  wire        reset_reset_n,                              //                             reset.reset_n
		output wire        sdram_cke,                                  //                             sdram.cke
		output wire        sdram_cs_n,                                 //                                  .cs_n
		output wire        sdram_ras_n,                                //                                  .ras_n
		output wire        sdram_cas_n,                                //                                  .cas_n
		output wire        sdram_we_n,                                 //                                  .we_n
		output wire [3:0]  sdram_dqm,                                  //                                  .dqm
		output wire [12:0] sdram_addr,                                 //                                  .addr
		output wire [1:0]  sdram_ba,                                   //                                  .ba
		output wire [31:0] sdram_data_out,                             //                                  .data_out
		output wire        sdram_data_oe,                              //                                  .data_oe
		input  wire [31:0] sdram_data_in,                              //                                  .data_in
		output wire        terasic_sdcard_conduit_end_sd_clk,          //        terasic_sdcard_conduit_end.sd_clk
		inout  wire        terasic_sdcard_conduit_end_sd_cmd,          //                                  .sd_cmd
		inout  wire [3:0]  terasic_sdcard_conduit_end_sd_data          //                                  .sd_data
	);

	wire          intel_vvp_cvo_axi4s_fr_vid_out_tvalid;                             // intel_vvp_cvo:axi4s_fr_vid_out_tvalid -> intel_vvp_fr2cv:axi4s_fr_vid_in_tvalid
	wire    [3:0] intel_vvp_cvo_axi4s_fr_vid_out_tuser;                              // intel_vvp_cvo:axi4s_fr_vid_out_tuser -> intel_vvp_fr2cv:axi4s_fr_vid_in_tuser
	wire          intel_vvp_cvo_axi4s_fr_vid_out_tready;                             // intel_vvp_fr2cv:axi4s_fr_vid_in_tready -> intel_vvp_cvo:axi4s_fr_vid_out_tready
	wire   [31:0] intel_vvp_cvo_axi4s_fr_vid_out_tdata;                              // intel_vvp_cvo:axi4s_fr_vid_out_tdata -> intel_vvp_fr2cv:axi4s_fr_vid_in_tdata
	wire          intel_vvp_cvo_axi4s_fr_vid_out_tlast;                              // intel_vvp_cvo:axi4s_fr_vid_out_tlast -> intel_vvp_fr2cv:axi4s_fr_vid_in_tlast
	wire          intel_vvp_vfr_axi4s_vid_out_tvalid;                                // intel_vvp_vfr:axi4s_vid_out_tvalid -> intel_vvp_scaler:axi4s_vid_in_tvalid
	wire    [2:0] intel_vvp_vfr_axi4s_vid_out_tuser;                                 // intel_vvp_vfr:axi4s_vid_out_tuser -> intel_vvp_scaler:axi4s_vid_in_tuser
	wire          intel_vvp_vfr_axi4s_vid_out_tready;                                // intel_vvp_scaler:axi4s_vid_in_tready -> intel_vvp_vfr:axi4s_vid_out_tready
	wire   [23:0] intel_vvp_vfr_axi4s_vid_out_tdata;                                 // intel_vvp_vfr:axi4s_vid_out_tdata -> intel_vvp_scaler:axi4s_vid_in_tdata
	wire          intel_vvp_vfr_axi4s_vid_out_tlast;                                 // intel_vvp_vfr:axi4s_vid_out_tlast -> intel_vvp_scaler:axi4s_vid_in_tlast
	wire          intel_vvp_scaler_axi4s_vid_out_tvalid;                             // intel_vvp_scaler:axi4s_vid_out_tvalid -> intel_vvp_cvo:axi4s_vid_in_tvalid
	wire    [2:0] intel_vvp_scaler_axi4s_vid_out_tuser;                              // intel_vvp_scaler:axi4s_vid_out_tuser -> intel_vvp_cvo:axi4s_vid_in_tuser
	wire          intel_vvp_scaler_axi4s_vid_out_tready;                             // intel_vvp_cvo:axi4s_vid_in_tready -> intel_vvp_scaler:axi4s_vid_out_tready
	wire   [23:0] intel_vvp_scaler_axi4s_vid_out_tdata;                              // intel_vvp_scaler:axi4s_vid_out_tdata -> intel_vvp_cvo:axi4s_vid_in_tdata
	wire          intel_vvp_scaler_axi4s_vid_out_tlast;                              // intel_vvp_scaler:axi4s_vid_out_tlast -> intel_vvp_cvo:axi4s_vid_in_tlast
	wire          clock_in_out_clk_clk;                                              // clock_in:out_clk -> [iopll:refclk, iopll_vga:refclk, reset_bridge:clk, reset_in:clk, rst_controller_004:clk]
	wire          iopll_outclk0_clk;                                                 // iopll:outclk_0 -> [intel_vvp_vfr:control_clock_clk, intel_vvp_vfr:mem_clock_clk, irq_mapper:clk, jtag_uart:clk, mm_bridge_peripheral:clk, mm_interconnect_0:iopll_outclk0_clk, mm_interconnect_1:iopll_outclk0_clk, niosv_g:clk, onchip_memory:clk, pio_fsync_out:clk, pio_key:clk, pio_led:clk, pio_sw:clk, rst_controller_001:clk, rst_controller_002:clk, rst_controller_003:clk, rst_controller_006:clk, sdram:clk_i, sysid_qsys:clock]
	wire          iopll_vga_outclk0_clk;                                             // iopll_vga:outclk_0 -> [intel_vvp_cvo:fr_clock_clk, intel_vvp_cvo:vid_clock_clk, intel_vvp_fr2cv:vid_clock_clk, intel_vvp_scaler:main_clock_clk, intel_vvp_vfr:main_clock_clk, rst_controller:clk]
	wire          iopll_outclk2_clk;                                                 // iopll:outclk_2 -> sdram:clk_sample_i
	wire          iopll_outclk3_clk;                                                 // iopll:outclk_3 -> [mm_interconnect_1:iopll_outclk3_clk, rst_controller_005:clk, rst_controller_007:clk, terasic_sdcard:clk]
	wire          reset_bridge_out_reset_reset;                                      // reset_bridge:out_reset_n -> [iopll:rst, iopll_vga:rst, rst_controller:reset_in0, rst_controller_001:reset_in0, rst_controller_002:reset_in0, rst_controller_003:reset_in1, rst_controller_005:reset_in0, rst_controller_006:reset_in1, rst_controller_007:reset_in0]
	wire          intel_vvp_vfr_av_mm_mem_read_host_waitrequest;                     // mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_waitrequest -> intel_vvp_vfr:av_mm_mem_read_host_waitrequest
	wire  [255:0] intel_vvp_vfr_av_mm_mem_read_host_readdata;                        // mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_readdata -> intel_vvp_vfr:av_mm_mem_read_host_readdata
	wire   [31:0] intel_vvp_vfr_av_mm_mem_read_host_address;                         // intel_vvp_vfr:av_mm_mem_read_host_address -> mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_address
	wire          intel_vvp_vfr_av_mm_mem_read_host_read;                            // intel_vvp_vfr:av_mm_mem_read_host_read -> mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_read
	wire          intel_vvp_vfr_av_mm_mem_read_host_readdatavalid;                   // mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_readdatavalid -> intel_vvp_vfr:av_mm_mem_read_host_readdatavalid
	wire    [5:0] intel_vvp_vfr_av_mm_mem_read_host_burstcount;                      // intel_vvp_vfr:av_mm_mem_read_host_burstcount -> mm_interconnect_0:intel_vvp_vfr_av_mm_mem_read_host_burstcount
	wire    [7:0] niosv_g_data_manager_arlen;                                        // niosv_g:data_manager_arlen -> mm_interconnect_0:niosv_g_data_manager_arlen
	wire    [3:0] niosv_g_data_manager_wstrb;                                        // niosv_g:data_manager_wstrb -> mm_interconnect_0:niosv_g_data_manager_wstrb
	wire          niosv_g_data_manager_wready;                                       // mm_interconnect_0:niosv_g_data_manager_wready -> niosv_g:data_manager_wready
	wire          niosv_g_data_manager_rready;                                       // niosv_g:data_manager_rready -> mm_interconnect_0:niosv_g_data_manager_rready
	wire    [7:0] niosv_g_data_manager_awlen;                                        // niosv_g:data_manager_awlen -> mm_interconnect_0:niosv_g_data_manager_awlen
	wire          niosv_g_data_manager_wvalid;                                       // niosv_g:data_manager_wvalid -> mm_interconnect_0:niosv_g_data_manager_wvalid
	wire   [31:0] niosv_g_data_manager_araddr;                                       // niosv_g:data_manager_araddr -> mm_interconnect_0:niosv_g_data_manager_araddr
	wire    [2:0] niosv_g_data_manager_arprot;                                       // niosv_g:data_manager_arprot -> mm_interconnect_0:niosv_g_data_manager_arprot
	wire    [2:0] niosv_g_data_manager_awprot;                                       // niosv_g:data_manager_awprot -> mm_interconnect_0:niosv_g_data_manager_awprot
	wire   [31:0] niosv_g_data_manager_wdata;                                        // niosv_g:data_manager_wdata -> mm_interconnect_0:niosv_g_data_manager_wdata
	wire          niosv_g_data_manager_arvalid;                                      // niosv_g:data_manager_arvalid -> mm_interconnect_0:niosv_g_data_manager_arvalid
	wire   [31:0] niosv_g_data_manager_awaddr;                                       // niosv_g:data_manager_awaddr -> mm_interconnect_0:niosv_g_data_manager_awaddr
	wire    [1:0] niosv_g_data_manager_bresp;                                        // mm_interconnect_0:niosv_g_data_manager_bresp -> niosv_g:data_manager_bresp
	wire          niosv_g_data_manager_arready;                                      // mm_interconnect_0:niosv_g_data_manager_arready -> niosv_g:data_manager_arready
	wire   [31:0] niosv_g_data_manager_rdata;                                        // mm_interconnect_0:niosv_g_data_manager_rdata -> niosv_g:data_manager_rdata
	wire          niosv_g_data_manager_awready;                                      // mm_interconnect_0:niosv_g_data_manager_awready -> niosv_g:data_manager_awready
	wire    [2:0] niosv_g_data_manager_arsize;                                       // niosv_g:data_manager_arsize -> mm_interconnect_0:niosv_g_data_manager_arsize
	wire          niosv_g_data_manager_rlast;                                        // mm_interconnect_0:niosv_g_data_manager_rlast -> niosv_g:data_manager_rlast
	wire          niosv_g_data_manager_bready;                                       // niosv_g:data_manager_bready -> mm_interconnect_0:niosv_g_data_manager_bready
	wire          niosv_g_data_manager_wlast;                                        // niosv_g:data_manager_wlast -> mm_interconnect_0:niosv_g_data_manager_wlast
	wire    [1:0] niosv_g_data_manager_rresp;                                        // mm_interconnect_0:niosv_g_data_manager_rresp -> niosv_g:data_manager_rresp
	wire          niosv_g_data_manager_bvalid;                                       // mm_interconnect_0:niosv_g_data_manager_bvalid -> niosv_g:data_manager_bvalid
	wire    [2:0] niosv_g_data_manager_awsize;                                       // niosv_g:data_manager_awsize -> mm_interconnect_0:niosv_g_data_manager_awsize
	wire          niosv_g_data_manager_awvalid;                                      // niosv_g:data_manager_awvalid -> mm_interconnect_0:niosv_g_data_manager_awvalid
	wire          niosv_g_data_manager_rvalid;                                       // mm_interconnect_0:niosv_g_data_manager_rvalid -> niosv_g:data_manager_rvalid
	wire    [1:0] niosv_g_instruction_manager_awburst;                               // niosv_g:instruction_manager_awburst -> mm_interconnect_0:niosv_g_instruction_manager_awburst
	wire    [7:0] niosv_g_instruction_manager_arlen;                                 // niosv_g:instruction_manager_arlen -> mm_interconnect_0:niosv_g_instruction_manager_arlen
	wire    [3:0] niosv_g_instruction_manager_wstrb;                                 // niosv_g:instruction_manager_wstrb -> mm_interconnect_0:niosv_g_instruction_manager_wstrb
	wire          niosv_g_instruction_manager_wready;                                // mm_interconnect_0:niosv_g_instruction_manager_wready -> niosv_g:instruction_manager_wready
	wire          niosv_g_instruction_manager_rready;                                // niosv_g:instruction_manager_rready -> mm_interconnect_0:niosv_g_instruction_manager_rready
	wire    [7:0] niosv_g_instruction_manager_awlen;                                 // niosv_g:instruction_manager_awlen -> mm_interconnect_0:niosv_g_instruction_manager_awlen
	wire          niosv_g_instruction_manager_wvalid;                                // niosv_g:instruction_manager_wvalid -> mm_interconnect_0:niosv_g_instruction_manager_wvalid
	wire   [31:0] niosv_g_instruction_manager_araddr;                                // niosv_g:instruction_manager_araddr -> mm_interconnect_0:niosv_g_instruction_manager_araddr
	wire    [2:0] niosv_g_instruction_manager_arprot;                                // niosv_g:instruction_manager_arprot -> mm_interconnect_0:niosv_g_instruction_manager_arprot
	wire    [2:0] niosv_g_instruction_manager_awprot;                                // niosv_g:instruction_manager_awprot -> mm_interconnect_0:niosv_g_instruction_manager_awprot
	wire   [31:0] niosv_g_instruction_manager_wdata;                                 // niosv_g:instruction_manager_wdata -> mm_interconnect_0:niosv_g_instruction_manager_wdata
	wire          niosv_g_instruction_manager_arvalid;                               // niosv_g:instruction_manager_arvalid -> mm_interconnect_0:niosv_g_instruction_manager_arvalid
	wire   [31:0] niosv_g_instruction_manager_awaddr;                                // niosv_g:instruction_manager_awaddr -> mm_interconnect_0:niosv_g_instruction_manager_awaddr
	wire    [1:0] niosv_g_instruction_manager_bresp;                                 // mm_interconnect_0:niosv_g_instruction_manager_bresp -> niosv_g:instruction_manager_bresp
	wire          niosv_g_instruction_manager_arready;                               // mm_interconnect_0:niosv_g_instruction_manager_arready -> niosv_g:instruction_manager_arready
	wire   [31:0] niosv_g_instruction_manager_rdata;                                 // mm_interconnect_0:niosv_g_instruction_manager_rdata -> niosv_g:instruction_manager_rdata
	wire    [1:0] niosv_g_instruction_manager_arburst;                               // niosv_g:instruction_manager_arburst -> mm_interconnect_0:niosv_g_instruction_manager_arburst
	wire          niosv_g_instruction_manager_awready;                               // mm_interconnect_0:niosv_g_instruction_manager_awready -> niosv_g:instruction_manager_awready
	wire    [2:0] niosv_g_instruction_manager_arsize;                                // niosv_g:instruction_manager_arsize -> mm_interconnect_0:niosv_g_instruction_manager_arsize
	wire          niosv_g_instruction_manager_rlast;                                 // mm_interconnect_0:niosv_g_instruction_manager_rlast -> niosv_g:instruction_manager_rlast
	wire          niosv_g_instruction_manager_bready;                                // niosv_g:instruction_manager_bready -> mm_interconnect_0:niosv_g_instruction_manager_bready
	wire          niosv_g_instruction_manager_wlast;                                 // niosv_g:instruction_manager_wlast -> mm_interconnect_0:niosv_g_instruction_manager_wlast
	wire    [1:0] niosv_g_instruction_manager_rresp;                                 // mm_interconnect_0:niosv_g_instruction_manager_rresp -> niosv_g:instruction_manager_rresp
	wire          niosv_g_instruction_manager_bvalid;                                // mm_interconnect_0:niosv_g_instruction_manager_bvalid -> niosv_g:instruction_manager_bvalid
	wire    [2:0] niosv_g_instruction_manager_awsize;                                // niosv_g:instruction_manager_awsize -> mm_interconnect_0:niosv_g_instruction_manager_awsize
	wire          niosv_g_instruction_manager_awvalid;                               // niosv_g:instruction_manager_awvalid -> mm_interconnect_0:niosv_g_instruction_manager_awvalid
	wire          niosv_g_instruction_manager_rvalid;                                // mm_interconnect_0:niosv_g_instruction_manager_rvalid -> niosv_g:instruction_manager_rvalid
	wire    [1:0] mm_interconnect_0_sdram_axi4_slave_awburst;                        // mm_interconnect_0:sdram_axi4_slave_awburst -> sdram:inport_awburst_i
	wire    [7:0] mm_interconnect_0_sdram_axi4_slave_arlen;                          // mm_interconnect_0:sdram_axi4_slave_arlen -> sdram:inport_arlen_i
	wire    [7:0] mm_interconnect_0_sdram_axi4_slave_wstrb;                          // mm_interconnect_0:sdram_axi4_slave_wstrb -> sdram:inport_wstrb_i
	wire          mm_interconnect_0_sdram_axi4_slave_wready;                         // sdram:inport_wready_o -> mm_interconnect_0:sdram_axi4_slave_wready
	wire    [3:0] mm_interconnect_0_sdram_axi4_slave_rid;                            // sdram:inport_rid_o -> mm_interconnect_0:sdram_axi4_slave_rid
	wire          mm_interconnect_0_sdram_axi4_slave_rready;                         // mm_interconnect_0:sdram_axi4_slave_rready -> sdram:inport_rready_i
	wire    [7:0] mm_interconnect_0_sdram_axi4_slave_awlen;                          // mm_interconnect_0:sdram_axi4_slave_awlen -> sdram:inport_awlen_i
	wire          mm_interconnect_0_sdram_axi4_slave_wvalid;                         // mm_interconnect_0:sdram_axi4_slave_wvalid -> sdram:inport_wvalid_i
	wire   [25:0] mm_interconnect_0_sdram_axi4_slave_araddr;                         // mm_interconnect_0:sdram_axi4_slave_araddr -> sdram:inport_araddr_i
	wire   [63:0] mm_interconnect_0_sdram_axi4_slave_wdata;                          // mm_interconnect_0:sdram_axi4_slave_wdata -> sdram:inport_wdata_i
	wire          mm_interconnect_0_sdram_axi4_slave_arvalid;                        // mm_interconnect_0:sdram_axi4_slave_arvalid -> sdram:inport_arvalid_i
	wire    [3:0] mm_interconnect_0_sdram_axi4_slave_arid;                           // mm_interconnect_0:sdram_axi4_slave_arid -> sdram:inport_arid_i
	wire   [25:0] mm_interconnect_0_sdram_axi4_slave_awaddr;                         // mm_interconnect_0:sdram_axi4_slave_awaddr -> sdram:inport_awaddr_i
	wire    [1:0] mm_interconnect_0_sdram_axi4_slave_bresp;                          // sdram:inport_bresp_o -> mm_interconnect_0:sdram_axi4_slave_bresp
	wire          mm_interconnect_0_sdram_axi4_slave_arready;                        // sdram:inport_arready_o -> mm_interconnect_0:sdram_axi4_slave_arready
	wire   [63:0] mm_interconnect_0_sdram_axi4_slave_rdata;                          // sdram:inport_rdata_o -> mm_interconnect_0:sdram_axi4_slave_rdata
	wire          mm_interconnect_0_sdram_axi4_slave_awready;                        // sdram:inport_awready_o -> mm_interconnect_0:sdram_axi4_slave_awready
	wire    [1:0] mm_interconnect_0_sdram_axi4_slave_arburst;                        // mm_interconnect_0:sdram_axi4_slave_arburst -> sdram:inport_arburst_i
	wire    [2:0] mm_interconnect_0_sdram_axi4_slave_arsize;                         // mm_interconnect_0:sdram_axi4_slave_arsize -> sdram:inport_arsize_i
	wire          mm_interconnect_0_sdram_axi4_slave_bready;                         // mm_interconnect_0:sdram_axi4_slave_bready -> sdram:inport_bready_i
	wire          mm_interconnect_0_sdram_axi4_slave_rlast;                          // sdram:inport_rlast_o -> mm_interconnect_0:sdram_axi4_slave_rlast
	wire          mm_interconnect_0_sdram_axi4_slave_wlast;                          // mm_interconnect_0:sdram_axi4_slave_wlast -> sdram:inport_wlast_i
	wire    [1:0] mm_interconnect_0_sdram_axi4_slave_rresp;                          // sdram:inport_rresp_o -> mm_interconnect_0:sdram_axi4_slave_rresp
	wire    [3:0] mm_interconnect_0_sdram_axi4_slave_awid;                           // mm_interconnect_0:sdram_axi4_slave_awid -> sdram:inport_awid_i
	wire    [3:0] mm_interconnect_0_sdram_axi4_slave_bid;                            // sdram:inport_bid_o -> mm_interconnect_0:sdram_axi4_slave_bid
	wire          mm_interconnect_0_sdram_axi4_slave_bvalid;                         // sdram:inport_bvalid_o -> mm_interconnect_0:sdram_axi4_slave_bvalid
	wire    [2:0] mm_interconnect_0_sdram_axi4_slave_awsize;                         // mm_interconnect_0:sdram_axi4_slave_awsize -> sdram:inport_awsize_i
	wire          mm_interconnect_0_sdram_axi4_slave_awvalid;                        // mm_interconnect_0:sdram_axi4_slave_awvalid -> sdram:inport_awvalid_i
	wire          mm_interconnect_0_sdram_axi4_slave_rvalid;                         // sdram:inport_rvalid_o -> mm_interconnect_0:sdram_axi4_slave_rvalid
	wire   [31:0] mm_interconnect_0_niosv_g_dm_agent_readdata;                       // niosv_g:dm_agent_readdata -> mm_interconnect_0:niosv_g_dm_agent_readdata
	wire          mm_interconnect_0_niosv_g_dm_agent_waitrequest;                    // niosv_g:dm_agent_waitrequest -> mm_interconnect_0:niosv_g_dm_agent_waitrequest
	wire   [15:0] mm_interconnect_0_niosv_g_dm_agent_address;                        // mm_interconnect_0:niosv_g_dm_agent_address -> niosv_g:dm_agent_address
	wire          mm_interconnect_0_niosv_g_dm_agent_read;                           // mm_interconnect_0:niosv_g_dm_agent_read -> niosv_g:dm_agent_read
	wire          mm_interconnect_0_niosv_g_dm_agent_readdatavalid;                  // niosv_g:dm_agent_readdatavalid -> mm_interconnect_0:niosv_g_dm_agent_readdatavalid
	wire          mm_interconnect_0_niosv_g_dm_agent_write;                          // mm_interconnect_0:niosv_g_dm_agent_write -> niosv_g:dm_agent_write
	wire   [31:0] mm_interconnect_0_niosv_g_dm_agent_writedata;                      // mm_interconnect_0:niosv_g_dm_agent_writedata -> niosv_g:dm_agent_writedata
	wire   [31:0] mm_interconnect_0_mm_bridge_peripheral_s0_readdata;                // mm_bridge_peripheral:s0_readdata -> mm_interconnect_0:mm_bridge_peripheral_s0_readdata
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest;             // mm_bridge_peripheral:s0_waitrequest -> mm_interconnect_0:mm_bridge_peripheral_s0_waitrequest
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess;             // mm_interconnect_0:mm_bridge_peripheral_s0_debugaccess -> mm_bridge_peripheral:s0_debugaccess
	wire   [17:0] mm_interconnect_0_mm_bridge_peripheral_s0_address;                 // mm_interconnect_0:mm_bridge_peripheral_s0_address -> mm_bridge_peripheral:s0_address
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_read;                    // mm_interconnect_0:mm_bridge_peripheral_s0_read -> mm_bridge_peripheral:s0_read
	wire    [3:0] mm_interconnect_0_mm_bridge_peripheral_s0_byteenable;              // mm_interconnect_0:mm_bridge_peripheral_s0_byteenable -> mm_bridge_peripheral:s0_byteenable
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid;           // mm_bridge_peripheral:s0_readdatavalid -> mm_interconnect_0:mm_bridge_peripheral_s0_readdatavalid
	wire          mm_interconnect_0_mm_bridge_peripheral_s0_write;                   // mm_interconnect_0:mm_bridge_peripheral_s0_write -> mm_bridge_peripheral:s0_write
	wire   [31:0] mm_interconnect_0_mm_bridge_peripheral_s0_writedata;               // mm_interconnect_0:mm_bridge_peripheral_s0_writedata -> mm_bridge_peripheral:s0_writedata
	wire    [0:0] mm_interconnect_0_mm_bridge_peripheral_s0_burstcount;              // mm_interconnect_0:mm_bridge_peripheral_s0_burstcount -> mm_bridge_peripheral:s0_burstcount
	wire   [31:0] mm_interconnect_0_onchip_memory_s1_readdata;                       // onchip_memory:readdata -> mm_interconnect_0:onchip_memory_s1_readdata
	wire   [16:0] mm_interconnect_0_onchip_memory_s1_address;                        // mm_interconnect_0:onchip_memory_s1_address -> onchip_memory:address
	wire          mm_interconnect_0_onchip_memory_s1_read;                           // mm_interconnect_0:onchip_memory_s1_read -> onchip_memory:read
	wire    [3:0] mm_interconnect_0_onchip_memory_s1_byteenable;                     // mm_interconnect_0:onchip_memory_s1_byteenable -> onchip_memory:byteenable
	wire          mm_interconnect_0_onchip_memory_s1_write;                          // mm_interconnect_0:onchip_memory_s1_write -> onchip_memory:write
	wire   [31:0] mm_interconnect_0_onchip_memory_s1_writedata;                      // mm_interconnect_0:onchip_memory_s1_writedata -> onchip_memory:writedata
	wire   [31:0] mm_interconnect_0_niosv_g_timer_sw_agent_readdata;                 // niosv_g:timer_sw_agent_readdata -> mm_interconnect_0:niosv_g_timer_sw_agent_readdata
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest;              // niosv_g:timer_sw_agent_waitrequest -> mm_interconnect_0:niosv_g_timer_sw_agent_waitrequest
	wire    [5:0] mm_interconnect_0_niosv_g_timer_sw_agent_address;                  // mm_interconnect_0:niosv_g_timer_sw_agent_address -> niosv_g:timer_sw_agent_address
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_read;                     // mm_interconnect_0:niosv_g_timer_sw_agent_read -> niosv_g:timer_sw_agent_read
	wire    [3:0] mm_interconnect_0_niosv_g_timer_sw_agent_byteenable;               // mm_interconnect_0:niosv_g_timer_sw_agent_byteenable -> niosv_g:timer_sw_agent_byteenable
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid;            // niosv_g:timer_sw_agent_readdatavalid -> mm_interconnect_0:niosv_g_timer_sw_agent_readdatavalid
	wire          mm_interconnect_0_niosv_g_timer_sw_agent_write;                    // mm_interconnect_0:niosv_g_timer_sw_agent_write -> niosv_g:timer_sw_agent_write
	wire   [31:0] mm_interconnect_0_niosv_g_timer_sw_agent_writedata;                // mm_interconnect_0:niosv_g_timer_sw_agent_writedata -> niosv_g:timer_sw_agent_writedata
	wire          mm_bridge_peripheral_m0_waitrequest;                               // mm_interconnect_1:mm_bridge_peripheral_m0_waitrequest -> mm_bridge_peripheral:m0_waitrequest
	wire   [31:0] mm_bridge_peripheral_m0_readdata;                                  // mm_interconnect_1:mm_bridge_peripheral_m0_readdata -> mm_bridge_peripheral:m0_readdata
	wire          mm_bridge_peripheral_m0_debugaccess;                               // mm_bridge_peripheral:m0_debugaccess -> mm_interconnect_1:mm_bridge_peripheral_m0_debugaccess
	wire   [17:0] mm_bridge_peripheral_m0_address;                                   // mm_bridge_peripheral:m0_address -> mm_interconnect_1:mm_bridge_peripheral_m0_address
	wire          mm_bridge_peripheral_m0_read;                                      // mm_bridge_peripheral:m0_read -> mm_interconnect_1:mm_bridge_peripheral_m0_read
	wire    [3:0] mm_bridge_peripheral_m0_byteenable;                                // mm_bridge_peripheral:m0_byteenable -> mm_interconnect_1:mm_bridge_peripheral_m0_byteenable
	wire          mm_bridge_peripheral_m0_readdatavalid;                             // mm_interconnect_1:mm_bridge_peripheral_m0_readdatavalid -> mm_bridge_peripheral:m0_readdatavalid
	wire   [31:0] mm_bridge_peripheral_m0_writedata;                                 // mm_bridge_peripheral:m0_writedata -> mm_interconnect_1:mm_bridge_peripheral_m0_writedata
	wire          mm_bridge_peripheral_m0_write;                                     // mm_bridge_peripheral:m0_write -> mm_interconnect_1:mm_bridge_peripheral_m0_write
	wire    [0:0] mm_bridge_peripheral_m0_burstcount;                                // mm_bridge_peripheral:m0_burstcount -> mm_interconnect_1:mm_bridge_peripheral_m0_burstcount
	wire   [31:0] mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdata;      // intel_vvp_vfr:av_mm_control_agent_readdata -> mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_readdata
	wire          mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_waitrequest;   // intel_vvp_vfr:av_mm_control_agent_waitrequest -> mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_waitrequest
	wire    [7:0] mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_address;       // mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_address -> intel_vvp_vfr:av_mm_control_agent_address
	wire          mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_read;          // mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_read -> intel_vvp_vfr:av_mm_control_agent_read
	wire    [3:0] mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_byteenable;    // mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_byteenable -> intel_vvp_vfr:av_mm_control_agent_byteenable
	wire          mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdatavalid; // intel_vvp_vfr:av_mm_control_agent_readdatavalid -> mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_readdatavalid
	wire          mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_write;         // mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_write -> intel_vvp_vfr:av_mm_control_agent_write
	wire   [31:0] mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_writedata;     // mm_interconnect_1:intel_vvp_vfr_av_mm_control_agent_writedata -> intel_vvp_vfr:av_mm_control_agent_writedata
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect;          // mm_interconnect_1:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire   [31:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata;            // jtag_uart:av_readdata -> mm_interconnect_1:jtag_uart_avalon_jtag_slave_readdata
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest;         // jtag_uart:av_waitrequest -> mm_interconnect_1:jtag_uart_avalon_jtag_slave_waitrequest
	wire    [0:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_address;             // mm_interconnect_1:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_read;                // mm_interconnect_1:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire          mm_interconnect_1_jtag_uart_avalon_jtag_slave_write;               // mm_interconnect_1:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire   [31:0] mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata;           // mm_interconnect_1:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire    [7:0] mm_interconnect_1_terasic_sdcard_avalon_slave_readdata;            // terasic_sdcard:avs_readdata -> mm_interconnect_1:terasic_sdcard_avalon_slave_readdata
	wire   [11:0] mm_interconnect_1_terasic_sdcard_avalon_slave_address;             // mm_interconnect_1:terasic_sdcard_avalon_slave_address -> terasic_sdcard:avs_address
	wire          mm_interconnect_1_terasic_sdcard_avalon_slave_read;                // mm_interconnect_1:terasic_sdcard_avalon_slave_read -> terasic_sdcard:avs_read
	wire          mm_interconnect_1_terasic_sdcard_avalon_slave_write;               // mm_interconnect_1:terasic_sdcard_avalon_slave_write -> terasic_sdcard:avs_write
	wire    [7:0] mm_interconnect_1_terasic_sdcard_avalon_slave_writedata;           // mm_interconnect_1:terasic_sdcard_avalon_slave_writedata -> terasic_sdcard:avs_writedata
	wire   [31:0] mm_interconnect_1_sysid_qsys_control_slave_readdata;               // sysid_qsys:readdata -> mm_interconnect_1:sysid_qsys_control_slave_readdata
	wire    [0:0] mm_interconnect_1_sysid_qsys_control_slave_address;                // mm_interconnect_1:sysid_qsys_control_slave_address -> sysid_qsys:address
	wire          mm_interconnect_1_pio_sw_s1_chipselect;                            // mm_interconnect_1:pio_sw_s1_chipselect -> pio_sw:chipselect
	wire   [31:0] mm_interconnect_1_pio_sw_s1_readdata;                              // pio_sw:readdata -> mm_interconnect_1:pio_sw_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_sw_s1_address;                               // mm_interconnect_1:pio_sw_s1_address -> pio_sw:address
	wire          mm_interconnect_1_pio_sw_s1_write;                                 // mm_interconnect_1:pio_sw_s1_write -> pio_sw:write_n
	wire   [31:0] mm_interconnect_1_pio_sw_s1_writedata;                             // mm_interconnect_1:pio_sw_s1_writedata -> pio_sw:writedata
	wire          mm_interconnect_1_pio_led_s1_chipselect;                           // mm_interconnect_1:pio_led_s1_chipselect -> pio_led:chipselect
	wire   [31:0] mm_interconnect_1_pio_led_s1_readdata;                             // pio_led:readdata -> mm_interconnect_1:pio_led_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_led_s1_address;                              // mm_interconnect_1:pio_led_s1_address -> pio_led:address
	wire          mm_interconnect_1_pio_led_s1_write;                                // mm_interconnect_1:pio_led_s1_write -> pio_led:write_n
	wire   [31:0] mm_interconnect_1_pio_led_s1_writedata;                            // mm_interconnect_1:pio_led_s1_writedata -> pio_led:writedata
	wire          mm_interconnect_1_pio_key_s1_chipselect;                           // mm_interconnect_1:pio_key_s1_chipselect -> pio_key:chipselect
	wire   [31:0] mm_interconnect_1_pio_key_s1_readdata;                             // pio_key:readdata -> mm_interconnect_1:pio_key_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_key_s1_address;                              // mm_interconnect_1:pio_key_s1_address -> pio_key:address
	wire          mm_interconnect_1_pio_key_s1_write;                                // mm_interconnect_1:pio_key_s1_write -> pio_key:write_n
	wire   [31:0] mm_interconnect_1_pio_key_s1_writedata;                            // mm_interconnect_1:pio_key_s1_writedata -> pio_key:writedata
	wire          mm_interconnect_1_pio_fsync_out_s1_chipselect;                     // mm_interconnect_1:pio_fsync_out_s1_chipselect -> pio_fsync_out:chipselect
	wire   [31:0] mm_interconnect_1_pio_fsync_out_s1_readdata;                       // pio_fsync_out:readdata -> mm_interconnect_1:pio_fsync_out_s1_readdata
	wire    [1:0] mm_interconnect_1_pio_fsync_out_s1_address;                        // mm_interconnect_1:pio_fsync_out_s1_address -> pio_fsync_out:address
	wire          mm_interconnect_1_pio_fsync_out_s1_write;                          // mm_interconnect_1:pio_fsync_out_s1_write -> pio_fsync_out:write_n
	wire   [31:0] mm_interconnect_1_pio_fsync_out_s1_writedata;                      // mm_interconnect_1:pio_fsync_out_s1_writedata -> pio_fsync_out:writedata
	wire          irq_mapper_receiver0_irq;                                          // jtag_uart:av_irq -> irq_mapper:receiver0_irq
	wire          irq_mapper_receiver1_irq;                                          // pio_key:irq -> irq_mapper:receiver1_irq
	wire          irq_mapper_receiver2_irq;                                          // pio_sw:irq -> irq_mapper:receiver2_irq
	wire   [15:0] niosv_g_platform_irq_rx_irq;                                       // irq_mapper:sender_irq -> niosv_g:platform_irq_rx_irq
	wire          rst_controller_reset_out_reset;                                    // rst_controller:reset_out -> [intel_vvp_cvo:fr_reset_reset, intel_vvp_cvo:vid_reset_reset, intel_vvp_fr2cv:vid_reset_reset, intel_vvp_scaler:main_reset_reset, intel_vvp_vfr:main_reset_reset]
	wire          rst_controller_001_reset_out_reset;                                // rst_controller_001:reset_out -> [intel_vvp_vfr:control_reset_reset, intel_vvp_vfr:mem_reset_reset, mm_bridge_peripheral:reset, mm_interconnect_0:intel_vvp_vfr_mem_reset_reset_bridge_in_reset_reset, mm_interconnect_0:sdram_reset_sink_reset_bridge_in_reset_reset, mm_interconnect_1:jtag_uart_reset_reset_bridge_in_reset_reset, mm_interconnect_1:mm_bridge_peripheral_reset_reset_bridge_in_reset_reset]
	wire          rst_controller_002_reset_out_reset;                                // rst_controller_002:reset_out -> [jtag_uart:rst_n, onchip_memory:reset, pio_fsync_out:reset_n, pio_key:reset_n, pio_led:reset_n, pio_sw:reset_n, rst_translator:in_reset, sdram:rst_i, sysid_qsys:reset_n]
	wire          rst_controller_002_reset_out_reset_req;                            // rst_controller_002:reset_req -> [onchip_memory:reset_req, rst_translator:reset_req_in]
	wire          rst_controller_003_reset_out_reset;                                // rst_controller_003:reset_out -> [irq_mapper:reset, niosv_g:ndm_reset_in_reset, niosv_g:reset_reset]
	wire          niosv_g_dbg_reset_out_reset;                                       // niosv_g:dbg_reset_out_reset -> [rst_controller_003:reset_in0, rst_controller_006:reset_in0]
	wire          rst_controller_004_reset_out_reset;                                // rst_controller_004:reset_out -> reset_bridge:in_reset_n
	wire          reset_release_ninit_done_reset;                                    // reset_release:ninit_done -> rst_controller_004:reset_in0
	wire          reset_in_out_reset_reset;                                          // reset_in:out_reset_n -> rst_controller_004:reset_in1
	wire          rst_controller_005_reset_out_reset;                                // rst_controller_005:reset_out -> terasic_sdcard:reset_n
	wire          rst_controller_006_reset_out_reset;                                // rst_controller_006:reset_out -> [mm_interconnect_0:niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset_reset, mm_interconnect_0:niosv_g_reset_reset_bridge_in_reset_reset]
	wire          rst_controller_007_reset_out_reset;                                // rst_controller_007:reset_out -> [mm_interconnect_1:terasic_sdcard_avalon_slave_translator_reset_reset_bridge_in_reset_reset, mm_interconnect_1:terasic_sdcard_reset_reset_bridge_in_reset_reset]

	clock_in clock_in (
		.in_clk  (clk_clk),              //   input,  width = 1,  in_clk.clk
		.out_clk (clock_in_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	nios_system_intel_vvp_cvo_0 intel_vvp_cvo (
		.axi4s_vid_in_tdata           (intel_vvp_scaler_axi4s_vid_out_tdata),       //   input,  width = 24,     axi4s_vid_in.tdata
		.axi4s_vid_in_tvalid          (intel_vvp_scaler_axi4s_vid_out_tvalid),      //   input,   width = 1,                 .tvalid
		.axi4s_vid_in_tready          (intel_vvp_scaler_axi4s_vid_out_tready),      //  output,   width = 1,                 .tready
		.axi4s_vid_in_tlast           (intel_vvp_scaler_axi4s_vid_out_tlast),       //   input,   width = 1,                 .tlast
		.axi4s_vid_in_tuser           (intel_vvp_scaler_axi4s_vid_out_tuser),       //   input,   width = 3,                 .tuser
		.axi4s_fr_vid_out_tdata       (intel_vvp_cvo_axi4s_fr_vid_out_tdata),       //  output,  width = 32, axi4s_fr_vid_out.tdata
		.axi4s_fr_vid_out_tvalid      (intel_vvp_cvo_axi4s_fr_vid_out_tvalid),      //  output,   width = 1,                 .tvalid
		.axi4s_fr_vid_out_tready      (intel_vvp_cvo_axi4s_fr_vid_out_tready),      //   input,   width = 1,                 .tready
		.axi4s_fr_vid_out_tlast       (intel_vvp_cvo_axi4s_fr_vid_out_tlast),       //  output,   width = 1,                 .tlast
		.axi4s_fr_vid_out_tuser       (intel_vvp_cvo_axi4s_fr_vid_out_tuser),       //  output,   width = 4,                 .tuser
		.vid_status_vid_locked        (intel_vvp_cvo_vid_status_vid_locked),        //  output,   width = 1,       vid_status.vid_locked
		.vid_status_vid_is_full       (intel_vvp_cvo_vid_status_vid_is_full),       //  output,   width = 1,                 .vid_is_full
		.vid_status_vid_stall_error   (intel_vvp_cvo_vid_status_vid_stall_error),   //  output,   width = 1,                 .vid_stall_error
		.vid_status_vid_size_mismatch (intel_vvp_cvo_vid_status_vid_size_mismatch), //  output,   width = 1,                 .vid_size_mismatch
		.frame_start_conduit          (intel_vvp_cvo_frame_start_conduit),          //   input,   width = 1,      frame_start.conduit
		.fr_clock_clk                 (iopll_vga_outclk0_clk),                      //   input,   width = 1,         fr_clock.clk
		.fr_reset_reset               (rst_controller_reset_out_reset),             //   input,   width = 1,         fr_reset.reset
		.vid_clock_clk                (iopll_vga_outclk0_clk),                      //   input,   width = 1,        vid_clock.clk
		.vid_reset_reset              (rst_controller_reset_out_reset)              //   input,   width = 1,        vid_reset.reset
	);

	nios_system_intel_vvp_fr2cv_0 intel_vvp_fr2cv (
		.cv_clk_out_clk           (intel_vvp_fr2cv_cv_clk_out_clk),           //  output,   width = 1,      cv_clk_out.clk
		.cv_vid_out_vid_data      (intel_vvp_fr2cv_cv_vid_out_vid_data),      //  output,  width = 24,      cv_vid_out.vid_data
		.cv_vid_out_underflow     (intel_vvp_fr2cv_cv_vid_out_underflow),     //  output,   width = 1,                .underflow
		.cv_vid_out_vid_datavalid (intel_vvp_fr2cv_cv_vid_out_vid_datavalid), //  output,   width = 1,                .vid_datavalid
		.cv_vid_out_vid_v_sync    (intel_vvp_fr2cv_cv_vid_out_vid_v_sync),    //  output,   width = 1,                .vid_v_sync
		.cv_vid_out_vid_h_sync    (intel_vvp_fr2cv_cv_vid_out_vid_h_sync),    //  output,   width = 1,                .vid_h_sync
		.cv_vid_out_vid_f         (intel_vvp_fr2cv_cv_vid_out_vid_f),         //  output,   width = 1,                .vid_f
		.cv_vid_out_vid_h         (intel_vvp_fr2cv_cv_vid_out_vid_h),         //  output,   width = 1,                .vid_h
		.cv_vid_out_vid_v         (intel_vvp_fr2cv_cv_vid_out_vid_v),         //  output,   width = 1,                .vid_v
		.axi4s_fr_vid_in_tdata    (intel_vvp_cvo_axi4s_fr_vid_out_tdata),     //   input,  width = 32, axi4s_fr_vid_in.tdata
		.axi4s_fr_vid_in_tvalid   (intel_vvp_cvo_axi4s_fr_vid_out_tvalid),    //   input,   width = 1,                .tvalid
		.axi4s_fr_vid_in_tready   (intel_vvp_cvo_axi4s_fr_vid_out_tready),    //  output,   width = 1,                .tready
		.axi4s_fr_vid_in_tlast    (intel_vvp_cvo_axi4s_fr_vid_out_tlast),     //   input,   width = 1,                .tlast
		.axi4s_fr_vid_in_tuser    (intel_vvp_cvo_axi4s_fr_vid_out_tuser),     //   input,   width = 4,                .tuser
		.vid_clock_clk            (iopll_vga_outclk0_clk),                    //   input,   width = 1,       vid_clock.clk
		.vid_reset_reset          (rst_controller_reset_out_reset)            //   input,   width = 1,       vid_reset.reset
	);

	nios_system_intel_vvp_scaler_1 intel_vvp_scaler (
		.main_clock_clk       (iopll_vga_outclk0_clk),                 //   input,   width = 1,    main_clock.clk
		.main_reset_reset     (rst_controller_reset_out_reset),        //   input,   width = 1,    main_reset.reset
		.axi4s_vid_in_tdata   (intel_vvp_vfr_axi4s_vid_out_tdata),     //   input,  width = 24,  axi4s_vid_in.tdata
		.axi4s_vid_in_tvalid  (intel_vvp_vfr_axi4s_vid_out_tvalid),    //   input,   width = 1,              .tvalid
		.axi4s_vid_in_tready  (intel_vvp_vfr_axi4s_vid_out_tready),    //  output,   width = 1,              .tready
		.axi4s_vid_in_tlast   (intel_vvp_vfr_axi4s_vid_out_tlast),     //   input,   width = 1,              .tlast
		.axi4s_vid_in_tuser   (intel_vvp_vfr_axi4s_vid_out_tuser),     //   input,   width = 3,              .tuser
		.axi4s_vid_out_tdata  (intel_vvp_scaler_axi4s_vid_out_tdata),  //  output,  width = 24, axi4s_vid_out.tdata
		.axi4s_vid_out_tvalid (intel_vvp_scaler_axi4s_vid_out_tvalid), //  output,   width = 1,              .tvalid
		.axi4s_vid_out_tready (intel_vvp_scaler_axi4s_vid_out_tready), //   input,   width = 1,              .tready
		.axi4s_vid_out_tlast  (intel_vvp_scaler_axi4s_vid_out_tlast),  //  output,   width = 1,              .tlast
		.axi4s_vid_out_tuser  (intel_vvp_scaler_axi4s_vid_out_tuser)   //  output,   width = 3,              .tuser
	);

	nios_system_intel_vvp_vfr_0 intel_vvp_vfr (
		.main_clock_clk                    (iopll_vga_outclk0_clk),                                             //   input,    width = 1,          main_clock.clk
		.main_reset_reset                  (rst_controller_reset_out_reset),                                    //   input,    width = 1,          main_reset.reset
		.mem_clock_clk                     (iopll_outclk0_clk),                                                 //   input,    width = 1,           mem_clock.clk
		.mem_reset_reset                   (rst_controller_001_reset_out_reset),                                //   input,    width = 1,           mem_reset.reset
		.axi4s_vid_out_tdata               (intel_vvp_vfr_axi4s_vid_out_tdata),                                 //  output,   width = 24,       axi4s_vid_out.tdata
		.axi4s_vid_out_tvalid              (intel_vvp_vfr_axi4s_vid_out_tvalid),                                //  output,    width = 1,                    .tvalid
		.axi4s_vid_out_tready              (intel_vvp_vfr_axi4s_vid_out_tready),                                //   input,    width = 1,                    .tready
		.axi4s_vid_out_tlast               (intel_vvp_vfr_axi4s_vid_out_tlast),                                 //  output,    width = 1,                    .tlast
		.axi4s_vid_out_tuser               (intel_vvp_vfr_axi4s_vid_out_tuser),                                 //  output,    width = 3,                    .tuser
		.fsync_in_read                     (intel_vvp_vfr_fsync_in_read),                                       //   input,    width = 1,            fsync_in.read
		.frame_reader_int_irq              (),                                                                  //  output,    width = 1,    frame_reader_int.irq
		.av_mm_mem_read_host_address       (intel_vvp_vfr_av_mm_mem_read_host_address),                         //  output,   width = 32, av_mm_mem_read_host.address
		.av_mm_mem_read_host_waitrequest   (intel_vvp_vfr_av_mm_mem_read_host_waitrequest),                     //   input,    width = 1,                    .waitrequest
		.av_mm_mem_read_host_burstcount    (intel_vvp_vfr_av_mm_mem_read_host_burstcount),                      //  output,    width = 6,                    .burstcount
		.av_mm_mem_read_host_read          (intel_vvp_vfr_av_mm_mem_read_host_read),                            //  output,    width = 1,                    .read
		.av_mm_mem_read_host_readdata      (intel_vvp_vfr_av_mm_mem_read_host_readdata),                        //   input,  width = 256,                    .readdata
		.av_mm_mem_read_host_readdatavalid (intel_vvp_vfr_av_mm_mem_read_host_readdatavalid),                   //   input,    width = 1,                    .readdatavalid
		.av_mm_control_agent_address       (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_address),       //   input,    width = 8, av_mm_control_agent.address
		.av_mm_control_agent_write         (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_write),         //   input,    width = 1,                    .write
		.av_mm_control_agent_byteenable    (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_byteenable),    //   input,    width = 4,                    .byteenable
		.av_mm_control_agent_writedata     (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_writedata),     //   input,   width = 32,                    .writedata
		.av_mm_control_agent_read          (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_read),          //   input,    width = 1,                    .read
		.av_mm_control_agent_readdata      (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdata),      //  output,   width = 32,                    .readdata
		.av_mm_control_agent_readdatavalid (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdatavalid), //  output,    width = 1,                    .readdatavalid
		.av_mm_control_agent_waitrequest   (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_waitrequest),   //  output,    width = 1,                    .waitrequest
		.control_clock_clk                 (iopll_outclk0_clk),                                                 //   input,    width = 1,       control_clock.clk
		.control_reset_reset               (rst_controller_001_reset_out_reset)                                 //   input,    width = 1,       control_reset.reset
	);

	iopll iopll (
		.refclk   (clock_in_out_clk_clk),          //   input,  width = 1,  refclk.clk
		.rst      (~reset_bridge_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (iopll_outclk0_clk),             //  output,  width = 1, outclk0.clk
		.outclk_1 (sdram_clk_clk),                 //  output,  width = 1, outclk1.clk
		.outclk_2 (iopll_outclk2_clk),             //  output,  width = 1, outclk2.clk
		.outclk_3 (iopll_outclk3_clk)              //  output,  width = 1, outclk3.clk
	);

	nios_system_iopll_0 iopll_vga (
		.refclk   (clock_in_out_clk_clk),          //   input,  width = 1,  refclk.clk
		.locked   (),                              //  output,  width = 1,  locked.export
		.rst      (~reset_bridge_out_reset_reset), //   input,  width = 1,   reset.reset
		.outclk_0 (iopll_vga_outclk0_clk),         //  output,  width = 1, outclk0.clk
		.outclk_1 (iopll_vga_outclk1_clk)          //  output,  width = 1, outclk1.clk
	);

	jtag_uart jtag_uart (
		.clk            (iopll_outclk0_clk),                                         //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_002_reset_out_reset),                       //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_1_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_1_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_1_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver0_irq)                                   //  output,   width = 1,               irq.irq
	);

	mm_bridge_peripheral mm_bridge_peripheral (
		.clk              (iopll_outclk0_clk),                                       //   input,   width = 1,   clk.clk
		.reset            (rst_controller_001_reset_out_reset),                      //   input,   width = 1, reset.reset
		.s0_waitrequest   (mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest),   //  output,   width = 1,    s0.waitrequest
		.s0_readdata      (mm_interconnect_0_mm_bridge_peripheral_s0_readdata),      //  output,  width = 32,      .readdata
		.s0_readdatavalid (mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid), //  output,   width = 1,      .readdatavalid
		.s0_burstcount    (mm_interconnect_0_mm_bridge_peripheral_s0_burstcount),    //   input,   width = 1,      .burstcount
		.s0_writedata     (mm_interconnect_0_mm_bridge_peripheral_s0_writedata),     //   input,  width = 32,      .writedata
		.s0_address       (mm_interconnect_0_mm_bridge_peripheral_s0_address),       //   input,  width = 18,      .address
		.s0_write         (mm_interconnect_0_mm_bridge_peripheral_s0_write),         //   input,   width = 1,      .write
		.s0_read          (mm_interconnect_0_mm_bridge_peripheral_s0_read),          //   input,   width = 1,      .read
		.s0_byteenable    (mm_interconnect_0_mm_bridge_peripheral_s0_byteenable),    //   input,   width = 4,      .byteenable
		.s0_debugaccess   (mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess),   //   input,   width = 1,      .debugaccess
		.m0_waitrequest   (mm_bridge_peripheral_m0_waitrequest),                     //   input,   width = 1,    m0.waitrequest
		.m0_readdata      (mm_bridge_peripheral_m0_readdata),                        //   input,  width = 32,      .readdata
		.m0_readdatavalid (mm_bridge_peripheral_m0_readdatavalid),                   //   input,   width = 1,      .readdatavalid
		.m0_burstcount    (mm_bridge_peripheral_m0_burstcount),                      //  output,   width = 1,      .burstcount
		.m0_writedata     (mm_bridge_peripheral_m0_writedata),                       //  output,  width = 32,      .writedata
		.m0_address       (mm_bridge_peripheral_m0_address),                         //  output,  width = 18,      .address
		.m0_write         (mm_bridge_peripheral_m0_write),                           //  output,   width = 1,      .write
		.m0_read          (mm_bridge_peripheral_m0_read),                            //  output,   width = 1,      .read
		.m0_byteenable    (mm_bridge_peripheral_m0_byteenable),                      //  output,   width = 4,      .byteenable
		.m0_debugaccess   (mm_bridge_peripheral_m0_debugaccess)                      //  output,   width = 1,      .debugaccess
	);

	niosv_g niosv_g (
		.clk                          (iopll_outclk0_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_003_reset_out_reset),                     //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (niosv_g_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awsize   (niosv_g_instruction_manager_awsize),                     //  output,   width = 3, instruction_manager.awsize
		.instruction_manager_awlen    (niosv_g_instruction_manager_awlen),                      //  output,   width = 8,                    .awlen
		.instruction_manager_awburst  (niosv_g_instruction_manager_awburst),                    //  output,   width = 2,                    .awburst
		.instruction_manager_wlast    (niosv_g_instruction_manager_wlast),                      //  output,   width = 1,                    .wlast
		.instruction_manager_arsize   (niosv_g_instruction_manager_arsize),                     //  output,   width = 3,                    .arsize
		.instruction_manager_arlen    (niosv_g_instruction_manager_arlen),                      //  output,   width = 8,                    .arlen
		.instruction_manager_arburst  (niosv_g_instruction_manager_arburst),                    //  output,   width = 2,                    .arburst
		.instruction_manager_rlast    (niosv_g_instruction_manager_rlast),                      //   input,   width = 1,                    .rlast
		.instruction_manager_awaddr   (niosv_g_instruction_manager_awaddr),                     //  output,  width = 32,                    .awaddr
		.instruction_manager_awprot   (niosv_g_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (niosv_g_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awready  (niosv_g_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (niosv_g_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (niosv_g_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wvalid   (niosv_g_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (niosv_g_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (niosv_g_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (niosv_g_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (niosv_g_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (niosv_g_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arprot   (niosv_g_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (niosv_g_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arready  (niosv_g_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (niosv_g_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (niosv_g_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rvalid   (niosv_g_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (niosv_g_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.data_manager_awsize          (niosv_g_data_manager_awsize),                            //  output,   width = 3,        data_manager.awsize
		.data_manager_awlen           (niosv_g_data_manager_awlen),                             //  output,   width = 8,                    .awlen
		.data_manager_wlast           (niosv_g_data_manager_wlast),                             //  output,   width = 1,                    .wlast
		.data_manager_arsize          (niosv_g_data_manager_arsize),                            //  output,   width = 3,                    .arsize
		.data_manager_arlen           (niosv_g_data_manager_arlen),                             //  output,   width = 8,                    .arlen
		.data_manager_rlast           (niosv_g_data_manager_rlast),                             //   input,   width = 1,                    .rlast
		.data_manager_awaddr          (niosv_g_data_manager_awaddr),                            //  output,  width = 32,                    .awaddr
		.data_manager_awprot          (niosv_g_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (niosv_g_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (niosv_g_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (niosv_g_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (niosv_g_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wvalid          (niosv_g_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (niosv_g_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (niosv_g_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (niosv_g_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (niosv_g_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (niosv_g_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arprot          (niosv_g_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (niosv_g_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (niosv_g_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (niosv_g_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (niosv_g_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rvalid          (niosv_g_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rready          (niosv_g_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_address       (mm_interconnect_0_niosv_g_timer_sw_agent_address),       //   input,   width = 6,      timer_sw_agent.address
		.timer_sw_agent_byteenable    (mm_interconnect_0_niosv_g_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_read          (mm_interconnect_0_niosv_g_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_niosv_g_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_write         (mm_interconnect_0_niosv_g_timer_sw_agent_write),         //   input,   width = 1,                    .write
		.timer_sw_agent_writedata     (mm_interconnect_0_niosv_g_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_waitrequest   (mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.timer_sw_agent_readdatavalid (mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.dm_agent_address             (mm_interconnect_0_niosv_g_dm_agent_address),             //   input,  width = 16,            dm_agent.address
		.dm_agent_read                (mm_interconnect_0_niosv_g_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_niosv_g_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_write               (mm_interconnect_0_niosv_g_dm_agent_write),               //   input,   width = 1,                    .write
		.dm_agent_writedata           (mm_interconnect_0_niosv_g_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_waitrequest         (mm_interconnect_0_niosv_g_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dm_agent_readdatavalid       (mm_interconnect_0_niosv_g_dm_agent_readdatavalid),       //  output,   width = 1,                    .readdatavalid
		.dbg_reset_out_reset          (niosv_g_dbg_reset_out_reset),                            //  output,   width = 1,       dbg_reset_out.reset
		.ndm_reset_in_reset           (rst_controller_003_reset_out_reset)                      //   input,   width = 1,        ndm_reset_in.reset
	);

	onchip_memory onchip_memory (
		.clk        (iopll_outclk0_clk),                             //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_onchip_memory_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_onchip_memory_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_onchip_memory_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_onchip_memory_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_onchip_memory_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_onchip_memory_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_002_reset_out_reset),            //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_002_reset_out_reset_req)         //   input,   width = 1,       .reset_req
	);

	nios_system_pio_0 pio_fsync_out (
		.clk        (iopll_outclk0_clk),                             //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_002_reset_out_reset),           //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_fsync_out_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_fsync_out_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_fsync_out_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_fsync_out_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_fsync_out_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_fsync_out_external_connection_export)       //  output,   width = 1, external_connection.export
	);

	pio_key pio_key (
		.clk        (iopll_outclk0_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_002_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_key_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_key_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_key_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_key_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_key_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (key_external_connection_export),          //   input,   width = 2, external_connection.export
		.irq        (irq_mapper_receiver1_irq)                 //  output,   width = 1,                 irq.irq
	);

	pio_led pio_led (
		.clk        (iopll_outclk0_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_002_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_led_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_led_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_led_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_led_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_led_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (led_external_connection_export)           //  output,   width = 4, external_connection.export
	);

	pio_sw pio_sw (
		.clk        (iopll_outclk0_clk),                      //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_002_reset_out_reset),    //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_1_pio_sw_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_1_pio_sw_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_1_pio_sw_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_1_pio_sw_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_1_pio_sw_s1_readdata),   //  output,  width = 32,                    .readdata
		.in_port    (sw_external_connection_export),          //   input,   width = 2, external_connection.export
		.irq        (irq_mapper_receiver2_irq)                //  output,   width = 1,                 irq.irq
	);

	reset_bridge reset_bridge (
		.clk         (clock_in_out_clk_clk),                //   input,  width = 1,       clk.clk
		.in_reset_n  (~rst_controller_004_reset_out_reset), //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_bridge_out_reset_reset)         //  output,  width = 1, out_reset.reset_n
	);

	reset_in reset_in (
		.clk         (clock_in_out_clk_clk),     //   input,  width = 1,       clk.clk
		.in_reset_n  (reset_reset_n),            //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (reset_in_out_reset_reset)  //  output,  width = 1, out_reset.reset_n
	);

	reset_release reset_release (
		.ninit_done (reset_release_ninit_done_reset)  //  output,  width = 1, ninit_done.reset
	);

	core_sdram_axi4 sdram (
		.sdram_cke_o         (sdram_cke),                                  //  output,   width = 1,             sdram.cke
		.sdram_cs_o          (sdram_cs_n),                                 //  output,   width = 1,                  .cs_n
		.sdram_ras_o         (sdram_ras_n),                                //  output,   width = 1,                  .ras_n
		.sdram_cas_o         (sdram_cas_n),                                //  output,   width = 1,                  .cas_n
		.sdram_we_o          (sdram_we_n),                                 //  output,   width = 1,                  .we_n
		.sdram_dqm_o         (sdram_dqm),                                  //  output,   width = 4,                  .dqm
		.sdram_addr_o        (sdram_addr),                                 //  output,  width = 13,                  .addr
		.sdram_ba_o          (sdram_ba),                                   //  output,   width = 2,                  .ba
		.sdram_data_output_o (sdram_data_out),                             //  output,  width = 32,                  .data_out
		.sdram_data_out_en_o (sdram_data_oe),                              //  output,   width = 1,                  .data_oe
		.sdram_data_input_i  (sdram_data_in),                              //   input,  width = 32,                  .data_in
		.clk_i               (iopll_outclk0_clk),                          //   input,   width = 1,        clock_sink.clk
		.clk_sample_i        (iopll_outclk2_clk),                          //   input,   width = 1, clock_sample_sink.clk
		.rst_i               (rst_controller_002_reset_out_reset),         //   input,   width = 1,        reset_sink.reset
		.inport_awvalid_i    (mm_interconnect_0_sdram_axi4_slave_awvalid), //   input,   width = 1,        axi4_slave.awvalid
		.inport_awaddr_i     (mm_interconnect_0_sdram_axi4_slave_awaddr),  //   input,  width = 26,                  .awaddr
		.inport_awid_i       (mm_interconnect_0_sdram_axi4_slave_awid),    //   input,   width = 4,                  .awid
		.inport_awlen_i      (mm_interconnect_0_sdram_axi4_slave_awlen),   //   input,   width = 8,                  .awlen
		.inport_awburst_i    (mm_interconnect_0_sdram_axi4_slave_awburst), //   input,   width = 2,                  .awburst
		.inport_wvalid_i     (mm_interconnect_0_sdram_axi4_slave_wvalid),  //   input,   width = 1,                  .wvalid
		.inport_wdata_i      (mm_interconnect_0_sdram_axi4_slave_wdata),   //   input,  width = 64,                  .wdata
		.inport_wstrb_i      (mm_interconnect_0_sdram_axi4_slave_wstrb),   //   input,   width = 8,                  .wstrb
		.inport_wlast_i      (mm_interconnect_0_sdram_axi4_slave_wlast),   //   input,   width = 1,                  .wlast
		.inport_bready_i     (mm_interconnect_0_sdram_axi4_slave_bready),  //   input,   width = 1,                  .bready
		.inport_arvalid_i    (mm_interconnect_0_sdram_axi4_slave_arvalid), //   input,   width = 1,                  .arvalid
		.inport_araddr_i     (mm_interconnect_0_sdram_axi4_slave_araddr),  //   input,  width = 26,                  .araddr
		.inport_arid_i       (mm_interconnect_0_sdram_axi4_slave_arid),    //   input,   width = 4,                  .arid
		.inport_arlen_i      (mm_interconnect_0_sdram_axi4_slave_arlen),   //   input,   width = 8,                  .arlen
		.inport_arburst_i    (mm_interconnect_0_sdram_axi4_slave_arburst), //   input,   width = 2,                  .arburst
		.inport_rready_i     (mm_interconnect_0_sdram_axi4_slave_rready),  //   input,   width = 1,                  .rready
		.inport_awready_o    (mm_interconnect_0_sdram_axi4_slave_awready), //  output,   width = 1,                  .awready
		.inport_wready_o     (mm_interconnect_0_sdram_axi4_slave_wready),  //  output,   width = 1,                  .wready
		.inport_bvalid_o     (mm_interconnect_0_sdram_axi4_slave_bvalid),  //  output,   width = 1,                  .bvalid
		.inport_bresp_o      (mm_interconnect_0_sdram_axi4_slave_bresp),   //  output,   width = 2,                  .bresp
		.inport_bid_o        (mm_interconnect_0_sdram_axi4_slave_bid),     //  output,   width = 4,                  .bid
		.inport_arready_o    (mm_interconnect_0_sdram_axi4_slave_arready), //  output,   width = 1,                  .arready
		.inport_rvalid_o     (mm_interconnect_0_sdram_axi4_slave_rvalid),  //  output,   width = 1,                  .rvalid
		.inport_rdata_o      (mm_interconnect_0_sdram_axi4_slave_rdata),   //  output,  width = 64,                  .rdata
		.inport_rresp_o      (mm_interconnect_0_sdram_axi4_slave_rresp),   //  output,   width = 2,                  .rresp
		.inport_rid_o        (mm_interconnect_0_sdram_axi4_slave_rid),     //  output,   width = 4,                  .rid
		.inport_rlast_o      (mm_interconnect_0_sdram_axi4_slave_rlast),   //  output,   width = 1,                  .rlast
		.inport_awsize_i     (mm_interconnect_0_sdram_axi4_slave_awsize),  //   input,   width = 3,                  .awsize
		.inport_arsize_i     (mm_interconnect_0_sdram_axi4_slave_arsize)   //   input,   width = 3,                  .arsize
	);

	sysid_qsys sysid_qsys (
		.clock    (iopll_outclk0_clk),                                   //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_002_reset_out_reset),                 //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_1_sysid_qsys_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_1_sysid_qsys_control_slave_address)   //   input,   width = 1,              .address
	);

	nios_system_terasic_sdio_0 terasic_sdcard (
		.clk           (iopll_outclk3_clk),                                       //   input,   width = 1,        clock.clk
		.reset_n       (~rst_controller_005_reset_out_reset),                     //   input,   width = 1,        reset.reset_n
		.avs_address   (mm_interconnect_1_terasic_sdcard_avalon_slave_address),   //   input,  width = 12, avalon_slave.address
		.avs_write     (mm_interconnect_1_terasic_sdcard_avalon_slave_write),     //   input,   width = 1,             .write
		.avs_read      (mm_interconnect_1_terasic_sdcard_avalon_slave_read),      //   input,   width = 1,             .read
		.avs_writedata (mm_interconnect_1_terasic_sdcard_avalon_slave_writedata), //   input,   width = 8,             .writedata
		.avs_readdata  (mm_interconnect_1_terasic_sdcard_avalon_slave_readdata),  //  output,   width = 8,             .readdata
		.sd_clk        (terasic_sdcard_conduit_end_sd_clk),                       //  output,   width = 1,  conduit_end.sd_clk
		.sd_cmd        (terasic_sdcard_conduit_end_sd_cmd),                       //   inout,   width = 1,             .sd_cmd
		.sd_data       (terasic_sdcard_conduit_end_sd_data)                       //   inout,   width = 4,             .sd_data
	);

	nios_system_altera_mm_interconnect_1920_7lp6uta mm_interconnect_0 (
		.intel_vvp_vfr_av_mm_mem_read_host_address                             (intel_vvp_vfr_av_mm_mem_read_host_address),               //   input,   width = 32,                               intel_vvp_vfr_av_mm_mem_read_host.address
		.intel_vvp_vfr_av_mm_mem_read_host_waitrequest                         (intel_vvp_vfr_av_mm_mem_read_host_waitrequest),           //  output,    width = 1,                                                                .waitrequest
		.intel_vvp_vfr_av_mm_mem_read_host_burstcount                          (intel_vvp_vfr_av_mm_mem_read_host_burstcount),            //   input,    width = 6,                                                                .burstcount
		.intel_vvp_vfr_av_mm_mem_read_host_read                                (intel_vvp_vfr_av_mm_mem_read_host_read),                  //   input,    width = 1,                                                                .read
		.intel_vvp_vfr_av_mm_mem_read_host_readdata                            (intel_vvp_vfr_av_mm_mem_read_host_readdata),              //  output,  width = 256,                                                                .readdata
		.intel_vvp_vfr_av_mm_mem_read_host_readdatavalid                       (intel_vvp_vfr_av_mm_mem_read_host_readdatavalid),         //  output,    width = 1,                                                                .readdatavalid
		.niosv_g_data_manager_awaddr                                           (niosv_g_data_manager_awaddr),                             //   input,   width = 32,                                            niosv_g_data_manager.awaddr
		.niosv_g_data_manager_awlen                                            (niosv_g_data_manager_awlen),                              //   input,    width = 8,                                                                .awlen
		.niosv_g_data_manager_awsize                                           (niosv_g_data_manager_awsize),                             //   input,    width = 3,                                                                .awsize
		.niosv_g_data_manager_awprot                                           (niosv_g_data_manager_awprot),                             //   input,    width = 3,                                                                .awprot
		.niosv_g_data_manager_awvalid                                          (niosv_g_data_manager_awvalid),                            //   input,    width = 1,                                                                .awvalid
		.niosv_g_data_manager_awready                                          (niosv_g_data_manager_awready),                            //  output,    width = 1,                                                                .awready
		.niosv_g_data_manager_wdata                                            (niosv_g_data_manager_wdata),                              //   input,   width = 32,                                                                .wdata
		.niosv_g_data_manager_wstrb                                            (niosv_g_data_manager_wstrb),                              //   input,    width = 4,                                                                .wstrb
		.niosv_g_data_manager_wlast                                            (niosv_g_data_manager_wlast),                              //   input,    width = 1,                                                                .wlast
		.niosv_g_data_manager_wvalid                                           (niosv_g_data_manager_wvalid),                             //   input,    width = 1,                                                                .wvalid
		.niosv_g_data_manager_wready                                           (niosv_g_data_manager_wready),                             //  output,    width = 1,                                                                .wready
		.niosv_g_data_manager_bresp                                            (niosv_g_data_manager_bresp),                              //  output,    width = 2,                                                                .bresp
		.niosv_g_data_manager_bvalid                                           (niosv_g_data_manager_bvalid),                             //  output,    width = 1,                                                                .bvalid
		.niosv_g_data_manager_bready                                           (niosv_g_data_manager_bready),                             //   input,    width = 1,                                                                .bready
		.niosv_g_data_manager_araddr                                           (niosv_g_data_manager_araddr),                             //   input,   width = 32,                                                                .araddr
		.niosv_g_data_manager_arlen                                            (niosv_g_data_manager_arlen),                              //   input,    width = 8,                                                                .arlen
		.niosv_g_data_manager_arsize                                           (niosv_g_data_manager_arsize),                             //   input,    width = 3,                                                                .arsize
		.niosv_g_data_manager_arprot                                           (niosv_g_data_manager_arprot),                             //   input,    width = 3,                                                                .arprot
		.niosv_g_data_manager_arvalid                                          (niosv_g_data_manager_arvalid),                            //   input,    width = 1,                                                                .arvalid
		.niosv_g_data_manager_arready                                          (niosv_g_data_manager_arready),                            //  output,    width = 1,                                                                .arready
		.niosv_g_data_manager_rdata                                            (niosv_g_data_manager_rdata),                              //  output,   width = 32,                                                                .rdata
		.niosv_g_data_manager_rresp                                            (niosv_g_data_manager_rresp),                              //  output,    width = 2,                                                                .rresp
		.niosv_g_data_manager_rlast                                            (niosv_g_data_manager_rlast),                              //  output,    width = 1,                                                                .rlast
		.niosv_g_data_manager_rvalid                                           (niosv_g_data_manager_rvalid),                             //  output,    width = 1,                                                                .rvalid
		.niosv_g_data_manager_rready                                           (niosv_g_data_manager_rready),                             //   input,    width = 1,                                                                .rready
		.niosv_g_instruction_manager_awaddr                                    (niosv_g_instruction_manager_awaddr),                      //   input,   width = 32,                                     niosv_g_instruction_manager.awaddr
		.niosv_g_instruction_manager_awlen                                     (niosv_g_instruction_manager_awlen),                       //   input,    width = 8,                                                                .awlen
		.niosv_g_instruction_manager_awsize                                    (niosv_g_instruction_manager_awsize),                      //   input,    width = 3,                                                                .awsize
		.niosv_g_instruction_manager_awburst                                   (niosv_g_instruction_manager_awburst),                     //   input,    width = 2,                                                                .awburst
		.niosv_g_instruction_manager_awprot                                    (niosv_g_instruction_manager_awprot),                      //   input,    width = 3,                                                                .awprot
		.niosv_g_instruction_manager_awvalid                                   (niosv_g_instruction_manager_awvalid),                     //   input,    width = 1,                                                                .awvalid
		.niosv_g_instruction_manager_awready                                   (niosv_g_instruction_manager_awready),                     //  output,    width = 1,                                                                .awready
		.niosv_g_instruction_manager_wdata                                     (niosv_g_instruction_manager_wdata),                       //   input,   width = 32,                                                                .wdata
		.niosv_g_instruction_manager_wstrb                                     (niosv_g_instruction_manager_wstrb),                       //   input,    width = 4,                                                                .wstrb
		.niosv_g_instruction_manager_wlast                                     (niosv_g_instruction_manager_wlast),                       //   input,    width = 1,                                                                .wlast
		.niosv_g_instruction_manager_wvalid                                    (niosv_g_instruction_manager_wvalid),                      //   input,    width = 1,                                                                .wvalid
		.niosv_g_instruction_manager_wready                                    (niosv_g_instruction_manager_wready),                      //  output,    width = 1,                                                                .wready
		.niosv_g_instruction_manager_bresp                                     (niosv_g_instruction_manager_bresp),                       //  output,    width = 2,                                                                .bresp
		.niosv_g_instruction_manager_bvalid                                    (niosv_g_instruction_manager_bvalid),                      //  output,    width = 1,                                                                .bvalid
		.niosv_g_instruction_manager_bready                                    (niosv_g_instruction_manager_bready),                      //   input,    width = 1,                                                                .bready
		.niosv_g_instruction_manager_araddr                                    (niosv_g_instruction_manager_araddr),                      //   input,   width = 32,                                                                .araddr
		.niosv_g_instruction_manager_arlen                                     (niosv_g_instruction_manager_arlen),                       //   input,    width = 8,                                                                .arlen
		.niosv_g_instruction_manager_arsize                                    (niosv_g_instruction_manager_arsize),                      //   input,    width = 3,                                                                .arsize
		.niosv_g_instruction_manager_arburst                                   (niosv_g_instruction_manager_arburst),                     //   input,    width = 2,                                                                .arburst
		.niosv_g_instruction_manager_arprot                                    (niosv_g_instruction_manager_arprot),                      //   input,    width = 3,                                                                .arprot
		.niosv_g_instruction_manager_arvalid                                   (niosv_g_instruction_manager_arvalid),                     //   input,    width = 1,                                                                .arvalid
		.niosv_g_instruction_manager_arready                                   (niosv_g_instruction_manager_arready),                     //  output,    width = 1,                                                                .arready
		.niosv_g_instruction_manager_rdata                                     (niosv_g_instruction_manager_rdata),                       //  output,   width = 32,                                                                .rdata
		.niosv_g_instruction_manager_rresp                                     (niosv_g_instruction_manager_rresp),                       //  output,    width = 2,                                                                .rresp
		.niosv_g_instruction_manager_rlast                                     (niosv_g_instruction_manager_rlast),                       //  output,    width = 1,                                                                .rlast
		.niosv_g_instruction_manager_rvalid                                    (niosv_g_instruction_manager_rvalid),                      //  output,    width = 1,                                                                .rvalid
		.niosv_g_instruction_manager_rready                                    (niosv_g_instruction_manager_rready),                      //   input,    width = 1,                                                                .rready
		.sdram_axi4_slave_awid                                                 (mm_interconnect_0_sdram_axi4_slave_awid),                 //  output,    width = 4,                                                sdram_axi4_slave.awid
		.sdram_axi4_slave_awaddr                                               (mm_interconnect_0_sdram_axi4_slave_awaddr),               //  output,   width = 26,                                                                .awaddr
		.sdram_axi4_slave_awlen                                                (mm_interconnect_0_sdram_axi4_slave_awlen),                //  output,    width = 8,                                                                .awlen
		.sdram_axi4_slave_awsize                                               (mm_interconnect_0_sdram_axi4_slave_awsize),               //  output,    width = 3,                                                                .awsize
		.sdram_axi4_slave_awburst                                              (mm_interconnect_0_sdram_axi4_slave_awburst),              //  output,    width = 2,                                                                .awburst
		.sdram_axi4_slave_awvalid                                              (mm_interconnect_0_sdram_axi4_slave_awvalid),              //  output,    width = 1,                                                                .awvalid
		.sdram_axi4_slave_awready                                              (mm_interconnect_0_sdram_axi4_slave_awready),              //   input,    width = 1,                                                                .awready
		.sdram_axi4_slave_wdata                                                (mm_interconnect_0_sdram_axi4_slave_wdata),                //  output,   width = 64,                                                                .wdata
		.sdram_axi4_slave_wstrb                                                (mm_interconnect_0_sdram_axi4_slave_wstrb),                //  output,    width = 8,                                                                .wstrb
		.sdram_axi4_slave_wlast                                                (mm_interconnect_0_sdram_axi4_slave_wlast),                //  output,    width = 1,                                                                .wlast
		.sdram_axi4_slave_wvalid                                               (mm_interconnect_0_sdram_axi4_slave_wvalid),               //  output,    width = 1,                                                                .wvalid
		.sdram_axi4_slave_wready                                               (mm_interconnect_0_sdram_axi4_slave_wready),               //   input,    width = 1,                                                                .wready
		.sdram_axi4_slave_bid                                                  (mm_interconnect_0_sdram_axi4_slave_bid),                  //   input,    width = 4,                                                                .bid
		.sdram_axi4_slave_bresp                                                (mm_interconnect_0_sdram_axi4_slave_bresp),                //   input,    width = 2,                                                                .bresp
		.sdram_axi4_slave_bvalid                                               (mm_interconnect_0_sdram_axi4_slave_bvalid),               //   input,    width = 1,                                                                .bvalid
		.sdram_axi4_slave_bready                                               (mm_interconnect_0_sdram_axi4_slave_bready),               //  output,    width = 1,                                                                .bready
		.sdram_axi4_slave_arid                                                 (mm_interconnect_0_sdram_axi4_slave_arid),                 //  output,    width = 4,                                                                .arid
		.sdram_axi4_slave_araddr                                               (mm_interconnect_0_sdram_axi4_slave_araddr),               //  output,   width = 26,                                                                .araddr
		.sdram_axi4_slave_arlen                                                (mm_interconnect_0_sdram_axi4_slave_arlen),                //  output,    width = 8,                                                                .arlen
		.sdram_axi4_slave_arsize                                               (mm_interconnect_0_sdram_axi4_slave_arsize),               //  output,    width = 3,                                                                .arsize
		.sdram_axi4_slave_arburst                                              (mm_interconnect_0_sdram_axi4_slave_arburst),              //  output,    width = 2,                                                                .arburst
		.sdram_axi4_slave_arvalid                                              (mm_interconnect_0_sdram_axi4_slave_arvalid),              //  output,    width = 1,                                                                .arvalid
		.sdram_axi4_slave_arready                                              (mm_interconnect_0_sdram_axi4_slave_arready),              //   input,    width = 1,                                                                .arready
		.sdram_axi4_slave_rid                                                  (mm_interconnect_0_sdram_axi4_slave_rid),                  //   input,    width = 4,                                                                .rid
		.sdram_axi4_slave_rdata                                                (mm_interconnect_0_sdram_axi4_slave_rdata),                //   input,   width = 64,                                                                .rdata
		.sdram_axi4_slave_rresp                                                (mm_interconnect_0_sdram_axi4_slave_rresp),                //   input,    width = 2,                                                                .rresp
		.sdram_axi4_slave_rlast                                                (mm_interconnect_0_sdram_axi4_slave_rlast),                //   input,    width = 1,                                                                .rlast
		.sdram_axi4_slave_rvalid                                               (mm_interconnect_0_sdram_axi4_slave_rvalid),               //   input,    width = 1,                                                                .rvalid
		.sdram_axi4_slave_rready                                               (mm_interconnect_0_sdram_axi4_slave_rready),               //  output,    width = 1,                                                                .rready
		.niosv_g_dm_agent_address                                              (mm_interconnect_0_niosv_g_dm_agent_address),              //  output,   width = 16,                                                niosv_g_dm_agent.address
		.niosv_g_dm_agent_write                                                (mm_interconnect_0_niosv_g_dm_agent_write),                //  output,    width = 1,                                                                .write
		.niosv_g_dm_agent_read                                                 (mm_interconnect_0_niosv_g_dm_agent_read),                 //  output,    width = 1,                                                                .read
		.niosv_g_dm_agent_readdata                                             (mm_interconnect_0_niosv_g_dm_agent_readdata),             //   input,   width = 32,                                                                .readdata
		.niosv_g_dm_agent_writedata                                            (mm_interconnect_0_niosv_g_dm_agent_writedata),            //  output,   width = 32,                                                                .writedata
		.niosv_g_dm_agent_readdatavalid                                        (mm_interconnect_0_niosv_g_dm_agent_readdatavalid),        //   input,    width = 1,                                                                .readdatavalid
		.niosv_g_dm_agent_waitrequest                                          (mm_interconnect_0_niosv_g_dm_agent_waitrequest),          //   input,    width = 1,                                                                .waitrequest
		.mm_bridge_peripheral_s0_address                                       (mm_interconnect_0_mm_bridge_peripheral_s0_address),       //  output,   width = 18,                                         mm_bridge_peripheral_s0.address
		.mm_bridge_peripheral_s0_write                                         (mm_interconnect_0_mm_bridge_peripheral_s0_write),         //  output,    width = 1,                                                                .write
		.mm_bridge_peripheral_s0_read                                          (mm_interconnect_0_mm_bridge_peripheral_s0_read),          //  output,    width = 1,                                                                .read
		.mm_bridge_peripheral_s0_readdata                                      (mm_interconnect_0_mm_bridge_peripheral_s0_readdata),      //   input,   width = 32,                                                                .readdata
		.mm_bridge_peripheral_s0_writedata                                     (mm_interconnect_0_mm_bridge_peripheral_s0_writedata),     //  output,   width = 32,                                                                .writedata
		.mm_bridge_peripheral_s0_burstcount                                    (mm_interconnect_0_mm_bridge_peripheral_s0_burstcount),    //  output,    width = 1,                                                                .burstcount
		.mm_bridge_peripheral_s0_byteenable                                    (mm_interconnect_0_mm_bridge_peripheral_s0_byteenable),    //  output,    width = 4,                                                                .byteenable
		.mm_bridge_peripheral_s0_readdatavalid                                 (mm_interconnect_0_mm_bridge_peripheral_s0_readdatavalid), //   input,    width = 1,                                                                .readdatavalid
		.mm_bridge_peripheral_s0_waitrequest                                   (mm_interconnect_0_mm_bridge_peripheral_s0_waitrequest),   //   input,    width = 1,                                                                .waitrequest
		.mm_bridge_peripheral_s0_debugaccess                                   (mm_interconnect_0_mm_bridge_peripheral_s0_debugaccess),   //  output,    width = 1,                                                                .debugaccess
		.onchip_memory_s1_address                                              (mm_interconnect_0_onchip_memory_s1_address),              //  output,   width = 17,                                                onchip_memory_s1.address
		.onchip_memory_s1_write                                                (mm_interconnect_0_onchip_memory_s1_write),                //  output,    width = 1,                                                                .write
		.onchip_memory_s1_read                                                 (mm_interconnect_0_onchip_memory_s1_read),                 //  output,    width = 1,                                                                .read
		.onchip_memory_s1_readdata                                             (mm_interconnect_0_onchip_memory_s1_readdata),             //   input,   width = 32,                                                                .readdata
		.onchip_memory_s1_writedata                                            (mm_interconnect_0_onchip_memory_s1_writedata),            //  output,   width = 32,                                                                .writedata
		.onchip_memory_s1_byteenable                                           (mm_interconnect_0_onchip_memory_s1_byteenable),           //  output,    width = 4,                                                                .byteenable
		.niosv_g_timer_sw_agent_address                                        (mm_interconnect_0_niosv_g_timer_sw_agent_address),        //  output,    width = 6,                                          niosv_g_timer_sw_agent.address
		.niosv_g_timer_sw_agent_write                                          (mm_interconnect_0_niosv_g_timer_sw_agent_write),          //  output,    width = 1,                                                                .write
		.niosv_g_timer_sw_agent_read                                           (mm_interconnect_0_niosv_g_timer_sw_agent_read),           //  output,    width = 1,                                                                .read
		.niosv_g_timer_sw_agent_readdata                                       (mm_interconnect_0_niosv_g_timer_sw_agent_readdata),       //   input,   width = 32,                                                                .readdata
		.niosv_g_timer_sw_agent_writedata                                      (mm_interconnect_0_niosv_g_timer_sw_agent_writedata),      //  output,   width = 32,                                                                .writedata
		.niosv_g_timer_sw_agent_byteenable                                     (mm_interconnect_0_niosv_g_timer_sw_agent_byteenable),     //  output,    width = 4,                                                                .byteenable
		.niosv_g_timer_sw_agent_readdatavalid                                  (mm_interconnect_0_niosv_g_timer_sw_agent_readdatavalid),  //   input,    width = 1,                                                                .readdatavalid
		.niosv_g_timer_sw_agent_waitrequest                                    (mm_interconnect_0_niosv_g_timer_sw_agent_waitrequest),    //   input,    width = 1,                                                                .waitrequest
		.intel_vvp_vfr_mem_reset_reset_bridge_in_reset_reset                   (rst_controller_001_reset_out_reset),                      //   input,    width = 1,                   intel_vvp_vfr_mem_reset_reset_bridge_in_reset.reset
		.niosv_g_reset_reset_bridge_in_reset_reset                             (rst_controller_006_reset_out_reset),                      //   input,    width = 1,                             niosv_g_reset_reset_bridge_in_reset.reset
		.sdram_reset_sink_reset_bridge_in_reset_reset                          (rst_controller_001_reset_out_reset),                      //   input,    width = 1,                          sdram_reset_sink_reset_bridge_in_reset.reset
		.niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset_reset (rst_controller_006_reset_out_reset),                      //   input,    width = 1, niosv_g_data_manager_translator_clk_reset_reset_bridge_in_reset.reset
		.iopll_outclk0_clk                                                     (iopll_outclk0_clk)                                        //   input,    width = 1,                                                   iopll_outclk0.clk
	);

	nios_system_altera_mm_interconnect_1920_jqutp4y mm_interconnect_1 (
		.mm_bridge_peripheral_m0_address                                          (mm_bridge_peripheral_m0_address),                                   //   input,  width = 18,                                            mm_bridge_peripheral_m0.address
		.mm_bridge_peripheral_m0_waitrequest                                      (mm_bridge_peripheral_m0_waitrequest),                               //  output,   width = 1,                                                                   .waitrequest
		.mm_bridge_peripheral_m0_burstcount                                       (mm_bridge_peripheral_m0_burstcount),                                //   input,   width = 1,                                                                   .burstcount
		.mm_bridge_peripheral_m0_byteenable                                       (mm_bridge_peripheral_m0_byteenable),                                //   input,   width = 4,                                                                   .byteenable
		.mm_bridge_peripheral_m0_read                                             (mm_bridge_peripheral_m0_read),                                      //   input,   width = 1,                                                                   .read
		.mm_bridge_peripheral_m0_readdata                                         (mm_bridge_peripheral_m0_readdata),                                  //  output,  width = 32,                                                                   .readdata
		.mm_bridge_peripheral_m0_readdatavalid                                    (mm_bridge_peripheral_m0_readdatavalid),                             //  output,   width = 1,                                                                   .readdatavalid
		.mm_bridge_peripheral_m0_write                                            (mm_bridge_peripheral_m0_write),                                     //   input,   width = 1,                                                                   .write
		.mm_bridge_peripheral_m0_writedata                                        (mm_bridge_peripheral_m0_writedata),                                 //   input,  width = 32,                                                                   .writedata
		.mm_bridge_peripheral_m0_debugaccess                                      (mm_bridge_peripheral_m0_debugaccess),                               //   input,   width = 1,                                                                   .debugaccess
		.intel_vvp_vfr_av_mm_control_agent_address                                (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_address),       //  output,   width = 8,                                  intel_vvp_vfr_av_mm_control_agent.address
		.intel_vvp_vfr_av_mm_control_agent_write                                  (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_write),         //  output,   width = 1,                                                                   .write
		.intel_vvp_vfr_av_mm_control_agent_read                                   (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_read),          //  output,   width = 1,                                                                   .read
		.intel_vvp_vfr_av_mm_control_agent_readdata                               (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdata),      //   input,  width = 32,                                                                   .readdata
		.intel_vvp_vfr_av_mm_control_agent_writedata                              (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_writedata),     //  output,  width = 32,                                                                   .writedata
		.intel_vvp_vfr_av_mm_control_agent_byteenable                             (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_byteenable),    //  output,   width = 4,                                                                   .byteenable
		.intel_vvp_vfr_av_mm_control_agent_readdatavalid                          (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_readdatavalid), //   input,   width = 1,                                                                   .readdatavalid
		.intel_vvp_vfr_av_mm_control_agent_waitrequest                            (mm_interconnect_1_intel_vvp_vfr_av_mm_control_agent_waitrequest),   //   input,   width = 1,                                                                   .waitrequest
		.jtag_uart_avalon_jtag_slave_address                                      (mm_interconnect_1_jtag_uart_avalon_jtag_slave_address),             //  output,   width = 1,                                        jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                                        (mm_interconnect_1_jtag_uart_avalon_jtag_slave_write),               //  output,   width = 1,                                                                   .write
		.jtag_uart_avalon_jtag_slave_read                                         (mm_interconnect_1_jtag_uart_avalon_jtag_slave_read),                //  output,   width = 1,                                                                   .read
		.jtag_uart_avalon_jtag_slave_readdata                                     (mm_interconnect_1_jtag_uart_avalon_jtag_slave_readdata),            //   input,  width = 32,                                                                   .readdata
		.jtag_uart_avalon_jtag_slave_writedata                                    (mm_interconnect_1_jtag_uart_avalon_jtag_slave_writedata),           //  output,  width = 32,                                                                   .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                                  (mm_interconnect_1_jtag_uart_avalon_jtag_slave_waitrequest),         //   input,   width = 1,                                                                   .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                                   (mm_interconnect_1_jtag_uart_avalon_jtag_slave_chipselect),          //  output,   width = 1,                                                                   .chipselect
		.terasic_sdcard_avalon_slave_address                                      (mm_interconnect_1_terasic_sdcard_avalon_slave_address),             //  output,  width = 12,                                        terasic_sdcard_avalon_slave.address
		.terasic_sdcard_avalon_slave_write                                        (mm_interconnect_1_terasic_sdcard_avalon_slave_write),               //  output,   width = 1,                                                                   .write
		.terasic_sdcard_avalon_slave_read                                         (mm_interconnect_1_terasic_sdcard_avalon_slave_read),                //  output,   width = 1,                                                                   .read
		.terasic_sdcard_avalon_slave_readdata                                     (mm_interconnect_1_terasic_sdcard_avalon_slave_readdata),            //   input,   width = 8,                                                                   .readdata
		.terasic_sdcard_avalon_slave_writedata                                    (mm_interconnect_1_terasic_sdcard_avalon_slave_writedata),           //  output,   width = 8,                                                                   .writedata
		.sysid_qsys_control_slave_address                                         (mm_interconnect_1_sysid_qsys_control_slave_address),                //  output,   width = 1,                                           sysid_qsys_control_slave.address
		.sysid_qsys_control_slave_readdata                                        (mm_interconnect_1_sysid_qsys_control_slave_readdata),               //   input,  width = 32,                                                                   .readdata
		.pio_sw_s1_address                                                        (mm_interconnect_1_pio_sw_s1_address),                               //  output,   width = 2,                                                          pio_sw_s1.address
		.pio_sw_s1_write                                                          (mm_interconnect_1_pio_sw_s1_write),                                 //  output,   width = 1,                                                                   .write
		.pio_sw_s1_readdata                                                       (mm_interconnect_1_pio_sw_s1_readdata),                              //   input,  width = 32,                                                                   .readdata
		.pio_sw_s1_writedata                                                      (mm_interconnect_1_pio_sw_s1_writedata),                             //  output,  width = 32,                                                                   .writedata
		.pio_sw_s1_chipselect                                                     (mm_interconnect_1_pio_sw_s1_chipselect),                            //  output,   width = 1,                                                                   .chipselect
		.pio_led_s1_address                                                       (mm_interconnect_1_pio_led_s1_address),                              //  output,   width = 2,                                                         pio_led_s1.address
		.pio_led_s1_write                                                         (mm_interconnect_1_pio_led_s1_write),                                //  output,   width = 1,                                                                   .write
		.pio_led_s1_readdata                                                      (mm_interconnect_1_pio_led_s1_readdata),                             //   input,  width = 32,                                                                   .readdata
		.pio_led_s1_writedata                                                     (mm_interconnect_1_pio_led_s1_writedata),                            //  output,  width = 32,                                                                   .writedata
		.pio_led_s1_chipselect                                                    (mm_interconnect_1_pio_led_s1_chipselect),                           //  output,   width = 1,                                                                   .chipselect
		.pio_key_s1_address                                                       (mm_interconnect_1_pio_key_s1_address),                              //  output,   width = 2,                                                         pio_key_s1.address
		.pio_key_s1_write                                                         (mm_interconnect_1_pio_key_s1_write),                                //  output,   width = 1,                                                                   .write
		.pio_key_s1_readdata                                                      (mm_interconnect_1_pio_key_s1_readdata),                             //   input,  width = 32,                                                                   .readdata
		.pio_key_s1_writedata                                                     (mm_interconnect_1_pio_key_s1_writedata),                            //  output,  width = 32,                                                                   .writedata
		.pio_key_s1_chipselect                                                    (mm_interconnect_1_pio_key_s1_chipselect),                           //  output,   width = 1,                                                                   .chipselect
		.pio_fsync_out_s1_address                                                 (mm_interconnect_1_pio_fsync_out_s1_address),                        //  output,   width = 2,                                                   pio_fsync_out_s1.address
		.pio_fsync_out_s1_write                                                   (mm_interconnect_1_pio_fsync_out_s1_write),                          //  output,   width = 1,                                                                   .write
		.pio_fsync_out_s1_readdata                                                (mm_interconnect_1_pio_fsync_out_s1_readdata),                       //   input,  width = 32,                                                                   .readdata
		.pio_fsync_out_s1_writedata                                               (mm_interconnect_1_pio_fsync_out_s1_writedata),                      //  output,  width = 32,                                                                   .writedata
		.pio_fsync_out_s1_chipselect                                              (mm_interconnect_1_pio_fsync_out_s1_chipselect),                     //  output,   width = 1,                                                                   .chipselect
		.mm_bridge_peripheral_reset_reset_bridge_in_reset_reset                   (rst_controller_001_reset_out_reset),                                //   input,   width = 1,                   mm_bridge_peripheral_reset_reset_bridge_in_reset.reset
		.jtag_uart_reset_reset_bridge_in_reset_reset                              (rst_controller_001_reset_out_reset),                                //   input,   width = 1,                              jtag_uart_reset_reset_bridge_in_reset.reset
		.terasic_sdcard_reset_reset_bridge_in_reset_reset                         (rst_controller_007_reset_out_reset),                                //   input,   width = 1,                         terasic_sdcard_reset_reset_bridge_in_reset.reset
		.terasic_sdcard_avalon_slave_translator_reset_reset_bridge_in_reset_reset (rst_controller_007_reset_out_reset),                                //   input,   width = 1, terasic_sdcard_avalon_slave_translator_reset_reset_bridge_in_reset.reset
		.iopll_outclk0_clk                                                        (iopll_outclk0_clk),                                                 //   input,   width = 1,                                                      iopll_outclk0.clk
		.iopll_outclk3_clk                                                        (iopll_outclk3_clk)                                                  //   input,   width = 1,                                                      iopll_outclk3.clk
	);

	nios_system_altera_irq_mapper_2001_wpsxsti irq_mapper (
		.clk           (iopll_outclk0_clk),                  //   input,   width = 1,       clk.clk
		.reset         (rst_controller_003_reset_out_reset), //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),           //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),           //   input,   width = 1, receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),           //   input,   width = 1, receiver2.irq
		.sender_irq    (niosv_g_platform_irq_rx_irq)         //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~reset_bridge_out_reset_reset),  //   input,  width = 1, reset_in0.reset
		.clk            (iopll_vga_outclk0_clk),          //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                               // (terminated),                       
		.reset_req_in0  (1'b0),                           // (terminated),                       
		.reset_in1      (1'b0),                           // (terminated),                       
		.reset_req_in1  (1'b0),                           // (terminated),                       
		.reset_in2      (1'b0),                           // (terminated),                       
		.reset_req_in2  (1'b0),                           // (terminated),                       
		.reset_in3      (1'b0),                           // (terminated),                       
		.reset_req_in3  (1'b0),                           // (terminated),                       
		.reset_in4      (1'b0),                           // (terminated),                       
		.reset_req_in4  (1'b0),                           // (terminated),                       
		.reset_in5      (1'b0),                           // (terminated),                       
		.reset_req_in5  (1'b0),                           // (terminated),                       
		.reset_in6      (1'b0),                           // (terminated),                       
		.reset_req_in6  (1'b0),                           // (terminated),                       
		.reset_in7      (1'b0),                           // (terminated),                       
		.reset_req_in7  (1'b0),                           // (terminated),                       
		.reset_in8      (1'b0),                           // (terminated),                       
		.reset_req_in8  (1'b0),                           // (terminated),                       
		.reset_in9      (1'b0),                           // (terminated),                       
		.reset_req_in9  (1'b0),                           // (terminated),                       
		.reset_in10     (1'b0),                           // (terminated),                       
		.reset_req_in10 (1'b0),                           // (terminated),                       
		.reset_in11     (1'b0),                           // (terminated),                       
		.reset_req_in11 (1'b0),                           // (terminated),                       
		.reset_in12     (1'b0),                           // (terminated),                       
		.reset_req_in12 (1'b0),                           // (terminated),                       
		.reset_in13     (1'b0),                           // (terminated),                       
		.reset_req_in13 (1'b0),                           // (terminated),                       
		.reset_in14     (1'b0),                           // (terminated),                       
		.reset_req_in14 (1'b0),                           // (terminated),                       
		.reset_in15     (1'b0),                           // (terminated),                       
		.reset_req_in15 (1'b0)                            // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk0_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_002 (
		.reset_in0      (~reset_bridge_out_reset_reset),          //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk0_clk),                      //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_002_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_002_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                                   // (terminated),                       
		.reset_in1      (1'b0),                                   // (terminated),                       
		.reset_req_in1  (1'b0),                                   // (terminated),                       
		.reset_in2      (1'b0),                                   // (terminated),                       
		.reset_req_in2  (1'b0),                                   // (terminated),                       
		.reset_in3      (1'b0),                                   // (terminated),                       
		.reset_req_in3  (1'b0),                                   // (terminated),                       
		.reset_in4      (1'b0),                                   // (terminated),                       
		.reset_req_in4  (1'b0),                                   // (terminated),                       
		.reset_in5      (1'b0),                                   // (terminated),                       
		.reset_req_in5  (1'b0),                                   // (terminated),                       
		.reset_in6      (1'b0),                                   // (terminated),                       
		.reset_req_in6  (1'b0),                                   // (terminated),                       
		.reset_in7      (1'b0),                                   // (terminated),                       
		.reset_req_in7  (1'b0),                                   // (terminated),                       
		.reset_in8      (1'b0),                                   // (terminated),                       
		.reset_req_in8  (1'b0),                                   // (terminated),                       
		.reset_in9      (1'b0),                                   // (terminated),                       
		.reset_req_in9  (1'b0),                                   // (terminated),                       
		.reset_in10     (1'b0),                                   // (terminated),                       
		.reset_req_in10 (1'b0),                                   // (terminated),                       
		.reset_in11     (1'b0),                                   // (terminated),                       
		.reset_req_in11 (1'b0),                                   // (terminated),                       
		.reset_in12     (1'b0),                                   // (terminated),                       
		.reset_req_in12 (1'b0),                                   // (terminated),                       
		.reset_in13     (1'b0),                                   // (terminated),                       
		.reset_req_in13 (1'b0),                                   // (terminated),                       
		.reset_in14     (1'b0),                                   // (terminated),                       
		.reset_req_in14 (1'b0),                                   // (terminated),                       
		.reset_in15     (1'b0),                                   // (terminated),                       
		.reset_req_in15 (1'b0)                                    // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_003 (
		.reset_in0      (niosv_g_dbg_reset_out_reset),        //   input,  width = 1, reset_in0.reset
		.reset_in1      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in1.reset
		.clk            (iopll_outclk0_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_003_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_004 (
		.reset_in0      (reset_release_ninit_done_reset),     //   input,  width = 1, reset_in0.reset
		.reset_in1      (~reset_in_out_reset_reset),          //   input,  width = 1, reset_in1.reset
		.clk            (clock_in_out_clk_clk),               //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_004_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_005 (
		.reset_in0      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk3_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_005_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_006 (
		.reset_in0      (niosv_g_dbg_reset_out_reset),        //   input,  width = 1, reset_in0.reset
		.reset_in1      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in1.reset
		.clk            (iopll_outclk0_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_006_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_007 (
		.reset_in0      (~reset_bridge_out_reset_reset),      //   input,  width = 1, reset_in0.reset
		.clk            (iopll_outclk3_clk),                  //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_007_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

endmodule
