	component nios_system_terasic_sdio_0 is
		generic (
			CLK_FREQ : integer := 50000000
		);
		port (
			clk           : in    std_logic                     := 'X';             -- clk
			reset_n       : in    std_logic                     := 'X';             -- reset_n
			avs_address   : in    std_logic_vector(11 downto 0) := (others => 'X'); -- address
			avs_write     : in    std_logic                     := 'X';             -- write
			avs_read      : in    std_logic                     := 'X';             -- read
			avs_writedata : in    std_logic_vector(7 downto 0)  := (others => 'X'); -- writedata
			avs_readdata  : out   std_logic_vector(7 downto 0);                     -- readdata
			sd_clk        : out   std_logic;                                        -- sd_clk
			sd_cmd        : inout std_logic                     := 'X';             -- sd_cmd
			sd_data       : inout std_logic_vector(3 downto 0)  := (others => 'X')  -- sd_data
		);
	end component nios_system_terasic_sdio_0;

	u0 : component nios_system_terasic_sdio_0
		generic map (
			CLK_FREQ => INTEGER_VALUE_FOR_CLK_FREQ
		)
		port map (
			clk           => CONNECTED_TO_clk,           --        clock.clk
			reset_n       => CONNECTED_TO_reset_n,       --        reset.reset_n
			avs_address   => CONNECTED_TO_avs_address,   -- avalon_slave.address
			avs_write     => CONNECTED_TO_avs_write,     --             .write
			avs_read      => CONNECTED_TO_avs_read,      --             .read
			avs_writedata => CONNECTED_TO_avs_writedata, --             .writedata
			avs_readdata  => CONNECTED_TO_avs_readdata,  --             .readdata
			sd_clk        => CONNECTED_TO_sd_clk,        --  conduit_end.sd_clk
			sd_cmd        => CONNECTED_TO_sd_cmd,        --             .sd_cmd
			sd_data       => CONNECTED_TO_sd_data        --             .sd_data
		);

