// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module intel_vvp_vtiming_gen_aligned
#(
  parameter C_BUILD_VRR                             = 1,
  parameter C_BUILD_HARD_FRAME_LOCK                 = 1,
  parameter C_BUILD_SOFT_FRAME_LOCK                 = 1,
  parameter C_NUM_PULSES                            = 2,
  parameter C_USE_CPU                               = 1,
  parameter C_OUTPUT_IS_CV                          = 1,
  parameter C_CV_NUM_PLANES                         = 3,
  parameter C_CV_NUM_PIXELS                         = 1,
  parameter C_CV_BIT_DEPTH                          = 10,
  parameter C_HSIZE                                 = 14, // max 16k pixels
  parameter C_VSIZE                                 = 14, // max 16k lines


  // default timing parameters
  parameter C_TIM_VTOTAL            = 1125     // V Total

)
(
  vid_clk,
  vid_rst,
  
  cv_vid_out_data,
  cv_vid_out_active,
  cv_vid_out_f,     
  cv_vid_out_h,     
  cv_vid_out_v,     
  cv_vid_out_h_sync,
  cv_vid_out_v_sync,
  
  axi4s_fr_vid_out_tdata,
  axi4s_fr_vid_out_tuser,
  axi4s_fr_vid_out_tvalid,  
  axi4s_fr_vid_out_tready,  // this is not used, but is retained here to "complete" the axis protocol
  axi4s_fr_vid_out_tlast,   // this is not used, but is retained here to "complete" the axis protocol

  frame_start,
  r_pixel_00,
  
  pulse0, // sof
  pulse1, // sof_delay
  pulse2,
  pulse3,
  pulse4,
  pulse5,
  pulse6,
  pulse7,
  
  r_vid_frame_start_pulse,
  r_vid_tim_hreset       ,
  r_vid_tim_vreset       ,

  r_vid_tim_htotal       ,
  r_vid_tim_vtotal       ,
  r_vid_tim_hb_end       ,
  r_vid_tim_v1b_start    ,
  r_vid_tim_v1b_end      ,
  r_vid_tim_v2b_start    ,
  r_vid_tim_v2b_end      ,
  r_vid_tim_f1_start     ,
  r_vid_tim_f2_start     ,
  r_vid_tim_hs_start     ,
  r_vid_tim_hs_end       ,
  r_vid_tim_v1s_vstart   ,
  r_vid_tim_v1s_hstart   ,
  r_vid_tim_v1s_vend     ,
  r_vid_tim_v1s_hend     ,
  r_vid_tim_v2s_vstart   ,
  r_vid_tim_v2s_hstart   ,
  r_vid_tim_v2s_vend     ,
  r_vid_tim_v2s_hend     ,

  r_vid_tim_pulse0_vstart,
  r_vid_tim_pulse0_hstart,
  r_vid_tim_pulse0_vend  ,
  r_vid_tim_pulse0_hend  ,
  r_vid_tim_pulse1_vstart,
  r_vid_tim_pulse1_hstart,
  r_vid_tim_pulse1_vend  ,
  r_vid_tim_pulse1_hend  ,
  r_vid_tim_pulse2_vstart,
  r_vid_tim_pulse2_hstart,
  r_vid_tim_pulse2_vend  ,
  r_vid_tim_pulse2_hend  ,
  r_vid_tim_pulse3_vstart,
  r_vid_tim_pulse3_hstart,
  r_vid_tim_pulse3_vend  ,
  r_vid_tim_pulse3_hend  ,
  r_vid_tim_pulse4_vstart,
  r_vid_tim_pulse4_hstart,
  r_vid_tim_pulse4_vend  ,
  r_vid_tim_pulse4_hend  ,
  r_vid_tim_pulse5_vstart,
  r_vid_tim_pulse5_hstart,
  r_vid_tim_pulse5_vend  ,
  r_vid_tim_pulse5_hend  ,
  r_vid_tim_pulse6_vstart,
  r_vid_tim_pulse6_hstart,
  r_vid_tim_pulse6_vend  ,
  r_vid_tim_pulse6_hend  ,
  r_vid_tim_pulse7_vstart,
  r_vid_tim_pulse7_hstart,
  r_vid_tim_pulse7_vend  ,
  r_vid_tim_pulse7_hend  ,
  r_vid_allow_hv_reset   ,
  r_vid_out_is_blank     ,
  r_vid_black            ,
  r_vid_use_soft_reset   ,
  r_vid_vrr              ,
  r_vid_vrr_linemode     ,

  r_vid_frame_start_jitter,
  r_vid_frame_adj_ignore,
  r_vid_frame_adj_window,
  
  r_vid_start_counter     ,
  r_vid_hv_reset_count    ,
  r_vid_frame_count       ,
  r_actual_pixels_latched ,
  r_vid_tim_vtotal_latched,

  vid_inc_count           ,
  vid_dec_count           ,
  vid_stable_count
  
  

);
// calculate localparams needed for the interface.
localparam C_PADDED_BPS         = (C_CV_BIT_DEPTH < 8) ? 8 : C_CV_BIT_DEPTH;
localparam C_PADDED_PIXEL_BITS  = C_CV_NUM_PLANES * C_PADDED_BPS;
localparam C_AXIS_PIXEL_BYTES   = ((C_CV_NUM_PLANES+1)*C_PADDED_BPS+7)/8;
localparam C_AXIS_WIDTH         = C_AXIS_PIXEL_BYTES*C_CV_NUM_PIXELS*8;
localparam C_TUSER_WIDTH        = C_AXIS_PIXEL_BYTES*C_CV_NUM_PIXELS;
localparam C_CV_PIXEL_BITS      = C_CV_NUM_PLANES * C_CV_BIT_DEPTH;
localparam C_CV_WIDTH           = C_CV_NUM_PIXELS * C_CV_PIXEL_BITS;

input  logic                         vid_clk;
input  logic                         vid_rst;

output logic [C_CV_WIDTH - 1    : 0] cv_vid_out_data;
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_active;
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_f;    
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_h;     
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_v;     
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_h_sync;
output logic [C_CV_NUM_PIXELS-1 : 0] cv_vid_out_v_sync;

output logic [C_AXIS_WIDTH - 1  : 0] axi4s_fr_vid_out_tdata;
output logic [C_TUSER_WIDTH - 1 : 0] axi4s_fr_vid_out_tuser;
output logic                         axi4s_fr_vid_out_tvalid;  
input  logic                         axi4s_fr_vid_out_tready;// = 1'b1;  // this is not used, but is retained here to "complete" the axis protocol
output logic                         axi4s_fr_vid_out_tlast;

input  logic                         frame_start;
output logic                         r_pixel_00;

output logic                         pulse0; // sof
output logic                         pulse1; // sof_delay
output logic                         pulse2;
output logic                         pulse3;
output logic                         pulse4;
output logic                         pulse5;
output logic                         pulse6;
output logic                         pulse7;

input logic               r_vid_frame_start_pulse;
input logic [C_HSIZE-1:0] r_vid_tim_hreset       ;
input logic [C_VSIZE-1:0] r_vid_tim_vreset       ;

input logic [C_HSIZE-1:0] r_vid_tim_htotal       ;
input logic [C_VSIZE-1:0] r_vid_tim_vtotal       ;
input logic [C_HSIZE-1:0] r_vid_tim_hb_end       ;
input logic [C_VSIZE-1:0] r_vid_tim_v1b_start    ;
input logic [C_VSIZE-1:0] r_vid_tim_v1b_end      ;
input logic [C_VSIZE-1:0] r_vid_tim_v2b_start    ;
input logic [C_VSIZE-1:0] r_vid_tim_v2b_end      ;
input logic [C_VSIZE-1:0] r_vid_tim_f1_start     ;
input logic [C_VSIZE-1:0] r_vid_tim_f2_start     ;
input logic [C_HSIZE-1:0] r_vid_tim_hs_start     ;
input logic [C_HSIZE-1:0] r_vid_tim_hs_end       ;
input logic [C_VSIZE-1:0] r_vid_tim_v1s_vstart   ;
input logic [C_HSIZE-1:0] r_vid_tim_v1s_hstart   ;
input logic [C_VSIZE-1:0] r_vid_tim_v1s_vend     ;
input logic [C_HSIZE-1:0] r_vid_tim_v1s_hend     ;
input logic [C_VSIZE-1:0] r_vid_tim_v2s_vstart   ;
input logic [C_HSIZE-1:0] r_vid_tim_v2s_hstart   ;
input logic [C_VSIZE-1:0] r_vid_tim_v2s_vend     ;
input logic [C_HSIZE-1:0] r_vid_tim_v2s_hend     ;

input logic [C_VSIZE-1:0] r_vid_tim_pulse0_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse0_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse0_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse0_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse1_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse1_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse1_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse1_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse2_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse2_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse2_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse2_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse3_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse3_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse3_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse3_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse4_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse4_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse4_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse4_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse5_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse5_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse5_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse5_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse6_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse6_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse6_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse6_hend  ;
input logic [C_VSIZE-1:0] r_vid_tim_pulse7_vstart;
input logic [C_HSIZE-1:0] r_vid_tim_pulse7_hstart;
input logic [C_VSIZE-1:0] r_vid_tim_pulse7_vend  ;
input logic [C_HSIZE-1:0] r_vid_tim_pulse7_hend  ;
input logic               r_vid_allow_hv_reset   ;
input logic               r_vid_out_is_blank     ;
input logic [C_CV_PIXEL_BITS-1:0] r_vid_black    ;
input logic               r_vid_use_soft_reset   ;
input logic               r_vid_vrr              ;
input logic               r_vid_vrr_linemode     ;
input logic [        7:0] r_vid_frame_start_jitter;
input logic [        7:0] r_vid_frame_adj_ignore  ;
input logic [        7:0] r_vid_frame_adj_window  ;



output logic [15:0]                       r_vid_start_counter;
output logic [15:0]                       r_vid_hv_reset_count;
output logic [15:0]                       r_vid_frame_count;
output logic [C_HSIZE + C_VSIZE - 1  : 0] r_actual_pixels_latched;
output logic [C_VSIZE-1              : 0] r_vid_tim_vtotal_latched;

output logic [15:0]                       vid_inc_count    ;
output logic [15:0]                       vid_dec_count    ;
output logic [15:0]                       vid_stable_count ;

///////////////////////////////////////////////////////////////////////////////
//
// localparams
//

// useful localparams
localparam C_AXIS_BITS      = (C_CV_NUM_PLANES + 1) * C_PADDED_BPS;

localparam C_BIT_FIELD      = C_AXIS_BITS - 1;
localparam C_BIT_V          = C_AXIS_BITS - 2;
localparam C_BIT_H          = C_AXIS_BITS - 3;
localparam C_BIT_DE         = C_AXIS_BITS - 4;
localparam C_BIT_SYNC_MODE  = C_AXIS_BITS - 5;
localparam C_BIT_SOF        = C_AXIS_BITS - 6;
localparam C_BIT_EOL        = C_AXIS_BITS - 7;

//////////////////////////////////////////////////////////////////////
//
// Condition the incoming frame_start signal
//
logic r_vid_frame_start_meta  ;
logic r_vid_frame_start_safe  ;
logic r1_vid_frame_start_safe ;
logic r_vid_frame_start       ;
logic r_vid_hv_reset          ;
logic r_ignore_start_frame    ;

always_ff @(posedge vid_clk)
begin:a_make_frame_start
  r_vid_frame_start_meta  <= frame_start;
  r_vid_frame_start_safe  <= r_vid_frame_start_meta;
  r1_vid_frame_start_safe <= r_vid_frame_start_safe;
  if (r_vid_frame_start_pulse)
  begin
    r_vid_frame_start <= r_vid_frame_start_safe & ~r1_vid_frame_start_safe;
  end
  else
  begin
    r_vid_frame_start <= r_vid_frame_start_safe ^ r1_vid_frame_start_safe;
  end
  
  r_vid_hv_reset            <= r_vid_allow_hv_reset & r_vid_frame_start & ~r_ignore_start_frame;
end


//////////////////////////////////////////////////////////////////////
//
// Get the clocks-per-frame_start as a useful diagnostic
//
always_ff @(posedge vid_clk)
begin:a_count_pixels
  logic [C_HSIZE + C_VSIZE - 1  : 0] r_actual_pixels;

  if (vid_rst)
  begin
    r_actual_pixels           <= {C_HSIZE + C_VSIZE{1'b0}};
    r_actual_pixels_latched   <= {C_HSIZE + C_VSIZE{1'b0}};
    r_vid_start_counter       <= 16'b0;
  end
  else
  begin  
    if (r_vid_frame_start) // the raw, ungated pulse from outside this module
    begin
      r_vid_start_counter     <= r_vid_start_counter + 1'b1;
      r_actual_pixels_latched <= r_actual_pixels;
      r_actual_pixels         <= {C_HSIZE + C_VSIZE{1'b0}};
    end
    else
    begin
      r_actual_pixels         <= r_actual_pixels + C_CV_NUM_PIXELS[3:0];
    end
  end
end

//////////////////////////////////////////////////////////////////////
//
// Define the window in which the frame_start pulse can arrive without resetting the h/v count
//
logic [C_HSIZE-1:0]r_vid_tim_htotal_mPIP     ;
if (C_BUILD_HARD_FRAME_LOCK == 1)
begin:g_HARD_FRAME_LOCK
  logic              r_allow_v_increment;
  logic              r_allow_v_decrement;
  logic [C_VSIZE-1:0]r_vid_tim_vtotal_adj     ;

  logic [C_HSIZE-1:0]r_vid_tim_htotal_mjitter     ;

  logic [C_VSIZE-1:0]r_vid_tim_vtotal_latched_m1;

  logic [C_VSIZE-1:0]r_start_hv_dec_line;  
  logic [C_VSIZE-1:0]r_end_hv_dec_line;    
  logic [C_VSIZE-1:0]r_start_hv_inc_line;  
  logic [C_VSIZE-1:0]r_end_hv_inc_line;


  logic [C_VSIZE-1:0]r_reset_line ;
  logic [C_VSIZE-1:0]r_reset_line_p1 ;
  logic [C_HSIZE-1:0]r_reset_pix  ;
  logic [C_HSIZE-1:0]r_reset_clks  ;
  logic [C_HSIZE-1:0]r_line_length_clks;


  always_ff @(posedge vid_clk)
  begin:a_start_window
    logic r_start_hv_reset_window_line_eq; 
    logic r_start_hv_reset_window_pixel_eq; 
    logic r_end_hv_reset_window_line_eq  ; 
    logic r_end_hv_reset_window_pixel_eq  ; 

    logic r_start_hv_dec_window_eq  ; 
    logic r_end_hv_dec_window_eq    ; 
    logic r_start_hv_inc_window_eq  ; 
    logic r_end_hv_inc_window_eq    ; 
    logic start_of_line;
    
    if (vid_rst)
    begin
      r_ignore_start_frame      <= 1'b0;
      r_vid_tim_vtotal_latched  <= C_TIM_VTOTAL;

      r_reset_line              <= {C_VSIZE{1'b0}};
      r_reset_pix               <= {C_HSIZE{1'b0}};
      r_reset_clks              <= {C_HSIZE{1'b0}};
      r_line_length_clks        <= {C_HSIZE{1'b0}};

      r_start_hv_reset_window_line_eq   <= 1'b0; 
      r_start_hv_reset_window_pixel_eq  <= 1'b0; 
      r_end_hv_reset_window_line_eq     <= 1'b0; 
      r_end_hv_reset_window_pixel_eq    <= 1'b0; 

      r_start_hv_dec_window_eq          <= 1'b0; 
      r_end_hv_dec_window_eq            <= 1'b0; 
      r_start_hv_inc_window_eq          <= 1'b0; 
      r_end_hv_inc_window_eq            <= 1'b0; 

      start_of_line                     <= 1'b0;
    end
    else
    begin  

      r_start_hv_reset_window_line_eq   <= (r_reset_line == r_vid_tim_vtotal_latched_m1);
      r_start_hv_reset_window_pixel_eq  <= (r_vid_tim_htotal_mjitter == r_reset_clks);
      r_end_hv_reset_window_line_eq     <= (r_reset_line == {C_VSIZE{1'b0}});
      r_end_hv_reset_window_pixel_eq    <= (r_reset_clks == r_vid_frame_start_jitter);

      if (C_BUILD_SOFT_FRAME_LOCK == 1)
      begin
        r_start_hv_dec_window_eq  <= (r_reset_line    == r_start_hv_dec_line) && (start_of_line)  ; 
        r_end_hv_dec_window_eq    <= (r_reset_line    == r_end_hv_dec_line  ) && (start_of_line)  ;
        r_start_hv_inc_window_eq  <= (r_reset_line    == r_start_hv_inc_line) && (start_of_line)  ;
        r_end_hv_inc_window_eq    <= (r_reset_line    == r_end_hv_inc_line  ) && (start_of_line)  ;
      end
      
      
      // decode the pixel counter for our window start/end
      if (r_start_hv_dec_window_eq)              // start of the region where incoming resets cause the total_v to be decremented!
      begin
        r_ignore_start_frame  <= r_vid_use_soft_reset;
        r_allow_v_increment   <= 1'b0;
        r_allow_v_decrement   <= r_vid_use_soft_reset;
      end
      else if (r_end_hv_dec_window_eq)           // end of the region where incoming resets cause the total_v to be decremented!
      begin
        r_ignore_start_frame     <= r_vid_use_soft_reset;
        r_allow_v_increment      <= 1'b0;
        r_allow_v_decrement      <= 1'b0;
        r_vid_tim_vtotal_latched <= r_vid_tim_vtotal_adj;
      end 
      else if ((r_start_hv_reset_window_line_eq) && (r_start_hv_reset_window_pixel_eq))   // start of the region where incoming resets are always ignored!
      begin
        r_ignore_start_frame  <= 1'b1;
        r_allow_v_increment   <= 1'b0;
        r_allow_v_decrement   <= 1'b0;
      end
      else if ((r_end_hv_reset_window_line_eq) && (r_end_hv_reset_window_pixel_eq))       // end of the region where incoming resets are always ignored!
      begin
        r_ignore_start_frame  <= r_vid_use_soft_reset;
        r_allow_v_increment   <= 1'b0;
        r_allow_v_decrement   <= 1'b0;
      end
      else if (r_start_hv_inc_window_eq)       // start of the region where incoming resets cause the total_v to be incremented!
      begin
        r_ignore_start_frame  <= r_vid_use_soft_reset;
        r_allow_v_increment   <= r_vid_use_soft_reset;
        r_allow_v_decrement   <= 1'b0;
      end
      else if (r_end_hv_inc_window_eq)           // end of special reset regions
      begin
        r_ignore_start_frame  <= 1'b0;
        r_allow_v_increment   <= 1'b0;
        r_allow_v_decrement   <= 1'b0;
        r_vid_tim_vtotal_latched  <= r_vid_tim_vtotal_adj;
      end
      

      // count h&v relative to the reset point
      if (r_vid_hv_reset)
      begin
        r_reset_line   <= {C_VSIZE{1'b0}};
        r_reset_pix    <= {C_HSIZE{1'b0}};
        r_reset_clks   <= {C_HSIZE{1'b0}};
        start_of_line  <= 1'b1;
      end
      else if (r_reset_pix < r_vid_tim_htotal_mPIP)
      begin
        r_reset_pix    <= r_reset_pix    + C_CV_NUM_PIXELS[3:0];
        r_reset_clks   <= r_reset_clks   + 1'b1;
        start_of_line  <= 1'b0;
      end
      else if (r_reset_line < r_vid_tim_vtotal_latched_m1)
      begin
        r_reset_pix   <= r_reset_pix    - r_vid_tim_htotal_mPIP;
        r_reset_clks  <= {C_HSIZE{1'b0}};
        r_reset_line  <= r_reset_line    + 1'b1;
        start_of_line <= 1'b1;
        r_line_length_clks  <= r_reset_clks;
      end
      else 
      begin
        r_reset_pix   <= r_reset_pix    - r_vid_tim_htotal_mPIP;
        r_reset_clks  <= {C_HSIZE{1'b0}};
        r_reset_line  <= {C_VSIZE{1'h0}};
        start_of_line <= 1'b1;
        r_line_length_clks  <= r_reset_clks;
      end 
      r_reset_line_p1       <= r_reset_line + 1'b1;
      
      

    end
  end

  //////////////////////////////////////////////////////////////////////
  //
  // Make useful values for the pixel counter
  //

  always_ff @(posedge vid_clk)
  begin:a_frame_lock_useful_maths
   
    r_vid_tim_vtotal_latched_m1 <= r_vid_tim_vtotal_latched - 1'b1;
    r_vid_tim_htotal_mjitter    <= r_line_length_clks - r_vid_frame_start_jitter;
    r_start_hv_dec_line         <= r_vid_tim_vtotal_latched - r_vid_frame_adj_window;
    r_end_hv_dec_line           <= r_vid_tim_vtotal_latched - r_vid_frame_adj_ignore;
    r_start_hv_inc_line         <= r_vid_frame_adj_ignore;
    r_end_hv_inc_line           <= r_vid_frame_adj_window;
    
  end




  //////////////////////////////////////////////////////////////////////
  //
  // Do the adjusted vtotal
  //
  always_ff @(posedge vid_clk)
  begin:a_do_adjust
    logic [C_VSIZE-1:0] r2_vid_tim_vtotal;
    logic [C_VSIZE-1:0] r_last_adj_line;
    logic r_vid_vtotal_changed;
    logic r_last_reset_line_lt;
    logic r_last_reset_line_gt;
    logic r_last_inc_n_dec;
    if (vid_rst)
    begin
      r2_vid_tim_vtotal     <= C_TIM_VTOTAL;
      r_vid_tim_vtotal_adj  <= C_TIM_VTOTAL;
      r_last_adj_line       <= C_TIM_VTOTAL;
      vid_inc_count         <= 16'b0;
      vid_dec_count         <= 16'b0;
      vid_stable_count      <= 16'b0;
      r_last_inc_n_dec      <= 1'b1;
    end
    else
    begin
      r2_vid_tim_vtotal <= r_vid_tim_vtotal;
      r_vid_vtotal_changed  <= r2_vid_tim_vtotal != r_vid_tim_vtotal;
      r_last_reset_line_gt  <= r_reset_line < r_last_adj_line;
      r_last_reset_line_lt  <= r_reset_line > r_last_adj_line;
      if (~r_vid_use_soft_reset)
      begin
        r_vid_tim_vtotal_adj  <= r_vid_tim_vtotal;
        r_last_adj_line       <= C_TIM_VTOTAL;
        r_last_inc_n_dec      <= 1'b1;
        vid_inc_count         <= 16'b0;
        vid_dec_count         <= 16'b0;
        vid_stable_count      <= 16'b0;
      end
      else if (r_vid_vtotal_changed)
      begin
        r_vid_tim_vtotal_adj  <= r_vid_tim_vtotal;
        r_last_adj_line       <= C_TIM_VTOTAL;
        r_last_inc_n_dec      <= 1'b1;
        vid_inc_count         <= 16'b0;
        vid_dec_count         <= 16'b0;
        vid_stable_count      <= 16'b0;
      end
      else if (r_vid_frame_start && r_allow_v_decrement && (r_last_reset_line_gt || r_last_inc_n_dec))
      begin
        r_vid_tim_vtotal_adj  <= r_vid_tim_vtotal_adj - 1'b1;
        vid_dec_count         <= vid_dec_count + 1'b1;
        r_last_adj_line       <= r_reset_line;
        r_last_inc_n_dec      <= 1'b0;
      end
      else if (r_vid_frame_start && r_allow_v_increment && (r_last_reset_line_lt || !r_last_inc_n_dec))
      begin
        r_vid_tim_vtotal_adj  <= r_vid_tim_vtotal_adj + 1'b1;
        vid_inc_count         <= vid_inc_count + 1'b1;
        r_last_adj_line       <= r_reset_line;
        r_last_inc_n_dec      <= 1'b1;
      end
      else if (r_vid_frame_start)
      begin
        vid_stable_count      <= vid_stable_count + 1'b1;
        r_last_adj_line       <= r_reset_line;
      end
    end
  end
end
else
begin
  assign r_vid_tim_vtotal_latched = r_vid_tim_vtotal;
end
    
always_ff @(posedge vid_clk)
begin:a_general_useful_maths
  r_vid_tim_htotal_mPIP       <= r_vid_tim_htotal - C_CV_NUM_PIXELS[3:0];
end

//////////////////////////////////////////////////////////////////////
//
// The main h/v counters
//
logic [C_HSIZE-1:0] vid_hcount;
logic [C_HSIZE-1:0] vid_hcount_p1;
logic [C_VSIZE-1:0] vid_vcount;
logic [C_VSIZE-1:0] vid_vcount_p1;
logic               r_vid_had_frame_start;
logic vid_comp_lt_htotal     ;
logic vid_comp_eq_htotal     ;
logic vid_comp_vtotal_latched;

always_ff @(posedge vid_clk)
begin:a_counters
  if (vid_rst)
  begin
    vid_hcount    <= {C_HSIZE{1'h0}};
    vid_hcount_p1 <= {C_HSIZE{1'h0}} + C_CV_NUM_PIXELS[3:0];
    vid_vcount    <= {C_VSIZE{1'h0}};
    vid_vcount_p1 <= {C_VSIZE{1'h0}} + 1'b1;
    r_vid_had_frame_start <= 1'b0;
    r_vid_hv_reset_count  <= 16'b0;
    r_vid_frame_count     <= 16'b0;
    r_pixel_00            <= 1'b1;
    vid_comp_lt_htotal      <= 1'b0;
    vid_comp_eq_htotal      <= 1'b0;
    vid_comp_vtotal_latched <= 1'b0;
  end
  else
  begin
    r_pixel_00            <= 1'b0;
    if (r_vid_frame_start)
    begin
      r_vid_had_frame_start <= 1'b1;
    end
  
    vid_comp_lt_htotal      <= (!vid_comp_lt_htotal     ) || (vid_hcount_p1 < r_vid_tim_htotal_mPIP);
    vid_comp_eq_htotal      <= (!vid_comp_eq_htotal     ) && (vid_hcount_p1 == r_vid_tim_htotal);
    //vid_comp_vtotal_latched <= (!vid_comp_vtotal_latched) || (vid_vcount_p1 < r_vid_tim_vtotal_latched);
    vid_comp_vtotal_latched <= vid_vcount_p1 < r_vid_tim_vtotal_latched;
    
    if (r_vid_hv_reset)
    begin
      vid_hcount            <= r_vid_tim_hreset;
      vid_hcount_p1         <= r_vid_tim_hreset + C_CV_NUM_PIXELS[3:0];
      vid_vcount            <= r_vid_tim_vreset;
      vid_vcount_p1         <= r_vid_tim_vreset + 1'b1;
      r_vid_had_frame_start <= 1'b0;
      r_vid_hv_reset_count  <= r_vid_hv_reset_count + 1'b1;
    end
    else if (vid_comp_lt_htotal) //(vid_hcount_p1 < r_vid_tim_htotal)
    begin
      vid_hcount    <= vid_hcount_p1;
      vid_hcount_p1 <= vid_hcount_p1 + C_CV_NUM_PIXELS[3:0];
    end
    else if (vid_comp_vtotal_latched) // vid_vcount_p1 < r_vid_tim_vtotal_latched)
    begin
      vid_hcount    <= {C_HSIZE{1'b0}};
      vid_hcount_p1 <= C_CV_NUM_PIXELS[C_HSIZE-1:0];
      vid_vcount    <= vid_vcount_p1;
      vid_vcount_p1 <= vid_vcount_p1 + 1'b1;
    end
    else if (r_vid_vrr)
    begin
      if (r_vid_had_frame_start)
      begin
        r_vid_had_frame_start <= 1'b0;
        vid_hcount            <= {C_HSIZE{1'h0}};
        vid_hcount_p1         <= C_CV_NUM_PIXELS[C_HSIZE-1:0];
        vid_vcount            <= {C_VSIZE{1'h0}};
        vid_vcount_p1         <= {C_VSIZE{1'h0}} + 1'b1;
        r_pixel_00            <= 1'b1;
        r_vid_frame_count     <= r_vid_frame_count + 1'b1;
      end
      else if (r_vid_vrr_linemode)
      begin
        vid_hcount    <= {C_HSIZE{1'h0}};
        vid_hcount_p1 <= C_CV_NUM_PIXELS[C_HSIZE-1:0];
        vid_vcount    <= vid_vcount_p1;
        vid_vcount_p1 <= vid_vcount_p1 + 1'b1;
      end
    end 
    else 
    begin
      r_vid_frame_count <= r_vid_frame_count + 1'b1;
      vid_hcount        <= {C_HSIZE{1'h0}};
      vid_hcount_p1     <= C_CV_NUM_PIXELS[C_HSIZE-1:0];
      vid_vcount        <= {C_VSIZE{1'h0}};
      vid_vcount_p1     <= {C_VSIZE{1'h0}} + 1'b1;
      r_pixel_00        <= 1'b1;
    end 
  end
end

//////////////////////////////////////////////////////////////////////
//
// Decode the h/v counters
//
logic vid_match_hfirst       ;
logic vid_match_hlast        ;
logic vid_match_hbend        ;
logic vid_match_hsstart      ;
logic vid_match_hsend        ;
logic vid_match_v1s_hstart   ;
logic vid_match_v1s_hend     ;
logic vid_match_v2s_hstart   ;
logic vid_match_v2s_hend     ;
logic vid_match_pulse0_hstart;
logic vid_match_pulse1_hstart;
logic vid_match_pulse2_hstart;
logic vid_match_pulse3_hstart;
logic vid_match_pulse4_hstart;
logic vid_match_pulse5_hstart;
logic vid_match_pulse6_hstart;
logic vid_match_pulse7_hstart;
logic vid_match_pulse0_hend  ;
logic vid_match_pulse1_hend  ;
logic vid_match_pulse2_hend  ;
logic vid_match_pulse3_hend  ;
logic vid_match_pulse4_hend  ;
logic vid_match_pulse5_hend  ;
logic vid_match_pulse6_hend  ;
logic vid_match_pulse7_hend  ;

logic vid_match_vfirst       ;
logic vid_match_f1_start     ;
logic vid_match_f2_start     ;
logic vid_match_v1b_end      ;
logic vid_match_v1b_start    ;
logic vid_match_v1s_vend     ;
logic vid_match_v1s_vstart   ;
logic vid_match_v2b_end      ;
logic vid_match_v2b_start    ;
logic vid_match_v2s_vend     ;
logic vid_match_v2s_vstart   ;
logic vid_match_pulse0_vstart;
logic vid_match_pulse1_vstart;
logic vid_match_pulse2_vstart;
logic vid_match_pulse3_vstart;
logic vid_match_pulse4_vstart;
logic vid_match_pulse5_vstart;
logic vid_match_pulse6_vstart;
logic vid_match_pulse7_vstart;
logic vid_match_pulse0_vend  ;
logic vid_match_pulse1_vend  ;
logic vid_match_pulse2_vend  ;
logic vid_match_pulse3_vend  ;
logic vid_match_pulse4_vend  ;
logic vid_match_pulse5_vend  ;
logic vid_match_pulse6_vend  ;
logic vid_match_pulse7_vend  ;

always_ff @(posedge vid_clk)
begin:a_decode
  // hcounter
  if (vid_hcount == {C_HSIZE{1'h0}}        ) vid_match_hfirst        <= 1'b1;else vid_match_hfirst        <= 1'b0;
  if (vid_hcount_p1 == r_vid_tim_htotal    ) vid_match_hlast         <= 1'b1;else vid_match_hlast         <= 1'b0;
  //if (vid_comp_eq_htotal                   ) vid_match_hlast         <= 1'b1;else vid_match_hlast         <= 1'b0;
  if (vid_hcount == r_vid_tim_hb_end       ) vid_match_hbend         <= 1'b1;else vid_match_hbend         <= 1'b0;
  if (vid_hcount == r_vid_tim_hs_start     ) vid_match_hsstart       <= 1'b1;else vid_match_hsstart       <= 1'b0;
  if (vid_hcount == r_vid_tim_hs_end       ) vid_match_hsend         <= 1'b1;else vid_match_hsend         <= 1'b0;
  if (vid_hcount == r_vid_tim_v1s_hstart   ) vid_match_v1s_hstart    <= 1'b1;else vid_match_v1s_hstart    <= 1'b0;
  if (vid_hcount == r_vid_tim_v1s_hend     ) vid_match_v1s_hend      <= 1'b1;else vid_match_v1s_hend      <= 1'b0;
  if (vid_hcount == r_vid_tim_v2s_hstart   ) vid_match_v2s_hstart    <= 1'b1;else vid_match_v2s_hstart    <= 1'b0;
  if (vid_hcount == r_vid_tim_v2s_hend     ) vid_match_v2s_hend      <= 1'b1;else vid_match_v2s_hend      <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse0_hstart) vid_match_pulse0_hstart <= 1'b1;else vid_match_pulse0_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse1_hstart) vid_match_pulse1_hstart <= 1'b1;else vid_match_pulse1_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse2_hstart) vid_match_pulse2_hstart <= 1'b1;else vid_match_pulse2_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse3_hstart) vid_match_pulse3_hstart <= 1'b1;else vid_match_pulse3_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse4_hstart) vid_match_pulse4_hstart <= 1'b1;else vid_match_pulse4_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse5_hstart) vid_match_pulse5_hstart <= 1'b1;else vid_match_pulse5_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse6_hstart) vid_match_pulse6_hstart <= 1'b1;else vid_match_pulse6_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse7_hstart) vid_match_pulse7_hstart <= 1'b1;else vid_match_pulse7_hstart <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse0_hend  ) vid_match_pulse0_hend   <= 1'b1;else vid_match_pulse0_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse1_hend  ) vid_match_pulse1_hend   <= 1'b1;else vid_match_pulse1_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse2_hend  ) vid_match_pulse2_hend   <= 1'b1;else vid_match_pulse2_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse3_hend  ) vid_match_pulse3_hend   <= 1'b1;else vid_match_pulse3_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse4_hend  ) vid_match_pulse4_hend   <= 1'b1;else vid_match_pulse4_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse5_hend  ) vid_match_pulse5_hend   <= 1'b1;else vid_match_pulse5_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse6_hend  ) vid_match_pulse6_hend   <= 1'b1;else vid_match_pulse6_hend   <= 1'b0;
  if (vid_hcount == r_vid_tim_pulse7_hend  ) vid_match_pulse7_hend   <= 1'b1;else vid_match_pulse7_hend   <= 1'b0;

  // vcounter
  if (vid_vcount == {C_VSIZE{1'h0}}        ) vid_match_vfirst        <= 1'b1;else vid_match_vfirst        <= 1'b0;
  if (vid_vcount == r_vid_tim_f1_start     ) vid_match_f1_start      <= 1'b1;else vid_match_f1_start      <= 1'b0;
  if (vid_vcount == r_vid_tim_f2_start     ) vid_match_f2_start      <= 1'b1;else vid_match_f2_start      <= 1'b0;
  if (vid_vcount == r_vid_tim_v1b_end      ) vid_match_v1b_end       <= 1'b1;else vid_match_v1b_end       <= 1'b0;
  if (vid_vcount == r_vid_tim_v1b_start    ) vid_match_v1b_start     <= 1'b1;else vid_match_v1b_start     <= 1'b0;
  if (vid_vcount == r_vid_tim_v1s_vend     ) vid_match_v1s_vend      <= 1'b1;else vid_match_v1s_vend      <= 1'b0;
  if (vid_vcount == r_vid_tim_v1s_vstart   ) vid_match_v1s_vstart    <= 1'b1;else vid_match_v1s_vstart    <= 1'b0;
  if (vid_vcount == r_vid_tim_v2b_end      ) vid_match_v2b_end       <= 1'b1;else vid_match_v2b_end       <= 1'b0;
  if (vid_vcount == r_vid_tim_v2b_start    ) vid_match_v2b_start     <= 1'b1;else vid_match_v2b_start     <= 1'b0;
  if (vid_vcount == r_vid_tim_v2s_vend     ) vid_match_v2s_vend      <= 1'b1;else vid_match_v2s_vend      <= 1'b0;
  if (vid_vcount == r_vid_tim_v2s_vstart   ) vid_match_v2s_vstart    <= 1'b1;else vid_match_v2s_vstart    <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse0_vstart) vid_match_pulse0_vstart <= 1'b1;else vid_match_pulse0_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse1_vstart) vid_match_pulse1_vstart <= 1'b1;else vid_match_pulse1_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse2_vstart) vid_match_pulse2_vstart <= 1'b1;else vid_match_pulse2_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse3_vstart) vid_match_pulse3_vstart <= 1'b1;else vid_match_pulse3_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse4_vstart) vid_match_pulse4_vstart <= 1'b1;else vid_match_pulse4_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse5_vstart) vid_match_pulse5_vstart <= 1'b1;else vid_match_pulse5_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse6_vstart) vid_match_pulse6_vstart <= 1'b1;else vid_match_pulse6_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse7_vstart) vid_match_pulse7_vstart <= 1'b1;else vid_match_pulse7_vstart <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse0_vend  ) vid_match_pulse0_vend   <= 1'b1;else vid_match_pulse0_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse1_vend  ) vid_match_pulse1_vend   <= 1'b1;else vid_match_pulse1_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse2_vend  ) vid_match_pulse2_vend   <= 1'b1;else vid_match_pulse2_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse3_vend  ) vid_match_pulse3_vend   <= 1'b1;else vid_match_pulse3_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse4_vend  ) vid_match_pulse4_vend   <= 1'b1;else vid_match_pulse4_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse5_vend  ) vid_match_pulse5_vend   <= 1'b1;else vid_match_pulse5_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse6_vend  ) vid_match_pulse6_vend   <= 1'b1;else vid_match_pulse6_vend   <= 1'b0;
  if (vid_vcount == r_vid_tim_pulse7_vend  ) vid_match_pulse7_vend   <= 1'b1;else vid_match_pulse7_vend   <= 1'b0;
  
end


//////////////////////////////////////////////////////////////////////
//
// Generate syncs and blanking from the h/v counter points
logic r_vid_vblank ;
logic r_vid_hblank ;
logic r_vid_vsync  ;
logic r_vid_hsync  ;
logic r_vid_f      ;
logic r_vid_pulse0 ;
logic r_vid_pulse1 ;
logic r_vid_pulse2 ;
logic r_vid_pulse3 ;
logic r_vid_pulse4 ;
logic r_vid_pulse5 ;
logic r_vid_pulse6 ;
logic r_vid_pulse7 ;
logic r_vid_clear0 ;
logic r_vid_clear1 ;
logic r_vid_clear2 ;
logic r_vid_clear3 ;
logic r_vid_clear4 ;
logic r_vid_clear5 ;
logic r_vid_clear6 ;
logic r_vid_clear7 ;

always_ff @(posedge vid_clk)
begin:a_make_blank
  if (vid_rst)
  begin
    r_vid_vblank  <= 1'b1;
    r_vid_hblank  <= 1'b1;
    r_vid_vsync   <= 1'b0;
    r_vid_hsync   <= 1'b0;
    r_vid_f       <= 1'b0;
    r_vid_pulse0  <= 1'b0;
    r_vid_pulse1  <= 1'b0;
    r_vid_pulse2  <= 1'b0;
    r_vid_pulse3  <= 1'b0;
    r_vid_pulse4  <= 1'b0;
    r_vid_pulse5  <= 1'b0;
    r_vid_pulse6  <= 1'b0;
    r_vid_pulse7  <= 1'b0;
    r_vid_clear0  <= 1'b0;
    r_vid_clear1  <= 1'b0;
    r_vid_clear2  <= 1'b0;
    r_vid_clear3  <= 1'b0;
    r_vid_clear4  <= 1'b0;
    r_vid_clear5  <= 1'b0;
    r_vid_clear6  <= 1'b0;
    r_vid_clear7  <= 1'b0;
  end
  else
  begin
    r_vid_clear0  <= 1'b0;
    r_vid_clear1  <= 1'b0;
    r_vid_clear2  <= 1'b0;
    r_vid_clear3  <= 1'b0;
    r_vid_clear4  <= 1'b0;
    r_vid_clear5  <= 1'b0;
    r_vid_clear6  <= 1'b0;
    r_vid_clear7  <= 1'b0;
  
    if (vid_match_v1b_start || vid_match_v2b_start)
      r_vid_vblank  <= 1'b1;
    else if (vid_match_v1b_end || vid_match_v2b_end)
      r_vid_vblank  <= 1'b0;
      
    if (vid_match_hfirst)
      r_vid_hblank  <= 1'b1;
    else if (vid_match_hbend)
      r_vid_hblank  <= 1'b0;

    if ((vid_match_v1s_hstart && vid_match_v1s_vstart) || (vid_match_v2s_hstart && vid_match_v2s_vstart))
      r_vid_vsync   <= 1'b1;
    else if ((vid_match_v1s_hend && vid_match_v1s_vend) || (vid_match_v2s_hend && vid_match_v2s_vend))
      r_vid_vsync   <= 1'b0;

    if (vid_match_hsstart)
      r_vid_hsync   <= 1'b1;
    else if (vid_match_hsend)
      r_vid_hsync   <= 1'b0;


    if (vid_match_f1_start)
      r_vid_f       <= 1'b0;
    else if (vid_match_f2_start)
      r_vid_f       <= 1'b1;

    if ((vid_match_pulse0_vstart && vid_match_pulse0_hstart) && (vid_match_pulse0_vend && vid_match_pulse0_hend)) begin r_vid_pulse0  <= 1'b1; r_vid_clear0  <= 1'b1; end else if (vid_match_pulse0_vstart && vid_match_pulse0_hstart)  r_vid_pulse0  <= ~r_vid_pulse0;  else if ((vid_match_pulse0_vend && vid_match_pulse0_hend) || (r_vid_clear0 == 1'b1)) r_vid_pulse0  <= 1'b0;
    if ((vid_match_pulse1_vstart && vid_match_pulse1_hstart) && (vid_match_pulse1_vend && vid_match_pulse1_hend)) begin r_vid_pulse1  <= 1'b1; r_vid_clear1  <= 1'b1; end else if (vid_match_pulse1_vstart && vid_match_pulse1_hstart)  r_vid_pulse1  <= ~r_vid_pulse1;  else if ((vid_match_pulse1_vend && vid_match_pulse1_hend) || (r_vid_clear1 == 1'b1)) r_vid_pulse1  <= 1'b0;
    if ((vid_match_pulse2_vstart && vid_match_pulse2_hstart) && (vid_match_pulse2_vend && vid_match_pulse2_hend)) begin r_vid_pulse2  <= 1'b1; r_vid_clear2  <= 1'b1; end else if (vid_match_pulse2_vstart && vid_match_pulse2_hstart)  r_vid_pulse2  <= ~r_vid_pulse2;  else if ((vid_match_pulse2_vend && vid_match_pulse2_hend) || (r_vid_clear2 == 1'b1)) r_vid_pulse2  <= 1'b0;
    if ((vid_match_pulse3_vstart && vid_match_pulse3_hstart) && (vid_match_pulse3_vend && vid_match_pulse3_hend)) begin r_vid_pulse3  <= 1'b1; r_vid_clear3  <= 1'b1; end else if (vid_match_pulse3_vstart && vid_match_pulse3_hstart)  r_vid_pulse3  <= ~r_vid_pulse3;  else if ((vid_match_pulse3_vend && vid_match_pulse3_hend) || (r_vid_clear3 == 1'b1)) r_vid_pulse3  <= 1'b0;
    if ((vid_match_pulse4_vstart && vid_match_pulse4_hstart) && (vid_match_pulse4_vend && vid_match_pulse4_hend)) begin r_vid_pulse4  <= 1'b1; r_vid_clear4  <= 1'b1; end else if (vid_match_pulse4_vstart && vid_match_pulse4_hstart)  r_vid_pulse4  <= ~r_vid_pulse4;  else if ((vid_match_pulse4_vend && vid_match_pulse4_hend) || (r_vid_clear4 == 1'b1)) r_vid_pulse4  <= 1'b0;
    if ((vid_match_pulse5_vstart && vid_match_pulse5_hstart) && (vid_match_pulse5_vend && vid_match_pulse5_hend)) begin r_vid_pulse5  <= 1'b1; r_vid_clear5  <= 1'b1; end else if (vid_match_pulse5_vstart && vid_match_pulse5_hstart)  r_vid_pulse5  <= ~r_vid_pulse5;  else if ((vid_match_pulse5_vend && vid_match_pulse5_hend) || (r_vid_clear5 == 1'b1)) r_vid_pulse5  <= 1'b0;
    if ((vid_match_pulse6_vstart && vid_match_pulse6_hstart) && (vid_match_pulse6_vend && vid_match_pulse6_hend)) begin r_vid_pulse6  <= 1'b1; r_vid_clear6  <= 1'b1; end else if (vid_match_pulse6_vstart && vid_match_pulse6_hstart)  r_vid_pulse6  <= ~r_vid_pulse6;  else if ((vid_match_pulse6_vend && vid_match_pulse6_hend) || (r_vid_clear6 == 1'b1)) r_vid_pulse6  <= 1'b0;
    if ((vid_match_pulse7_vstart && vid_match_pulse7_hstart) && (vid_match_pulse7_vend && vid_match_pulse7_hend)) begin r_vid_pulse7  <= 1'b1; r_vid_clear7  <= 1'b1; end else if (vid_match_pulse7_vstart && vid_match_pulse7_hstart)  r_vid_pulse7  <= ~r_vid_pulse7;  else if ((vid_match_pulse7_vend && vid_match_pulse7_hend) || (r_vid_clear7 == 1'b1)) r_vid_pulse7  <= 1'b0;
    
  end
end


//////////////////////////////////////////////////////////////////////
//
// Assign Outputs
//
// Useful parameters from the module declaration:
// C_NUM_PULSES           
// C_OUTPUT_IS_CV         
// C_CV_NUM_PLANES        
// C_CV_NUM_PIXELS        
// C_CV_BIT_DEPTH         
//
// r_vid_out_is_blank 
// r_vid_black        

logic [C_CV_PIXEL_BITS-1:0] late_vid_black;
logic                       late_vid_out_is_blank;

always_ff @(posedge vid_clk)
begin
  late_vid_black        <= r_vid_black;
  late_vid_out_is_blank <= r_vid_out_is_blank;
end

generate
  if (C_OUTPUT_IS_CV == 0) begin
    logic [2:0] r_vid_valid;
    logic r_vid_sof;
    logic r_vid_eol;

    logic [C_PADDED_PIXEL_BITS-1:0] late_vid_black_padded;

    always_ff @(posedge vid_clk)
    begin
      if (vid_rst) begin
        r_vid_valid <= 3'b0;
      end
      else begin
        r_vid_valid <= {r_vid_valid[1:0], 1'b1};
      end
    end

    always_ff @(posedge vid_clk)
    begin
      r_vid_sof <= vid_match_vfirst && vid_match_hfirst;
      r_vid_eol <= vid_match_hlast;
    end

    // Data padding for BPS < 8
    if (C_CV_BIT_DEPTH < 8) begin
      always_comb begin
        for (int j=0; j<C_CV_NUM_PLANES; j++) begin
          late_vid_black_padded[C_PADDED_BPS*j +: C_PADDED_BPS] = {
            late_vid_black[C_CV_BIT_DEPTH*j +: C_CV_BIT_DEPTH],
            late_vid_black[C_CV_BIT_DEPTH*(j+1)-1 -: 8-C_CV_BIT_DEPTH]
          };
        end
      end
    end
    else begin
      assign late_vid_black_padded = late_vid_black;
    end

    always_comb
    begin
      // tie-off the cv bus    
      cv_vid_out_data   = {C_CV_WIDTH{1'b0}};
      cv_vid_out_active = {C_CV_NUM_PIXELS{1'b0}};
      cv_vid_out_f      = {C_CV_NUM_PIXELS{1'b0}};
      cv_vid_out_h      = {C_CV_NUM_PIXELS{1'b0}};
      cv_vid_out_v      = {C_CV_NUM_PIXELS{1'b0}};
      cv_vid_out_h_sync = {C_CV_NUM_PIXELS{1'b0}};
      cv_vid_out_v_sync = {C_CV_NUM_PIXELS{1'b0}};
          
      axi4s_fr_vid_out_tvalid   = r_vid_valid[2];

      axi4s_fr_vid_out_tlast    = r_vid_eol;

      axi4s_fr_vid_out_tuser    = {C_TUSER_WIDTH{1'b0}};
      axi4s_fr_vid_out_tuser[0] = r_vid_sof;

      axi4s_fr_vid_out_tdata    = {C_AXIS_WIDTH{1'b0}};
      for (int i=0;i<C_CV_NUM_PIXELS;i=i+1)
      begin
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i + C_BIT_FIELD]          = r_vid_f;
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i + C_BIT_V]              = late_vid_out_is_blank ? r_vid_vblank : r_vid_vsync;
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i + C_BIT_H]              = late_vid_out_is_blank ? r_vid_hblank : r_vid_hsync;
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i + C_BIT_DE]             = ~r_vid_hblank && ~r_vid_vblank;
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i + C_BIT_SYNC_MODE]      = late_vid_out_is_blank; // r_vid_out_is_blank=0 -> output is sync. r_vid_out_is_blank=1 -> output is blanking
        axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*i +: C_PADDED_PIXEL_BITS] = late_vid_black_padded;
      end
      axi4s_fr_vid_out_tdata[                                           C_BIT_SOF] = r_vid_sof;
      axi4s_fr_vid_out_tdata[C_AXIS_PIXEL_BYTES*8*(C_CV_NUM_PIXELS-1) + C_BIT_EOL] = r_vid_eol;
    end
  end
  else begin
    always_comb
    begin:a_make_cv
      // tie-off the unused axi4 bus
      axi4s_fr_vid_out_tlast  = 1'b0;
      axi4s_fr_vid_out_tuser  = {C_TUSER_WIDTH{1'b0}};
      axi4s_fr_vid_out_tvalid = 1'b0;
      axi4s_fr_vid_out_tdata  = {C_AXIS_WIDTH{1'b0}};
   
      for (int i=0;i<C_CV_NUM_PIXELS;i=i+1)
      begin
        cv_vid_out_data  [C_CV_PIXEL_BITS*i +:C_CV_PIXEL_BITS] = late_vid_black;
        cv_vid_out_active[i] = ~r_vid_hblank && ~r_vid_vblank;
        cv_vid_out_f     [i] = r_vid_f;
        cv_vid_out_h     [i] = r_vid_hblank && late_vid_out_is_blank;
        cv_vid_out_v     [i] = r_vid_vblank && late_vid_out_is_blank;
        cv_vid_out_h_sync[i] = r_vid_hsync && ~late_vid_out_is_blank;
        cv_vid_out_v_sync[i] = r_vid_vsync && ~late_vid_out_is_blank;
      end
    end
  end
endgenerate

always_comb
begin:a_make_pulses
  pulse0 = 1'b0;
  pulse1 = 1'b0;
  pulse2 = 1'b0;
  pulse3 = 1'b0;
  pulse4 = 1'b0;
  pulse5 = 1'b0;
  pulse6 = 1'b0;
  pulse7 = 1'b0;
  if (C_NUM_PULSES>0) pulse0 = r_vid_pulse0;
  if (C_NUM_PULSES>1) pulse1 = r_vid_pulse1;
  if (C_NUM_PULSES>2) pulse2 = r_vid_pulse2;
  if (C_NUM_PULSES>3) pulse3 = r_vid_pulse3;
  if (C_NUM_PULSES>4) pulse4 = r_vid_pulse4;
  if (C_NUM_PULSES>5) pulse5 = r_vid_pulse5;
  if (C_NUM_PULSES>6) pulse6 = r_vid_pulse6;
  if (C_NUM_PULSES>7) pulse7 = r_vid_pulse7;
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4c+3nmzOPVMW6eEuUZNGwsJWmgjPPXo+fxGujFidbwzDbbZJGAqLLP+GK1+dtcXM+PrpkjYVLDgGauv5zlFIZKtlY58uqq+veIdLMz61FcT7vI9J9CWvA8BAGJ+lhMlhBGGQqi4+ytKAvaXBIP4cxKm0TACtchuYCvaNZj8XwcTt2lEVIYE9miULt0k2+NoXToRWvXrlmKwPy8FswR3b7UdRkSE+9UgT6jxJC8ekSwy2kCV5c4TuAGgA5o5RcJFeTsZJMi9TSq6QsQxO9FkBDNRwmQeo+Cvvu2jNxpDbFflOTxvQbzYXXABLMMxf9S8Ol/ygQ7JperBolwAL188PAojTXhUh8ilUcGcQ/jmkz6Ety4WOnMnIB4ub9Mwf/eAaADvfhiauI05PffioGmuz+vUfJE44k4NLV3AMsoTOpUbGfJAivkXPkAAY3dNikYNWKg13EVvPT35OU8XXlMbKeRRHJteufUqKsjqvcwlevHP8jcughTSFHg0ayfTbmNPGTPHrHcky+X2UM5bhUTwDn28GMDY3WPuBME9JV31l4DrMYb0n0LPXnG+4kHKfDKP/sWxQ6L92blDCiPO72TKUR2bB5/InubNuynUpOThBH11OHac61BhgGJp2aJbI4VArFigHUftIFVnspXuY1cFSdhyappTv+WEPZDgyg7LUQUfsjzuAocJb5ai3v+RAZ/OmU6j7pB+YbT6ZAcJfOH+r1qzV3gKpGMnrQD3L9FleHUeSQmO0LBBGmEQisU4qHY8qnz4Bgbo1bNog30APooYVUN02k0smLgv9On/fUR5PX1IsjEuSycWJsAnOgu0Qy651/hStUeIAI4+5cbgrs0mRHUJ2R1v8b4wsVZB2zGbKXW3zka9kUxdbsJvBH8CCkrlEj+UKy5Xe3PTqDcjDEeVxaE8FW6eS2N/1TsGwQU8M69DcuCWaOCyWVY7erfeunMVRPIukm88kiXsNRHEY3p0uJmZthg4qKLtDH1W3L3uZ023uKu+ikYvq0PVgsqQhpZNe"
`endif