// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Tue May  6 13:18:29 2025y94d04
// ============================================================================


module golden_top(

      ///////// CLOCK /////////
      input              CLOCK0_50,
      input              CLOCK1_50,
      input              CLOCK2_50,
      input              CLOCK3_50,

      ///////// KEY /////////
      input    [ 1: 0]   KEY, //KEY is Low-Active

      ///////// FPGA /////////
      output             FPGA_UART_TX,
      input              FPGA_UART_RX,

      ///////// SW /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 3: 0]   LED, //LED is Low-Active

      ///////// SDRAM /////////
      output             DRAM_CLK,
      output             DRAM_CKE,
      output   [12: 0]   DRAM_ADDR,
      output   [ 1: 0]   DRAM_BA,
      inout    [31: 0]   DRAM_DQ,
      output             DRAM_CS_n,
      output             DRAM_WE_n,
      output             DRAM_CAS_n,
      output             DRAM_RAS_n,
      output   [ 3: 0]   DRAM_DQM,

      ///////// SD /////////
      output             SD_CLK,
      inout    [ 3: 0]   SD_DATA,
      inout              SD_CMD,

      ///////// HDMI /////////
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      output             HDMI_ISEL,
      output             HDMI_PD_n,
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,

      ///////// NET /////////
      output             NET_TX_CLK,
      output   [ 3: 0]   NET_TX_DATA,
      output             NET_TX_CTRL,
      input              NET_RX_CLK,
      input    [ 3: 0]   NET_RX_DATA,
      input              NET_RX_CTRL,
      output             NET_MDC,
      inout              NET_MDIO,
      output             NET_RESET_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

      ///////// TMD0 /////////
      inout    [ 7: 0]   TMD0_D,

      ///////// TMD1 /////////
      inout    [ 7: 0]   TMD1_D

);


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================

assign reset_n = !ninit_done; 
wire ninit_done;
agilex_reset_release reset_release_Inst (
	.ninit_done(ninit_done)
	);
	

	
wire beat;
heart_beat heart_beat_clk50(
	.clk(CLOCK0_50),
	.led(beat)
	);


assign LED = (!KEY[0])?4'h0:
				 (!KEY[1])?4'hf:{~PWM_width[6],~PWM_width[6],~PWM_width[6],~PWM_width[6]};


reg 	[27:0] 	counter;
reg 	[5:0]   PWM_adj;
reg   [6:0]   PWM_width;
always @(posedge CLOCK1_50 or negedge reset_n)
begin
	if(!reset_n)
		begin
			counter <= 0;
		end
	else 
	begin
		counter   <= counter+1;
		PWM_width <= PWM_width[5:0]+ PWM_adj;
		if(counter[26])
		begin
			PWM_adj <= counter[25:20];
		end
		else 
		begin
			PWM_adj <= ~ counter[25:20];
		end
	end
end



pll pll_Inst (
    .refclk   (CLOCK1_50),   //   input,  width = 1,  refclk.clk
    .locked   (),   //  output,  width = 1,  locked.export
    .rst      (!reset_n),      //   input,  width = 1,   reset.reset
    .outclk_0 (clk_74p25)  //  output,  width = 1, outclk0.clk
);
wire clk_74p25;

assign HDMI_ISEL = reset_n; // I2C mode
assign HDMI_PD_n = 1'b0; // In I2C mode, pin should be tied to GND
	 
//HDMI I2C
I2C_HDMI_Config u_I2C_HDMI_Config (
	.iCLK(CLOCK0_50),
	.iRST_N(reset_n),
	.I2C_SCLK(HDMI_I2C_SCL),
	.I2C_SDAT(HDMI_I2C_SDA)
	 );
	 

vga_controller vga_ins(.iRST_n(reset_n),
                      .iVGA_CLK(disp_clk),
                      .oBLANK_n(disp_de),
                      .oHS(disp_hs),
                      .oVS(disp_vs),
                      .b_data(disp_data[7:0]),
                      .g_data(disp_data[15:8]),
                      .r_data(disp_data[23:16]));	
		 
 
/////////////////////////	 
// VVP to HDMI OUTPUT	 
// VVP output
wire [23: 0] disp_data;
wire disp_clk;
wire disp_hs;
wire disp_vs;
wire disp_de;

assign disp_clk = clk_74p25; 

assign HDMI_TX_D = disp_data;	 
assign HDMI_TX_CLK_p = disp_clk;
assign HDMI_TX_HS = disp_hs;
assign HDMI_TX_VS = disp_vs;
assign HDMI_TX_DE = disp_de;		  
	 
endmodule
